/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.problems.scheduling.IJobSchedulingInput;
import ai.libs.jaicore.problems.scheduling.IScheduleComputer;
import ai.libs.jaicore.problems.scheduling.Job;
import ai.libs.jaicore.problems.scheduling.Machine;
import ai.libs.jaicore.problems.scheduling.Operation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ASchedulingComputer
implements IScheduleComputer {
    @Override
    public void fillTimes(IJobSchedulingInput problemInput, List<Pair<Operation, Machine>> assignments, Map<Job, Integer> arrivalTimes, Map<Operation, Integer> startTimes, Map<Operation, Integer> endTimes, Map<Operation, Integer> setupStartTimes, Map<Operation, Integer> setupEndTimes) {
        startTimes.clear();
        endTimes.clear();
        setupStartTimes.clear();
        setupEndTimes.clear();
        HashMap<Job, Integer> jobReadyness = new HashMap<Job, Integer>();
        HashMap<Machine, Integer> machineReadyness = new HashMap<Machine, Integer>();
        HashMap<Machine, Integer> machineStates = new HashMap<Machine, Integer>();
        for (Pair<Operation, Machine> p : assignments) {
            int requiredMachineState;
            Machine m = p.getY();
            Operation o = p.getX();
            int timeWhenMachineBecomesAvailableForOperation = this.getTimeWhenMachineBecomesAvailableForOperation(arrivalTimes, machineReadyness, m);
            int timeWhenJobArrivesAtMachine = this.timeWhenOperationArrivesAtMachine(arrivalTimes, machineReadyness, jobReadyness, o, m);
            int actualMachineState = machineStates.computeIfAbsent(m, Machine::getInitialState);
            int setupTime = actualMachineState == (requiredMachineState = o.getStatus()) ? 0 : m.getWorkcenter().getSetupMatrix()[actualMachineState][requiredMachineState];
            int timeWhenMachineIsReadyToProcessOperation = timeWhenMachineBecomesAvailableForOperation + setupTime;
            int startTime = Math.max(timeWhenMachineIsReadyToProcessOperation, timeWhenJobArrivesAtMachine);
            int endTime = startTime + o.getProcessTime();
            setupStartTimes.put(o, timeWhenMachineBecomesAvailableForOperation);
            setupEndTimes.put(o, timeWhenMachineIsReadyToProcessOperation);
            startTimes.put(o, startTime);
            endTimes.put(o, endTime);
            machineReadyness.put(m, endTime);
            machineStates.put(m, o.getStatus());
            jobReadyness.put(o.getJob(), endTime);
        }
    }

    public abstract int getTimeWhenMachineBecomesAvailableForOperation(Map<Job, Integer> var1, Map<Machine, Integer> var2, Machine var3);

    public abstract int timeWhenOperationArrivesAtMachine(Map<Job, Integer> var1, Map<Machine, Integer> var2, Map<Job, Integer> var3, Operation var4, Machine var5);
}

