/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling;

import ai.libs.jaicore.problems.scheduling.IJobSchedulingInput;
import ai.libs.jaicore.problems.scheduling.Job;
import ai.libs.jaicore.problems.scheduling.JobSchedulingProblemInput;
import ai.libs.jaicore.problems.scheduling.JobShopMetric;
import ai.libs.jaicore.problems.scheduling.Machine;
import ai.libs.jaicore.problems.scheduling.Operation;
import ai.libs.jaicore.problems.scheduling.Workcenter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JobSchedulingProblemBuilder {
    private final Map<String, Workcenter> workcenters = new HashMap<String, Workcenter>();
    private final Map<String, Job> jobs = new HashMap<String, Job>();
    private final Map<String, Machine> machines = new HashMap<String, Machine>();
    private final Map<String, Operation> operations = new HashMap<String, Operation>();
    private JobShopMetric metric;
    private int latestArrivalTime = -1;

    public JobSchedulingProblemBuilder fork() {
        JobSchedulingProblemBuilder copy = new JobSchedulingProblemBuilder();
        copy.workcenters.putAll(this.workcenters);
        copy.jobs.putAll(this.jobs);
        copy.machines.putAll(this.machines);
        copy.operations.putAll(this.operations);
        copy.metric = this.metric;
        return copy;
    }

    public JobSchedulingProblemBuilder withWorkcenter(String workcenterID, int[][] setupMatrix) {
        if (this.workcenters.containsKey(workcenterID)) {
            throw new IllegalArgumentException(String.format("Workcenter with id %s already exists", workcenterID));
        }
        this.workcenters.put(workcenterID, new Workcenter(workcenterID, setupMatrix));
        return this;
    }

    public JobSchedulingProblemBuilder singleStaged() {
        return this.withWorkcenter("W", null);
    }

    public JobSchedulingProblemBuilder singleOperationAndSingleMachine() {
        this.singleStaged();
        return this.withMachineForWorkcenter("M", "W", 0, 0);
    }

    public JobSchedulingProblemBuilder withParallelMachines(int k) {
        this.machines.clear();
        for (Map.Entry<String, Workcenter> wcEntry : this.workcenters.entrySet()) {
            for (int i = 0; i < k; ++i) {
                String machineName = wcEntry.getKey() + "_M" + i;
                this.withMachineForWorkcenter(machineName, wcEntry.getKey(), 0, 0);
            }
        }
        return this;
    }

    public JobSchedulingProblemBuilder withJob(String jobID, int releaseDate, int dueDate, int weight) {
        if (this.jobs.containsKey(jobID)) {
            throw new IllegalArgumentException(String.format("A job with ID %s has already been defined.", jobID));
        }
        this.jobs.put(jobID, new Job(jobID, releaseDate, dueDate, weight));
        return this;
    }

    public JobSchedulingProblemBuilder withSingleOpJob(int processingTime, int weight) {
        int id = 1;
        String jobId = "J" + id;
        while (this.jobs.containsKey(jobId)) {
            jobId = "J" + ++id;
        }
        this.withJob(jobId, 0, 0, weight);
        id = 1;
        String opId = "O" + id;
        while (this.operations.containsKey(opId)) {
            opId = "O" + ++id;
        }
        this.withOperationForJob(opId, jobId, processingTime, 0, "W");
        return this;
    }

    public JobSchedulingProblemBuilder withOperationForJob(String operationId, String jobId, int processTime, int status, String wcId) {
        Workcenter wc = this.workcenters.get(wcId);
        Job job = this.jobs.get(jobId);
        if (wc == null) {
            throw new IllegalArgumentException(String.format("No workcenter with id %s has been defined!", wcId));
        }
        if (job == null) {
            throw new IllegalArgumentException(String.format("No job with id %s has been defined", jobId));
        }
        if (this.operations.containsKey(operationId)) {
            throw new IllegalArgumentException(String.format("There is already an operation with name \"%s\" defined (in job %s)", operationId, this.operations.get(operationId).getJob().getJobID()));
        }
        this.operations.put(operationId, new Operation(operationId, processTime, status, job, wc));
        return this;
    }

    public JobSchedulingProblemBuilder withMachineForWorkcenter(String machineId, String wcId, int availability, int initialState) {
        Workcenter wc = this.workcenters.get(wcId);
        if (wc == null) {
            throw new IllegalArgumentException(String.format("No workcenter with id %s has been defined!", wcId));
        }
        if (this.machines.containsKey(machineId)) {
            throw new IllegalArgumentException(String.format("Machine with id %s has already been defined (for work center %s)", machineId, this.machines.get(machineId).getWorkcenter().getWorkcenterID()));
        }
        this.machines.put(machineId, new Machine(machineId, availability, initialState, wc));
        return this;
    }

    public JobSchedulingProblemBuilder withMetric(JobShopMetric metric) {
        this.metric = metric;
        return this;
    }

    public JobSchedulingProblemBuilder withLatestArrivalTime(int latestArrivalTime) {
        this.latestArrivalTime = latestArrivalTime;
        return this;
    }

    public IJobSchedulingInput build() {
        if (this.metric == null) {
            throw new IllegalStateException("No metric for schedule evaluation has been defined.");
        }
        return new JobSchedulingProblemInput(new HashMap<String, Job>(this.jobs), new HashMap<String, Workcenter>(this.workcenters), new HashMap<String, Operation>(this.operations), new HashMap<String, Machine>(this.machines), this.metric, this.latestArrivalTime);
    }

    public Map<String, Job> getJobs() {
        return Collections.unmodifiableMap(this.jobs);
    }

    public Map<String, Workcenter> getWorkcenters() {
        return Collections.unmodifiableMap(this.workcenters);
    }

    public Map<String, Operation> getOperations() {
        return Collections.unmodifiableMap(this.operations);
    }

    public Map<String, Machine> getMachines() {
        return Collections.unmodifiableMap(this.machines);
    }

    public Workcenter getWorkcenter(String workcenterId) {
        return this.workcenters.get(workcenterId);
    }

    public Machine getMachine(String machineId) {
        return this.machines.get(machineId);
    }

    public Operation getOperation(String operationId) {
        return this.operations.get(operationId);
    }

    public Job getJob(String jobId) {
        return this.jobs.get(jobId);
    }
}

