/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling;

import ai.libs.jaicore.problems.scheduling.IJobSchedulingInput;
import ai.libs.jaicore.problems.scheduling.ISchedule;
import ai.libs.jaicore.problems.scheduling.Job;
import ai.libs.jaicore.problems.scheduling.JobShopMetric;
import ai.libs.jaicore.problems.scheduling.Machine;
import ai.libs.jaicore.problems.scheduling.Operation;
import ai.libs.jaicore.problems.scheduling.Workcenter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JobSchedulingProblemInput
implements IJobSchedulingInput {
    private final Map<String, Job> jobs;
    private final Map<String, Workcenter> workcenters;
    private final Map<String, Operation> operations;
    private final Map<String, Machine> machines;
    private final JobShopMetric metric;
    private final int latestArrivalTime;

    public JobSchedulingProblemInput(Collection<Job> jobs, Collection<Workcenter> workcenters, Collection<Operation> operations, Collection<Machine> machines, JobShopMetric metric, int latestArrivalTime) {
        this.jobs = new HashMap<String, Job>();
        jobs.forEach(j -> this.jobs.put(j.getJobID(), (Job)j));
        this.workcenters = new HashMap<String, Workcenter>();
        workcenters.forEach(j -> this.workcenters.put(j.getWorkcenterID(), (Workcenter)j));
        this.operations = new HashMap<String, Operation>();
        operations.forEach(j -> this.operations.put(j.getName(), (Operation)j));
        this.machines = new HashMap<String, Machine>();
        machines.forEach(j -> this.machines.put(j.getMachineID(), (Machine)j));
        this.metric = metric;
        this.latestArrivalTime = latestArrivalTime;
    }

    public JobSchedulingProblemInput(Map<String, Job> jobs, Map<String, Workcenter> workcenters, Map<String, Operation> operations, Map<String, Machine> machines, JobShopMetric metric, int latestArrivalTime) {
        this.jobs = jobs;
        this.workcenters = workcenters;
        this.operations = operations;
        this.machines = machines;
        this.metric = metric;
        this.latestArrivalTime = latestArrivalTime;
    }

    @Override
    public Collection<Job> getJobs() {
        return this.jobs.values();
    }

    @Override
    public Collection<Workcenter> getWorkcenters() {
        return this.workcenters.values();
    }

    @Override
    public Collection<Operation> getOperations() {
        return this.operations.values();
    }

    @Override
    public Collection<Machine> getMachines() {
        return this.machines.values();
    }

    @Override
    public JobShopMetric getMetric() {
        return this.metric;
    }

    public int getLatestArrivalTime() {
        return this.latestArrivalTime;
    }

    @Override
    public Workcenter getWorkcenter(String workcenterId) {
        return this.workcenters.get(workcenterId);
    }

    @Override
    public Machine getMachine(String machineId) {
        return this.machines.get(machineId);
    }

    @Override
    public Operation getOperation(String operationId) {
        return this.operations.get(operationId);
    }

    @Override
    public Job getJob(String jobId) {
        return this.jobs.get(jobId);
    }

    @Override
    public double getScoreOfSchedule(ISchedule s) {
        Objects.requireNonNull(s);
        return this.metric.getScore(this, s);
    }

    public int getTotalProcessingTime() {
        return this.operations.values().stream().map(Operation::getProcessTime).reduce((a, b) -> a + b).get();
    }

    public void printWorkcenters(OutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        int n = this.workcenters.size();
        sb.append("Number of work centers \t" + n);
        sb.append("\n\n");
        for (Workcenter w : this.workcenters.values().stream().sorted((w1, w2) -> w1.getWorkcenterID().compareTo(w2.getWorkcenterID())).collect(Collectors.toList())) {
            sb.append(w.getWorkcenterID());
            sb.append(" (" + w.getMachines().size() + " machines)");
            sb.append("\n");
            for (Machine m : w.getMachines()) {
                sb.append("Machine: \t" + m.getMachineID());
                sb.append("\tAvailability: " + m.getAvailableDate() + "\t Init state: ");
                sb.append(m.getInitialState());
                sb.append("\n");
            }
            sb.append("\n");
        }
        out.write(sb.toString().getBytes());
    }

    public void printJobs(OutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        int n = this.jobs.size();
        sb.append("Number of Jobs \t" + n);
        sb.append("\n\n");
        for (Job j : this.jobs.values().stream().sorted((j1, j2) -> j1.getJobID().compareTo(j2.getJobID())).collect(Collectors.toList())) {
            sb.append(j.getJobID());
            sb.append("\n");
            sb.append("Release Date \t" + j.getReleaseDate());
            sb.append("\n");
            sb.append("Due Date \t" + j.getDueDate());
            sb.append("\n");
            sb.append("Weight \t \t" + j.getWeight());
            sb.append("\n");
            for (Operation op : j.getOperations()) {
                sb.append("Operation: \t" + op.getName());
                sb.append("\tWC: " + op.getWorkcenter().getWorkcenterID());
                sb.append("\tProcess time: " + op.getProcessTime() + "\t Status: ");
                sb.append(op.getStatus());
                sb.append("\n");
            }
            sb.append("\n");
        }
        out.write(sb.toString().getBytes());
    }
}

