/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling;

import ai.libs.jaicore.problems.scheduling.IJobSchedulingInput;
import ai.libs.jaicore.problems.scheduling.ISchedule;
import ai.libs.jaicore.problems.scheduling.Job;
import ai.libs.jaicore.problems.scheduling.JobSchedulingProblemInput;
import java.util.function.BiFunction;

public enum JobShopMetric {
    TOTALFLOWTIME((p, s) -> p.getJobs().stream().mapToInt(s::getJobFlowTime).reduce((r, c) -> r + c).getAsInt()),
    TOTALTARDINESS((p, s) -> p.getJobs().stream().mapToInt(s::getJobTardiness).reduce((r, c) -> r + c).getAsInt()),
    TOTALFLOWTIME_WEIGHTED((p, s) -> p.getJobs().stream().mapToInt(j -> j.getWeight() * s.getJobFlowTime((Job)j)).reduce((r, c) -> r + c).getAsInt()),
    TOTALTARDINESS_WEIGHTED((p, s) -> p.getJobs().stream().mapToInt(j -> j.getWeight() * s.getJobTardiness((Job)j)).reduce((r, c) -> r + c).getAsInt()),
    MAKESPAN((p, s) -> (double)p.getOperations().stream().map(s::getEndTimeOfOperation).max(Double::compare).get()),
    MAXTARDINESS((p, s) -> p.getJobs().stream().mapToInt(s::getJobTardiness).max().getAsInt()),
    NUM_TARDY_JOB((p, s) -> p.getJobs().stream().filter(j -> s.getJobTardiness((Job)j) > 0).count());

    private final BiFunction<IJobSchedulingInput, ISchedule, Double> metricFunction;

    private JobShopMetric(BiFunction<IJobSchedulingInput, ISchedule, Double> metricFunction) {
        this.metricFunction = metricFunction;
    }

    public double getScore(JobSchedulingProblemInput problem, ISchedule schedule) {
        if (problem.getJobs().isEmpty()) {
            throw new IllegalArgumentException("Cannot get score for a problem that has no jobs!");
        }
        return this.metricFunction.apply(problem, schedule);
    }
}

