/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.problems.scheduling.IJobSchedulingInput;
import ai.libs.jaicore.problems.scheduling.ISchedule;
import ai.libs.jaicore.problems.scheduling.IScheduleComputer;
import ai.libs.jaicore.problems.scheduling.Job;
import ai.libs.jaicore.problems.scheduling.Machine;
import ai.libs.jaicore.problems.scheduling.Operation;
import ai.libs.jaicore.problems.scheduling.Workcenter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Schedule
implements ISchedule {
    private final List<Pair<Operation, Machine>> assignments;
    private final Map<Machine, List<Operation>> assignmentPerMachine = new HashMap<Machine, List<Operation>>();
    private final Map<Job, Integer> arrivalTimes = new HashMap<Job, Integer>();
    private final Map<Operation, Integer> startTimes = new HashMap<Operation, Integer>();
    private final Map<Operation, Integer> endTimes = new HashMap<Operation, Integer>();
    private final Map<Operation, Integer> setupStartTimes = new HashMap<Operation, Integer>();
    private final Map<Operation, Integer> setupEndTimes = new HashMap<Operation, Integer>();

    Schedule(IJobSchedulingInput problemInput, List<Pair<Operation, Machine>> assignments, IScheduleComputer schedulingComputer) {
        this.assignments = assignments;
        this.assignments.forEach(p -> this.assignmentPerMachine.computeIfAbsent((Machine)p.getY(), m -> new ArrayList()).add((Operation)p.getX()));
        schedulingComputer.fillTimes(problemInput, assignments, this.arrivalTimes, this.startTimes, this.endTimes, this.setupStartTimes, this.setupEndTimes);
        for (Operation o : problemInput.getOperations()) {
            if (this.arrivalTimes.containsKey(o.getJob())) continue;
            throw new IllegalStateException("No arrival time defined for job " + o.getJob().getJobID());
        }
    }

    @Override
    public List<Pair<Operation, Machine>> getAssignments() {
        return this.assignments;
    }

    @Override
    public List<Operation> getOperationsAssignedToMachine(Machine m) {
        return this.assignmentPerMachine.get(m);
    }

    @Override
    public List<Operation> getOrderOfOperationsForJob(Job job) {
        return this.assignments.stream().map(Pair::getX).filter(o -> o.getJob().equals(job)).collect(Collectors.toList());
    }

    @Override
    public int getStartTimeOfOperation(Operation o) {
        return this.startTimes.get(o);
    }

    @Override
    public int getEndTimeOfOperation(Operation o) {
        return this.endTimes.get(o);
    }

    @Override
    public int getSetupStartTimeOfOperation(Operation o) {
        return this.setupStartTimes.get(o);
    }

    @Override
    public int getSetupEndTimeOfOperation(Operation o) {
        return this.setupEndTimes.get(o);
    }

    @Override
    public int getJobFinishTime(Job job) {
        return job.getOperations().stream().map(this::getEndTimeOfOperation).max(Double::compare).get();
    }

    @Override
    public int getJobFlowTime(Job job) {
        return this.getJobFinishTime(job) - this.arrivalTimes.get(job);
    }

    @Override
    public int getJobTardiness(Job job) {
        return Math.max(0, this.getJobFinishTime(job) - job.getDueDate());
    }

    public String getAsString() {
        StringBuilder sb = new StringBuilder();
        List workcenters = this.assignmentPerMachine.keySet().stream().map(Machine::getWorkcenter).collect(Collectors.toSet()).stream().sorted((w1, w2) -> w1.getWorkcenterID().compareTo(w2.getWorkcenterID())).collect(Collectors.toList());
        for (Workcenter wc : workcenters) {
            sb.append("-------------------------------------------------------------------------------------------------\n");
            sb.append(wc.getWorkcenterID());
            sb.append("\n-------------------------------------------------------------------------------------------------\n");
            for (Machine m : wc.getMachines()) {
                sb.append("\t" + m.getMachineID() + " (init state " + m.getInitialState() + "): ");
                List<Operation> ops = this.getOperationsAssignedToMachine(m);
                if (ops != null) {
                    StringBuilder opSB = new StringBuilder();
                    for (Operation o : ops) {
                        int setupEndTime;
                        int setupStartTime;
                        if (opSB.length() != 0) {
                            opSB.append(" -> ");
                        }
                        if ((setupStartTime = this.setupStartTimes.get(o).intValue()) != (setupEndTime = this.setupEndTimes.get(o).intValue())) {
                            opSB.append("modify state to " + o.getStatus() + " -> ");
                        }
                        opSB.append(o.getName() + " (of job " + o.getJob().getJobID() + " from " + this.startTimes.get(o) + " to " + this.endTimes.get(o) + ")");
                    }
                    sb.append((CharSequence)opSB);
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String getGanttAsString() {
        StringBuilder sb = new StringBuilder();
        List workcenters = this.assignmentPerMachine.keySet().stream().map(Machine::getWorkcenter).collect(Collectors.toSet()).stream().sorted((w1, w2) -> w1.getWorkcenterID().compareTo(w2.getWorkcenterID())).collect(Collectors.toList());
        for (Workcenter wc : workcenters) {
            sb.append("-------------------------------------------------------------------------------------------------\n");
            sb.append(wc.getWorkcenterID());
            sb.append("\n-------------------------------------------------------------------------------------------------\n");
            for (Machine m : wc.getMachines()) {
                sb.append("\t" + m.getMachineID() + " (init state " + m.getInitialState() + "): ");
                List<Operation> ops = this.getOperationsAssignedToMachine(m);
                int curTime = 0;
                if (ops != null) {
                    StringBuilder opSB = new StringBuilder();
                    int lastStatus = m.getInitialState();
                    for (Operation o : ops) {
                        boolean needsSetup = false;
                        if (m.getWorkcenter().getSetupMatrix() != null) {
                            sb.append(lastStatus + " -> " + o.getStatus() + ": " + m.getWorkcenter().getSetupMatrix()[lastStatus][o.getStatus()]);
                            needsSetup = m.getWorkcenter().getSetupMatrix()[lastStatus][o.getStatus()] != 0;
                        }
                        lastStatus = o.getStatus();
                        int setupStartTime = this.setupStartTimes.get(o);
                        int setupEndTime = this.setupEndTimes.get(o);
                        int startTime = this.startTimes.get(o);
                        int endTime = this.endTimes.get(o);
                        sb.append(o.getName() + " (" + m.getMachineID() + "): " + setupStartTime + ", " + setupEndTime + ", " + startTime + ", " + endTime);
                        sb.append(needsSetup);
                        if (needsSetup) {
                            while (curTime < setupStartTime) {
                                sb.append(" ");
                                ++curTime;
                            }
                            sb.append("|");
                            ++curTime;
                            while (curTime < setupEndTime) {
                                sb.append("+");
                                ++curTime;
                            }
                            while (curTime < startTime) {
                                sb.append("?");
                                ++curTime;
                            }
                        } else {
                            while (curTime < startTime) {
                                sb.append(" ");
                                ++curTime;
                            }
                        }
                        sb.append("|");
                        int spaceForLabeling = endTime - startTime;
                        int whiteSpace = Math.max(0, spaceForLabeling - o.getName().length());
                        int whiteSpaceLeft = whiteSpace / 2;
                        int startLabeling = startTime + whiteSpaceLeft;
                        while (curTime < startLabeling) {
                            sb.append(" ");
                            ++curTime;
                        }
                        sb.append(o.getName());
                        curTime += o.getName().length();
                        while (curTime < endTime) {
                            sb.append(" ");
                            ++curTime;
                        }
                        if (endTime - startTime <= 1) continue;
                        sb.append("|");
                    }
                    sb.append((CharSequence)opSB);
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public boolean isActive() {
        for (Operation o : this.setupEndTimes.keySet()) {
            if (!this.canOperationBeScheduledEarlierWithoutAnyOtherEffect(o)) continue;
            return false;
        }
        return true;
    }

    public boolean canOperationBeScheduledEarlierWithoutAnyOtherEffect(Operation o) {
        Job j = o.getJob();
        int requiredTime = o.getProcessTime();
        List otherOpsOfJobStartingEarlier = j.getOperations().stream().filter(op -> this.endTimes.containsKey(op) && this.endTimes.get(op) <= this.startTimes.get(o)).sorted((o1, o2) -> Integer.compare(this.startTimes.get(o1), this.startTimes.get(o2))).collect(Collectors.toList());
        if (otherOpsOfJobStartingEarlier.isEmpty()) {
            int start = 0;
            int end = this.endTimes.get(o);
            for (Machine m : o.getWorkcenter().getMachines()) {
                if (this.getEarliestTimeWhenMachineIsFreeForDurationInInterval(m, start, end, o) == -1) continue;
                return true;
            }
        } else {
            int endTimeOfLast = 0;
            for (Operation otherOp : otherOpsOfJobStartingEarlier) {
                int timeOfThis = this.endTimes.get(otherOp);
                if (timeOfThis - endTimeOfLast > requiredTime) {
                    int start = endTimeOfLast;
                    int end = timeOfThis;
                    for (Machine m : o.getWorkcenter().getMachines()) {
                        if (this.getEarliestTimeWhenMachineIsFreeForDurationInInterval(m, start, end, o) == -1) continue;
                        return true;
                    }
                }
                endTimeOfLast = this.endTimes.get(otherOp);
            }
        }
        return false;
    }

    public int getEarliestTimeWhenMachineIsFreeForDurationInInterval(Machine m, int start, int end, Operation op) {
        List opsOnMachineDuringThatTime = this.getOperationsAssignedToMachine(m).stream().filter(o -> this.setupStartTimes.get(o) > start && this.setupStartTimes.get(o) < end || this.endTimes.get(o) > start && this.endTimes.get(o) < end).collect(Collectors.toList());
        int currentOffset = Math.max(start, m.getAvailableDate());
        for (Operation o2 : opsOnMachineDuringThatTime) {
            int requiredSetupTimeIfInsertedHere = m.getWorkcenter().getSetupMatrix()[op.getStatus()][o2.getStatus()];
            if (this.startTimes.get(o2) - requiredSetupTimeIfInsertedHere - currentOffset >= o2.getProcessTime()) {
                return currentOffset;
            }
            currentOffset = this.endTimes.get(o2);
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assignments == null ? 0 : this.assignments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Schedule other = (Schedule)obj;
        return !(this.assignments == null ? other.assignments != null : !this.assignments.equals(other.assignments));
    }

    @Override
    public Machine getMachineToWhichOperationHasBeenAssigned(Operation o) {
        for (Pair<Operation, Machine> assignment : this.assignments) {
            if (!assignment.getX().equals(o)) continue;
            return assignment.getY();
        }
        return null;
    }
}

