/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.problems.scheduling.IJobSchedulingInput;
import ai.libs.jaicore.problems.scheduling.IScheduleComputer;
import ai.libs.jaicore.problems.scheduling.JobSchedulingProblemBuilder;
import ai.libs.jaicore.problems.scheduling.JobShopMetric;
import ai.libs.jaicore.problems.scheduling.Machine;
import ai.libs.jaicore.problems.scheduling.Operation;
import ai.libs.jaicore.problems.scheduling.Schedule;
import ai.libs.jaicore.problems.scheduling.computers.DefaultSchedulingComputer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ScheduleBuilder {
    private final IJobSchedulingInput problem;
    private final Set<String> assignedOperations = new HashSet<String>();
    private final List<Pair<Operation, Machine>> assignments = new ArrayList<Pair<Operation, Machine>>();
    private IScheduleComputer schedulingComputer = new DefaultSchedulingComputer();

    public ScheduleBuilder(JobSchedulingProblemBuilder builder) {
        this(builder.fork().withMetric(JobShopMetric.TOTALFLOWTIME).build());
    }

    public ScheduleBuilder(IJobSchedulingInput problem) {
        this.problem = problem;
    }

    public IJobSchedulingInput getProblem() {
        return this.problem;
    }

    public List<Pair<Operation, Machine>> getOrder() {
        return this.assignments;
    }

    public ScheduleBuilder assign(Operation o, Machine m) {
        Objects.requireNonNull(o);
        Objects.requireNonNull(m);
        if (this.assignedOperations.contains(o.getName())) {
            throw new IllegalArgumentException("Operation " + o.getName() + " has already been assigned.");
        }
        if (!o.getWorkcenter().getMachines().contains(m)) {
            throw new IllegalArgumentException("Cannot assign operation " + o.getName() + " to machine " + m.getMachineID() + ", because that machine is in work center " + m.getWorkcenter().getWorkcenterID() + ", but the operation must be executed in work center " + o.getWorkcenter().getWorkcenterID());
        }
        this.assignments.add(new Pair<Operation, Machine>(o, m));
        this.assignedOperations.add(o.getName());
        return this;
    }

    public ScheduleBuilder assign(String o, String m) {
        return this.assign(this.problem.getOperation(o), this.problem.getMachine(m));
    }

    public ScheduleBuilder withSchedulingComputer(IScheduleComputer schedulingComputer) {
        this.schedulingComputer = schedulingComputer;
        return this;
    }

    public Schedule build() {
        Collection unassignedOperations = SetUtil.difference(this.problem.getOperations(), (Collection)this.assignments.stream().map(Pair::getX).collect(Collectors.toSet()));
        if (!unassignedOperations.isEmpty()) {
            throw new UnsupportedOperationException("Cannot create partial schedules at the moment. Unassigned operations: " + unassignedOperations);
        }
        return new Schedule(this.problem, this.assignments, this.schedulingComputer);
    }
}

