/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling;

import ai.libs.jaicore.problems.scheduling.Machine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Workcenter {
    private final String workcenterID;
    private final List<Machine> machines = new ArrayList<Machine>();
    private final int[][] setupMatrix;

    Workcenter(String workcenterID, int[][] setupMatrix) {
        this.workcenterID = workcenterID;
        if (setupMatrix != null) {
            for (int i = 0; i < setupMatrix.length; ++i) {
                if (setupMatrix[i][i] == 0) continue;
                throw new IllegalArgumentException("The diagonal entries of the setup matrix must always be 0.");
            }
        }
        this.setupMatrix = setupMatrix;
    }

    public String getWorkcenterID() {
        return this.workcenterID;
    }

    public List<Machine> getMachines() {
        return Collections.unmodifiableList(this.machines);
    }

    void addMachine(Machine m) {
        this.machines.add(m);
    }

    public int[][] getSetupMatrix() {
        return this.setupMatrix;
    }
}

