/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling.computers;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.problems.scheduling.ASchedulingComputer;
import ai.libs.jaicore.problems.scheduling.IJobSchedulingInput;
import ai.libs.jaicore.problems.scheduling.Job;
import ai.libs.jaicore.problems.scheduling.JobSchedulingProblemInput;
import ai.libs.jaicore.problems.scheduling.Machine;
import ai.libs.jaicore.problems.scheduling.Operation;
import java.util.List;
import java.util.Map;

public class VariableReleaseDatesSchedulingComputer
extends ASchedulingComputer {
    private int latestArrivalTime;

    @Override
    public void fillTimes(IJobSchedulingInput problemInput, List<Pair<Operation, Machine>> assignments, Map<Job, Integer> arrivalTimes, Map<Operation, Integer> startTimes, Map<Operation, Integer> endTimes, Map<Operation, Integer> setupStartTimes, Map<Operation, Integer> setupEndTimes) {
        if (!(problemInput instanceof JobSchedulingProblemInput)) {
            throw new IllegalArgumentException();
        }
        JobSchedulingProblemInput cProblemInput = (JobSchedulingProblemInput)problemInput;
        this.latestArrivalTime = cProblemInput.getLatestArrivalTime();
        super.fillTimes(cProblemInput, assignments, arrivalTimes, startTimes, endTimes, setupStartTimes, setupEndTimes);
    }

    @Override
    public int getTimeWhenMachineBecomesAvailableForOperation(Map<Job, Integer> arrivalTimes, Map<Machine, Integer> machineReadiness, Machine m) {
        return machineReadiness.computeIfAbsent(m, Machine::getAvailableDate);
    }

    @Override
    public int timeWhenOperationArrivesAtMachine(Map<Job, Integer> arrivalTimes, Map<Machine, Integer> machineReadiness, Map<Job, Integer> jobReadyness, Operation o, Machine m) {
        int timeWhenJobArrivesAtMachine;
        Job job = o.getJob();
        int timeWhenMachineBecomesAvailableForOperation = this.getTimeWhenMachineBecomesAvailableForOperation(arrivalTimes, machineReadiness, m);
        if (!arrivalTimes.containsKey(job)) {
            timeWhenJobArrivesAtMachine = Math.min(timeWhenMachineBecomesAvailableForOperation, this.latestArrivalTime);
            arrivalTimes.put(job, timeWhenJobArrivesAtMachine);
        } else {
            timeWhenJobArrivesAtMachine = Math.max(timeWhenMachineBecomesAvailableForOperation, arrivalTimes.get(job));
        }
        return timeWhenJobArrivesAtMachine;
    }
}

