/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.problems.scheduling.openshop;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.problems.scheduling.IJobSchedulingInput;
import ai.libs.jaicore.problems.scheduling.JobSchedulingProblemBuilder;
import ai.libs.jaicore.problems.scheduling.JobShopMetric;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class OpenShopProblemReader {
    private OpenShopProblemReader() {
    }

    public static IJobSchedulingInput getFromJobFileWithoutSetupTimesAndWithOneMachinePerWorkcenter(File jobFile, JobShopMetric metric) throws IOException {
        int i;
        List<String> jobFileLines = FileUtil.readFileAsList(jobFile);
        int numJobs = Integer.parseInt(jobFileLines.remove(0));
        int numWorkcenters = Integer.parseInt(jobFileLines.remove(0));
        JobSchedulingProblemBuilder builder = new JobSchedulingProblemBuilder();
        int[][] zeroSetupTimesArray = new int[numJobs + 1][numJobs + 1];
        for (i = 0; i <= numJobs; ++i) {
            for (int j = 0; j <= numJobs; ++j) {
                zeroSetupTimesArray[i][j] = 0;
            }
        }
        for (i = 0; i < numWorkcenters; ++i) {
            String wcId = "W" + (i + 1);
            String machineId = "M" + (i + 1);
            builder.withWorkcenter(wcId, zeroSetupTimesArray);
            builder.withMachineForWorkcenter(machineId, wcId, 0, 0);
        }
        OpenShopProblemReader.configureBuilderWithJobsFromJobFile(builder, jobFile);
        builder.withMetric(metric);
        return builder.build();
    }

    public static IJobSchedulingInput mergeFromFiles(File jobFile, File setupTimesFile, File parallelMachinesFile, JobShopMetric metric) throws IOException {
        if (setupTimesFile == null || !setupTimesFile.exists()) {
            throw new IllegalArgumentException("Cannot read setup times file \"" + setupTimesFile + "\"");
        }
        if (parallelMachinesFile == null || !parallelMachinesFile.exists()) {
            throw new IllegalArgumentException("Cannot read parallel machines file \"" + parallelMachinesFile + "\"");
        }
        JobSchedulingProblemBuilder builder = new JobSchedulingProblemBuilder();
        List<String> setupTimesFileLines = FileUtil.readFileAsList(setupTimesFile);
        int numOperations = Integer.parseInt(setupTimesFileLines.remove(0));
        int numWorkcenters = Integer.parseInt(setupTimesFileLines.remove(0));
        setupTimesFileLines.remove(0);
        int[][] setupTimesForThisWorkcenter = null;
        int[][][] setupTimesForWorkcenters = new int[numWorkcenters][numOperations + 1][numOperations + 1];
        int wcId = 0;
        int currentLineIndexWithinWorkcenter = 1;
        for (String line : setupTimesFileLines) {
            if (line.isEmpty()) {
                if (setupTimesForThisWorkcenter != null) {
                    setupTimesForWorkcenters[wcId++] = setupTimesForThisWorkcenter;
                }
                setupTimesForThisWorkcenter = new int[numOperations + 1][numOperations + 1];
                currentLineIndexWithinWorkcenter = 1;
                continue;
            }
            String[] setupTimesForThisOperationAsString = line.replace("|", " ").trim().split(" ");
            int[] setupTimeForThisOperation = new int[setupTimesForThisOperationAsString.length + 1];
            for (int i = 1; i < setupTimeForThisOperation.length; ++i) {
                setupTimeForThisOperation[i] = Integer.parseInt(setupTimesForThisOperationAsString[i - 1]);
            }
            setupTimesForThisWorkcenter[currentLineIndexWithinWorkcenter] = setupTimeForThisOperation;
            ++currentLineIndexWithinWorkcenter;
        }
        setupTimesForWorkcenters[wcId] = setupTimesForThisWorkcenter;
        for (int i = 0; i < numWorkcenters; ++i) {
            builder.withWorkcenter("W" + (i + 1), setupTimesForWorkcenters[i]);
        }
        List<String> numMachineFileLines = FileUtil.readFileAsList(parallelMachinesFile);
        String[] numMachineTimeParts = numMachineFileLines.get(0).replace("|", " ").trim().split(" ");
        if (numMachineTimeParts.length != numWorkcenters) {
            throw new IllegalArgumentException("The number of fields in the machine file must coincide with the number of work centers defined in the other files. Here, " + numMachineTimeParts.length + " numbers of machines have been defined: " + numMachineFileLines.get(0) + ". The number of work centers however is " + numWorkcenters);
        }
        int machineIndex = 1;
        for (int i = 0; i < numWorkcenters; ++i) {
            int numMachinesHere = Integer.parseInt(numMachineTimeParts[i]);
            String wcName = "W" + (i + 1);
            for (int j = 0; j < numMachinesHere; ++j) {
                builder.withMachineForWorkcenter("M" + machineIndex++, wcName, 0, 0);
            }
        }
        OpenShopProblemReader.configureBuilderWithJobsFromJobFile(builder, jobFile);
        return builder.withMetric(metric).build();
    }

    private static void configureBuilderWithJobsFromJobFile(JobSchedulingProblemBuilder builder, File jobFile) throws IOException {
        int numWorkcentersDefinedInBuilder = builder.getWorkcenters().size();
        if (jobFile == null || !jobFile.exists()) {
            throw new IllegalArgumentException("Cannot read job file \"" + jobFile + "\"");
        }
        LinkedList<String> jobFileLines = new LinkedList<String>(FileUtil.readFileAsList(jobFile));
        int numJobs = Integer.parseInt((String)jobFileLines.poll());
        int numWorkcentersHere = Integer.parseInt((String)jobFileLines.poll());
        if (numWorkcentersDefinedInBuilder != numWorkcentersHere) {
            throw new IllegalArgumentException("Number of work centers in setup file is " + numWorkcentersDefinedInBuilder + " but in job description is " + numWorkcentersHere);
        }
        int opIndex = 1;
        for (int i = 0; i < numJobs; ++i) {
            String jobId = "J" + (i + 1);
            String line = (String)jobFileLines.poll();
            Object[] processTimeParts = line.replace("|", " ").trim().split(" ");
            if (processTimeParts.length != numWorkcentersDefinedInBuilder) {
                throw new IllegalArgumentException("Ill-defined job specification \"" + line + "\" for " + numWorkcentersDefinedInBuilder + " work centers. Split length is " + processTimeParts.length + ": " + Arrays.toString(processTimeParts));
            }
            builder.withJob(jobId, 0, Integer.MAX_VALUE, 1);
            for (int j = 0; j < numWorkcentersDefinedInBuilder; ++j) {
                builder.withOperationForJob("O" + opIndex, jobId, Integer.parseInt((String)processTimeParts[j]), j + 1, "W" + (j + 1));
                ++opIndex;
            }
        }
    }
}

