/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.timing;

import ai.libs.jaicore.logging.ToJSONStringUtil;
import java.util.HashMap;
import java.util.Map;
import org.api4.java.common.attributedobjects.IObjectEvaluator;
import org.api4.java.common.attributedobjects.ObjectEvaluationFailedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRecordingObjectEvaluator<T, V extends Comparable<V>>
implements IObjectEvaluator<T, V>,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(TimeRecordingObjectEvaluator.class);
    private final IObjectEvaluator<T, V> baseEvaluator;
    private final Map<T, Integer> consumedTimes = new HashMap<T, Integer>();

    public TimeRecordingObjectEvaluator(IObjectEvaluator<T, V> baseEvaluator) {
        this.baseEvaluator = baseEvaluator;
    }

    public V evaluate(T object) throws InterruptedException, ObjectEvaluationFailedException {
        long start = System.currentTimeMillis();
        this.logger.info("Starting timed evaluation.");
        Comparable score = this.baseEvaluator.evaluate(object);
        long end = System.currentTimeMillis();
        int runtime = (int)(end - start);
        this.logger.info("Finished evaluation in {}ms. Score is {}", (Object)runtime, (Object)score);
        this.consumedTimes.put(object, runtime);
        return (V)score;
    }

    public boolean hasEvaluationForComponentInstance(T inst) {
        return this.consumedTimes.containsKey(inst);
    }

    public int getEvaluationTimeForComponentInstance(T inst) {
        return this.consumedTimes.get(inst);
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("baseEvaluator", this.baseEvaluator);
        fields.put("consumedTimes", this.consumedTimes);
        return ToJSONStringUtil.toJSONString(this.getClass().getSimpleName(), fields);
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.baseEvaluator instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of evaluator {} to {}.be", (Object)this.baseEvaluator.getClass().getName(), (Object)name);
            ((ILoggingCustomizable)this.baseEvaluator).setLoggerName(name + ".be");
        } else {
            this.logger.info("Evaluator {} cannot be customized for logging, so not configuring its logger.", (Object)this.baseEvaluator.getClass().getName());
        }
    }
}

