/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.timing;

import ai.libs.jaicore.concurrent.GlobalTimer;
import ai.libs.jaicore.concurrent.TrackableTimerTask;
import ai.libs.jaicore.interrupt.Interrupter;
import ai.libs.jaicore.interrupt.InterruptionTimerTask;
import ai.libs.jaicore.logging.LoggerUtil;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimedComputation {
    private static final Logger logger = LoggerFactory.getLogger(TimedComputation.class);

    private TimedComputation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T compute(Callable<T> callable, Timeout timeout, String reasonToLogOnTimeout) throws ExecutionException, AlgorithmTimeoutedException, InterruptedException {
        GlobalTimer timer = GlobalTimer.getInstance();
        long start = System.currentTimeMillis();
        InterruptionTimerTask task = new InterruptionTimerTask("Timeout for timed computation with thread " + Thread.currentThread() + " at timestamp " + start + ": " + reasonToLogOnTimeout);
        logger.debug("Scheduling timer for interruption in {}ms with reason {}, i.e. timestamp {}.", new Object[]{timeout.milliseconds(), start + timeout.milliseconds(), reasonToLogOnTimeout});
        timer.schedule((TrackableTimerTask)task, timeout.milliseconds());
        Interrupter interrupter = Interrupter.get();
        logger.debug("Acquired interrupter {}.", (Object)interrupter);
        T output = null;
        Exception caughtException = null;
        try {
            logger.debug("Starting supervised computation of {}.", callable);
            output = callable.call();
        }
        catch (Exception e) {
            caughtException = e;
        }
        finally {
            task.cancel();
        }
        int runtime = (int)(System.currentTimeMillis() - start);
        int delay = runtime - (int)timeout.milliseconds();
        boolean isInterrupted = Thread.currentThread().isInterrupted();
        if (caughtException != null) {
            logger.info("Timed computation has returned control after {}ms, i.e., with a delay of {}ms. Observed exception: {}. Thread interrupt flag is {}.", new Object[]{runtime, delay, caughtException.getClass().getName(), isInterrupted});
            if (caughtException instanceof InterruptedException && isInterrupted && interrupter.getAllUnresolvedInterruptsOfThread(Thread.currentThread()).size() == 1) {
                logger.warn("Timed computation has thrown an InterruptedException AND the thread is interrupted AND there are no other open interrupts on the thread! This should never happen! Here is the stack trace: \n\t{}", (Object)LoggerUtil.getExceptionInfo(caughtException));
            }
        } else {
            logger.info("Timed computation has returned control after {}ms, i.e., with a delay of {}ms. Observed regular output return value: {}. Thread interrupt flag is {}.", new Object[]{runtime, delay, output, isInterrupted});
        }
        boolean timeoutTriggered = false;
        Interrupter interrupter2 = interrupter;
        synchronized (interrupter2) {
            logger.debug("Checking for an interruption and resolving potential interrupts.");
            if (interrupter.hasCurrentThreadBeenInterruptedWithReason(task)) {
                logger.info("Thread has been interrupted internally. Resolving the interrupt (this may throw an InterruptedException).");
                timeoutTriggered = true;
                Thread.interrupted();
                Interrupter.get().markInterruptOnCurrentThreadAsResolved(task);
            } else if (task.isTriggered()) {
                interrupter.avoidInterrupt(Thread.currentThread(), task);
                logger.info("Interrupt is external, black-listed \"{}\" for interrupts on {} and re-throwing the exception.", (Object)task, (Object)Thread.currentThread());
            }
            assert (!interrupter.hasCurrentThreadBeenInterruptedWithReason(task));
        }
        if (caughtException != null) {
            if (timeoutTriggered) {
                logger.info("Throwing TimeoutException");
                throw new AlgorithmTimeoutedException((long)delay);
            }
            if (caughtException instanceof InterruptedException) {
                logger.debug("An InterruptedException was thrown during the timed execution: {}. Re-throwing it. Interrupt-flag is {}.", (Object)caughtException, (Object)Thread.currentThread().isInterrupted());
                throw (InterruptedException)caughtException;
            }
            logger.debug("Now re-throwing {}, which was caught in timed computation. Interrupt-flag is {}.", (Object)caughtException, (Object)Thread.currentThread().isInterrupted());
            throw new ExecutionException(caughtException);
        }
        logger.debug("Finished timed computation of {} after {}ms where {}ms were allowed. Interrupt-flag is {}", new Object[]{callable, runtime, timeout, Thread.currentThread().isInterrupted()});
        return output;
    }

    public static void computeWithTimeout(Timeout timeout, Runnable runnable) throws InterruptedException {
        Semaphore sync = new Semaphore(0);
        Thread t = new Thread(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                logger.info("Caught exception in timed computation thread", (Throwable)e);
            }
            finally {
                sync.release();
            }
        });
        t.start();
        try {
            if (timeout.milliseconds() > 0L) {
                logger.info("Wait for a timeout of {}ms.", (Object)timeout.milliseconds());
                if (!sync.tryAcquire(timeout.milliseconds(), TimeUnit.MILLISECONDS)) {
                    t.interrupt();
                }
            } else {
                logger.info("No timeout set, thus wait until the process is finished.");
                sync.acquire();
            }
        }
        catch (InterruptedException e) {
            logger.info("TimedComputation got interrupted or timeout has fired, thus interrupt nested thread.");
            t.interrupt();
            throw e;
        }
    }

    public static void computeWithTimeoutInParallel(int numCPUs, Timeout timeout, List<Runnable> taskList) throws InterruptedException {
        ExecutorService pool = Executors.newFixedThreadPool(numCPUs);
        Semaphore sync = new Semaphore(0);
        taskList.stream().forEach(x -> pool.submit(() -> {
            try {
                x.run();
            }
            finally {
                sync.release();
            }
        }));
        pool.shutdown();
        try {
            logger.info("Wait for a timeout of {}ms.", (Object)timeout.milliseconds());
            if (timeout.milliseconds() > 0L) {
                if (!sync.tryAcquire(taskList.size(), timeout.milliseconds(), TimeUnit.MILLISECONDS)) {
                    logger.info("Timeout fired, shutdown pool right now.");
                    pool.shutdownNow();
                }
            } else {
                sync.acquire(taskList.size());
            }
        }
        catch (InterruptedException e) {
            logger.info("TimedComputation got interrupted or timeout has fired, thus interrupt nested thread.");
            pool.shutdownNow();
            throw e;
        }
    }
}

