/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.components.model.CategoricalParameterDomain;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.CompositionProblemUtil;
import ai.libs.jaicore.components.model.Dependency;
import ai.libs.jaicore.components.model.IParameterDomain;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import ai.libs.jaicore.components.model.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;

public class ComponentInstanceUtil {
    private ComponentInstanceUtil() {
    }

    public static boolean isValidComponentInstantiation(ComponentInstance ci) {
        HashMap<Parameter, IParameterDomain> refinedDomainMap = new HashMap<Parameter, IParameterDomain>();
        for (Parameter param : ci.getComponent().getParameters()) {
            if (param.getDefaultDomain() instanceof NumericParameterDomain) {
                double parameterValue = Double.parseDouble(ci.getParameterValue(param));
                refinedDomainMap.put(param, new NumericParameterDomain(((NumericParameterDomain)param.getDefaultDomain()).isInteger(), parameterValue, parameterValue));
                continue;
            }
            if (!(param.getDefaultDomain() instanceof CategoricalParameterDomain)) continue;
            refinedDomainMap.put(param, new CategoricalParameterDomain(Arrays.asList(ci.getParameterValue(param))));
        }
        for (Dependency dependency : ci.getComponent().getDependencies()) {
            if (!CompositionProblemUtil.isDependencyPremiseSatisfied(dependency, refinedDomainMap) || CompositionProblemUtil.isDependencyConditionSatisfied(dependency.getConclusion(), refinedDomainMap)) continue;
            return false;
        }
        return true;
    }

    public static String toComponentNameString(ComponentInstance ci) {
        StringBuilder sb = new StringBuilder();
        sb.append(ci.getComponent().getName());
        if (!ci.getSatisfactionOfRequiredInterfaces().isEmpty()) {
            sb.append("(").append(ci.getSatisfactionOfRequiredInterfaces().values().stream().map(ComponentInstanceUtil::toComponentNameString).collect(Collectors.joining(", "))).append(")");
        }
        return sb.toString();
    }

    public static ComponentInstance getDefaultParametrization(ComponentInstance ci) {
        HashMap<String, ComponentInstance> defaultRequiredInterfaces = new HashMap<String, ComponentInstance>();
        ci.getSatisfactionOfRequiredInterfaces().forEach((name, ciReq) -> defaultRequiredInterfaces.put((String)name, ComponentInstanceUtil.getDefaultParametrization(ciReq)));
        return new ComponentInstance(ci.getComponent(), new HashMap<String, String>(), defaultRequiredInterfaces);
    }
}

