/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.basic.kvstore.KVStore;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.components.model.BooleanParameterDomain;
import ai.libs.jaicore.components.model.CategoricalParameterDomain;
import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.ComponentInstanceUtil;
import ai.libs.jaicore.components.model.Interface;
import ai.libs.jaicore.components.model.NumericParameterDomain;
import ai.libs.jaicore.components.model.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentUtil {
    private static final Logger logger = LoggerFactory.getLogger(ComponentUtil.class);

    private ComponentUtil() {
    }

    public static ComponentInstance getDefaultParameterizationOfComponent(Component component) {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (Parameter p : component.getParameters()) {
            parameterValues.put(p.getName(), p.getDefaultValue() + "");
        }
        return ComponentUtil.componentInstanceWithNoRequiredInterfaces(component, parameterValues);
    }

    public static ComponentInstance getRandomParameterizationOfComponent(Component component, Random rand) {
        HashMap<String, String> parameterValues;
        ComponentInstance ci;
        do {
            parameterValues = new HashMap<String, String>();
            for (Parameter p : component.getParameters()) {
                if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                    String[] values = ((CategoricalParameterDomain)p.getDefaultDomain()).getValues();
                    parameterValues.put(p.getName(), values[rand.nextInt(values.length)]);
                    continue;
                }
                NumericParameterDomain numDomain = (NumericParameterDomain)p.getDefaultDomain();
                if (numDomain.isInteger()) {
                    if ((int)(numDomain.getMax() - numDomain.getMin()) > 0) {
                        parameterValues.put(p.getName(), (int)((double)rand.nextInt((int)(numDomain.getMax() - numDomain.getMin())) + numDomain.getMin()) + "");
                        continue;
                    }
                    if (p.getDefaultValue() instanceof Double) {
                        parameterValues.put(p.getName(), (int)((Double)p.getDefaultValue()).doubleValue() + "");
                        continue;
                    }
                    parameterValues.put(p.getName(), (Integer)p.getDefaultValue() + "");
                    continue;
                }
                parameterValues.put(p.getName(), rand.nextDouble() * (numDomain.getMax() - numDomain.getMin()) + numDomain.getMin() + "");
            }
        } while (!ComponentInstanceUtil.isValidComponentInstantiation(ci = ComponentUtil.componentInstanceWithNoRequiredInterfaces(component, parameterValues)));
        return ci;
    }

    public static ComponentInstance minParameterizationOfComponent(Component component) {
        HashMap<String, String> parameterValues;
        ComponentInstance ci = null;
        do {
            parameterValues = new HashMap<String, String>();
            for (Parameter p : component.getParameters()) {
                if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                    parameterValues.put(p.getName(), p.getDefaultValue() + "");
                    continue;
                }
                NumericParameterDomain numDomain = (NumericParameterDomain)p.getDefaultDomain();
                if (numDomain.isInteger()) {
                    if ((int)(numDomain.getMax() - numDomain.getMin()) > 0) {
                        parameterValues.put(p.getName(), (int)numDomain.getMin() + "");
                        continue;
                    }
                    parameterValues.put(p.getName(), (Integer)p.getDefaultValue() + "");
                    continue;
                }
                parameterValues.put(p.getName(), numDomain.getMin() + "");
            }
        } while (!ComponentInstanceUtil.isValidComponentInstantiation(ci = ComponentUtil.componentInstanceWithNoRequiredInterfaces(component, parameterValues)));
        return ci;
    }

    public static ComponentInstance maxParameterizationOfComponent(Component component) {
        HashMap<String, String> parameterValues;
        ComponentInstance ci;
        do {
            parameterValues = new HashMap<String, String>();
            for (Parameter p : component.getParameters()) {
                if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                    parameterValues.put(p.getName(), p.getDefaultValue() + "");
                    continue;
                }
                NumericParameterDomain numDomain = (NumericParameterDomain)p.getDefaultDomain();
                if (numDomain.isInteger()) {
                    if ((int)(numDomain.getMax() - numDomain.getMin()) > 0) {
                        parameterValues.put(p.getName(), (int)numDomain.getMax() + "");
                        continue;
                    }
                    parameterValues.put(p.getName(), (Integer)p.getDefaultValue() + "");
                    continue;
                }
                parameterValues.put(p.getName(), numDomain.getMax() + "");
            }
        } while (!ComponentInstanceUtil.isValidComponentInstantiation(ci = ComponentUtil.componentInstanceWithNoRequiredInterfaces(component, parameterValues)));
        return ci;
    }

    private static ComponentInstance componentInstanceWithNoRequiredInterfaces(Component component, Map<String, String> parameterValues) {
        return new ComponentInstance(component, parameterValues, new HashMap<String, ComponentInstance>());
    }

    public static List<ComponentInstance> categoricalParameterizationsOfComponent(Component component) {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        ArrayList<ComponentInstance> parameterizedInstances = new ArrayList<ComponentInstance>();
        ArrayList<Parameter> categoricalParameters = new ArrayList<Parameter>();
        int maxParameterIndex = 0;
        for (Parameter p : component.getParameters()) {
            if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                String[] values = ((CategoricalParameterDomain)p.getDefaultDomain()).getValues();
                if (values.length > maxParameterIndex) {
                    maxParameterIndex = values.length;
                }
                categoricalParameters.add(p);
                continue;
            }
            parameterValues.put(p.getName(), p.getDefaultValue() + "");
        }
        for (int parameterIndex = 0; parameterIndex < maxParameterIndex; ++parameterIndex) {
            HashMap<String, String> categoricalParameterValues = new HashMap<String, String>();
            for (int i = 0; i < categoricalParameters.size(); ++i) {
                String parameterValue = null;
                String[] values = ((CategoricalParameterDomain)((Parameter)categoricalParameters.get(i)).getDefaultDomain()).getValues();
                parameterValue = parameterIndex < values.length ? values[parameterIndex] : ((Parameter)categoricalParameters.get(i)).getDefaultValue() + "";
                categoricalParameterValues.put(((Parameter)categoricalParameters.get(i)).getName(), parameterValue);
            }
            categoricalParameterValues.putAll(parameterValues);
            parameterizedInstances.add(new ComponentInstance(component, categoricalParameterValues, new HashMap<String, ComponentInstance>()));
        }
        return parameterizedInstances;
    }

    public static Collection<Component> getComponentsProvidingInterface(Collection<Component> components, String providedInterface) {
        return components.stream().filter(x -> x.getProvidedInterfaces().contains(providedInterface)).collect(Collectors.toList());
    }

    public static Collection<ComponentInstance> getAllAlgorithmSelectionInstances(Component rootComponent, Collection<Component> components) {
        LinkedList<ComponentInstance> instanceList = new LinkedList<ComponentInstance>();
        instanceList.add(ComponentUtil.getDefaultParameterizationOfComponent(rootComponent));
        for (Interface requiredInterface : rootComponent.getRequiredInterfaces()) {
            LinkedList<ComponentInstance> tempList = new LinkedList<ComponentInstance>();
            Collection<Component> possiblePlugins = ComponentUtil.getComponentsProvidingInterface(components, requiredInterface.getName());
            for (ComponentInstance ci : instanceList) {
                for (Component possiblePlugin : possiblePlugins) {
                    for (ComponentInstance reqICI : ComponentUtil.getAllAlgorithmSelectionInstances(possiblePlugin, components)) {
                        ComponentInstance copyOfCI = new ComponentInstance(ci.getComponent(), new HashMap<String, String>(ci.getParameterValues()), new HashMap<String, ComponentInstance>(ci.getSatisfactionOfRequiredInterfaces()));
                        copyOfCI.getSatisfactionOfRequiredInterfaces().put(requiredInterface.getId(), reqICI);
                        tempList.add(copyOfCI);
                    }
                }
            }
            instanceList.clear();
            instanceList.addAll(tempList);
        }
        return instanceList;
    }

    public static Collection<ComponentInstance> getAllAlgorithmSelectionInstances(String requiredInterface, Collection<Component> components) {
        ArrayList<ComponentInstance> instanceList = new ArrayList<ComponentInstance>();
        components.stream().filter(x -> x.getProvidedInterfaces().contains(requiredInterface)).map(x -> ComponentUtil.getAllAlgorithmSelectionInstances(x, components)).forEach(instanceList::addAll);
        return instanceList;
    }

    public static int getNumberOfUnparametrizedCompositions(Collection<Component> components, String requiredInterface) {
        if (ComponentUtil.hasCycles(components, requiredInterface)) {
            return -1;
        }
        Collection candidates = components.stream().filter(c -> c.getProvidedInterfaces().contains(requiredInterface)).collect(Collectors.toList());
        int numCandidates = 0;
        for (Component candidate : candidates) {
            int waysToResolveComponent = 0;
            if (candidate.getRequiredInterfaces().isEmpty()) {
                waysToResolveComponent = 1;
            } else {
                for (String reqIFace : candidate.getRequiredInterfaceNames()) {
                    int subSolutionsForThisInterface = ComponentUtil.getNumberOfUnparametrizedCompositions(components, reqIFace);
                    if (waysToResolveComponent > 0) {
                        waysToResolveComponent *= subSolutionsForThisInterface;
                        continue;
                    }
                    waysToResolveComponent = subSolutionsForThisInterface;
                }
            }
            numCandidates += waysToResolveComponent;
        }
        return numCandidates;
    }

    public static ComponentInstance getRandomParametrization(ComponentInstance componentInstance, Random rand) {
        ComponentInstance randomParametrization = ComponentUtil.getRandomParameterizationOfComponent(componentInstance.getComponent(), rand);
        componentInstance.getSatisfactionOfRequiredInterfaces().entrySet().forEach(x -> randomParametrization.getSatisfactionOfRequiredInterfaces().put((String)x.getKey(), ComponentUtil.getRandomParametrization((ComponentInstance)x.getValue(), rand)));
        return randomParametrization;
    }

    public static boolean hasCycles(Collection<Component> components, String requiredInterface) {
        return ComponentUtil.hasCycles(components, requiredInterface, new LinkedList<String>());
    }

    private static boolean hasCycles(Collection<Component> components, String requiredInterface, List<String> componentList) {
        Collection candidates = components.stream().filter(c -> c.getProvidedInterfaces().contains(requiredInterface)).collect(Collectors.toList());
        for (Component c2 : candidates) {
            if (componentList.contains(c2.getName())) {
                return true;
            }
            LinkedList<String> componentListCopy = new LinkedList<String>(componentList);
            componentListCopy.add(c2.getName());
            for (String subRequiredInterface : c2.getRequiredInterfaceNames()) {
                if (!ComponentUtil.hasCycles(components, subRequiredInterface, componentListCopy)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDefaultConfiguration(ComponentInstance instance) {
        for (Parameter p : instance.getParametersThatHaveBeenSetExplicitly()) {
            if (p.isNumeric()) {
                double defaultValue = Double.parseDouble(p.getDefaultValue().toString());
                String parameterValue = instance.getParameterValue(p);
                boolean isCompatibleWithDefaultValue = false;
                if (parameterValue.contains("[")) {
                    List intervalAsList = SetUtil.unserializeList((String)instance.getParameterValue(p));
                    isCompatibleWithDefaultValue = defaultValue >= Double.parseDouble((String)intervalAsList.get(0)) && defaultValue <= Double.parseDouble((String)intervalAsList.get(1));
                } else {
                    boolean bl = isCompatibleWithDefaultValue = Math.abs(defaultValue - Double.parseDouble(parameterValue)) < 1.0E-8;
                }
                if (!isCompatibleWithDefaultValue) {
                    logger.info("{} has value {}, which does not subsume the default value {}", new Object[]{p.getName(), instance.getParameterValue(p), defaultValue});
                    return false;
                }
                logger.info("{} has value {}, which IS COMPATIBLE with the default value {}", new Object[]{p.getName(), instance.getParameterValue(p), defaultValue});
                continue;
            }
            if (instance.getParameterValue(p).equals(p.getDefaultValue().toString())) continue;
            logger.info("{} has value {}, which is not the default {}", new Object[]{p.getName(), instance.getParameterValue(p), p.getDefaultValue()});
            return false;
        }
        for (ComponentInstance child : instance.getSatisfactionOfRequiredInterfaces().values()) {
            if (ComponentUtil.isDefaultConfiguration(child)) continue;
            return false;
        }
        return true;
    }

    public static KVStore getStatsForComponents(Collection<Component> components) {
        KVStore stats = new KVStore();
        int numComponents = 0;
        int numNumericParams = 0;
        int numIntParams = 0;
        int numDoubleParams = 0;
        int numCatParams = 0;
        int numBoolParams = 0;
        int otherParams = 0;
        for (Component c : components) {
            ++numComponents;
            for (Parameter p : c.getParameters()) {
                if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                    ++numCatParams;
                    if (!(p.getDefaultDomain() instanceof BooleanParameterDomain)) continue;
                    ++numBoolParams;
                    continue;
                }
                if (p.getDefaultDomain() instanceof NumericParameterDomain) {
                    ++numNumericParams;
                    if (((NumericParameterDomain)p.getDefaultDomain()).isInteger()) {
                        ++numIntParams;
                        continue;
                    }
                    ++numDoubleParams;
                    continue;
                }
                ++otherParams;
            }
        }
        stats.put((Object)"nComponents", (Object)numComponents);
        stats.put((Object)"nNumericParameters", (Object)numNumericParams);
        stats.put((Object)"nIntegerParameters", (Object)numIntParams);
        stats.put((Object)"nContinuousParameters", (Object)numDoubleParams);
        stats.put((Object)"nCategoricalParameters", (Object)numCatParams);
        stats.put((Object)"nBooleanParameters", (Object)numBoolParams);
        stats.put((Object)"nOtherParameters", (Object)otherParams);
        return stats;
    }

    public static Collection<Component> getAffectedComponents(Collection<Component> components, String requiredInterface) {
        HashSet<Component> affectedComponents = new HashSet<Component>(ComponentUtil.getComponentsProvidingInterface(components, requiredInterface));
        if (affectedComponents.isEmpty()) {
            throw new IllegalArgumentException("Could not resolve the requiredInterface " + requiredInterface);
        }
        HashSet recursiveResolvedComps = new HashSet();
        affectedComponents.forEach(x -> x.getRequiredInterfaceNames().stream().map(interfaceName -> ComponentUtil.getAffectedComponents(components, interfaceName)).forEach(recursiveResolvedComps::addAll));
        affectedComponents.addAll(recursiveResolvedComps);
        return affectedComponents;
    }

    public static String getComponentInstanceAsComponentNames(ComponentInstance instance) {
        StringBuilder sb = new StringBuilder();
        sb.append(instance.getComponent().getName());
        if (!instance.getSatisfactionOfRequiredInterfaces().isEmpty()) {
            sb.append("{").append(instance.getSatisfactionOfRequiredInterfaces().values().stream().map(ComponentUtil::getComponentInstanceAsComponentNames).collect(Collectors.joining(","))).append("}");
        }
        return sb.toString();
    }
}

