/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

public class ParameterRefinementConfiguration {
    private final boolean initRefinementOnLogScale;
    private final double focusPoint;
    private final double logBasis;
    private final boolean initWithExtremalPoints;
    private final int refinementsPerStep;
    private final double intervalLength;

    public ParameterRefinementConfiguration(boolean initWithExtremalPoints, int refinementsPerStep, double intervalLength) {
        this(Double.NaN, 0.0, initWithExtremalPoints, refinementsPerStep, intervalLength);
    }

    public ParameterRefinementConfiguration(double focusPoint, double logBasis, boolean initWithExtremalPoints, int refinementsPerStep, double intervalLength) {
        this.focusPoint = focusPoint;
        this.logBasis = logBasis;
        this.initRefinementOnLogScale = !Double.isNaN(focusPoint);
        this.initWithExtremalPoints = initWithExtremalPoints;
        this.refinementsPerStep = refinementsPerStep;
        this.intervalLength = intervalLength;
    }

    public boolean isInitRefinementOnLogScale() {
        return this.initRefinementOnLogScale;
    }

    public double getFocusPoint() {
        return this.focusPoint;
    }

    public double getLogBasis() {
        return this.logBasis;
    }

    public boolean isInitWithExtremalPoints() {
        return this.initWithExtremalPoints;
    }

    public int getRefinementsPerStep() {
        return this.refinementsPerStep;
    }

    public double getIntervalLength() {
        return this.intervalLength;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[InitiallyLogScale:");
        sb.append(this.initRefinementOnLogScale);
        sb.append(",RefinementsPerStep:");
        sb.append(this.refinementsPerStep);
        sb.append(",intervalLength:");
        sb.append(this.intervalLength);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.focusPoint);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.initRefinementOnLogScale ? 1231 : 1237);
        result = 31 * result + (this.initWithExtremalPoints ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.intervalLength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.logBasis);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.refinementsPerStep;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterRefinementConfiguration other = (ParameterRefinementConfiguration)obj;
        if (Double.doubleToLongBits(this.focusPoint) != Double.doubleToLongBits(other.focusPoint)) {
            return false;
        }
        if (this.initRefinementOnLogScale != other.initRefinementOnLogScale) {
            return false;
        }
        if (this.initWithExtremalPoints != other.initWithExtremalPoints) {
            return false;
        }
        if (Double.doubleToLongBits(this.intervalLength) != Double.doubleToLongBits(other.intervalLength)) {
            return false;
        }
        if (Double.doubleToLongBits(this.logBasis) != Double.doubleToLongBits(other.logBasis)) {
            return false;
        }
        return this.refinementsPerStep == other.refinementsPerStep;
    }
}

