/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.Parameter;
import ai.libs.jaicore.components.model.ParameterRefinementConfiguration;
import ai.libs.jaicore.components.model.SoftwareConfigurationProblem;
import ai.libs.jaicore.components.serialization.ComponentLoader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.api4.java.common.attributedobjects.IObjectEvaluator;

public class RefinementConfiguredSoftwareConfigurationProblem<V extends Comparable<V>>
extends SoftwareConfigurationProblem<V> {
    private final Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramRefinementConfig;

    public RefinementConfiguredSoftwareConfigurationProblem(Collection<Component> components, String requiredInterface, IObjectEvaluator<ComponentInstance, V> compositionEvaluator, Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramRefinementConfig) {
        this(new SoftwareConfigurationProblem<V>(components, requiredInterface, compositionEvaluator), paramRefinementConfig);
    }

    public RefinementConfiguredSoftwareConfigurationProblem(RefinementConfiguredSoftwareConfigurationProblem<V> problemTemplate, Collection<Component> components, Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramRefinementConfig) {
        this(components, problemTemplate.getRequiredInterface(), problemTemplate.getCompositionEvaluator(), paramRefinementConfig);
    }

    public RefinementConfiguredSoftwareConfigurationProblem(RefinementConfiguredSoftwareConfigurationProblem<V> problemTemplate, IObjectEvaluator<ComponentInstance, V> evaluator) {
        this(problemTemplate.getComponents(), problemTemplate.getRequiredInterface(), evaluator, problemTemplate.getParamRefinementConfig());
    }

    public RefinementConfiguredSoftwareConfigurationProblem(RefinementConfiguredSoftwareConfigurationProblem<V> problemTemplate, String requiredInterface) {
        this(problemTemplate.getComponents(), requiredInterface, problemTemplate.getCompositionEvaluator(), problemTemplate.getParamRefinementConfig());
    }

    public RefinementConfiguredSoftwareConfigurationProblem(File configurationFile, String requiredInterface, IObjectEvaluator<ComponentInstance, V> compositionEvaluator) throws IOException {
        super(configurationFile, requiredInterface, compositionEvaluator);
        this.paramRefinementConfig = new ComponentLoader(configurationFile).getParamConfigs();
        for (Component c : this.getComponents()) {
            if (!this.paramRefinementConfig.containsKey(c)) {
                throw new IllegalArgumentException("Error in parsing config file " + configurationFile.getAbsolutePath() + ". Component " + c.getName() + " has not parameter refinement configs associated.");
            }
            for (Parameter p : c.getParameters()) {
                if (!p.isNumeric() || this.paramRefinementConfig.get(c).containsKey(p)) continue;
                throw new IllegalArgumentException("Error in parsing config file " + configurationFile.getAbsolutePath() + ". No refinement config was delivered for numeric parameter " + p.getName() + " of component " + c.getName());
            }
        }
    }

    public RefinementConfiguredSoftwareConfigurationProblem(SoftwareConfigurationProblem<V> coreProblem, Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramRefinementConfig) {
        super(coreProblem);
        this.paramRefinementConfig = paramRefinementConfig;
    }

    public Map<Component, Map<Parameter, ParameterRefinementConfiguration>> getParamRefinementConfig() {
        return this.paramRefinementConfig;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 + (this.paramRefinementConfig == null ? 0 : this.paramRefinementConfig.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefinementConfiguredSoftwareConfigurationProblem other = (RefinementConfiguredSoftwareConfigurationProblem)obj;
        return !(this.paramRefinementConfig == null ? other.paramRefinementConfig != null : !this.paramRefinementConfig.equals(other.paramRefinementConfig));
    }
}

