/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.model;

import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class UnparametrizedComponentInstance {
    private final String componentName;
    private final Map<String, UnparametrizedComponentInstance> satisfactionOfRequiredInterfaces;

    public UnparametrizedComponentInstance(String componentName, Map<String, UnparametrizedComponentInstance> satisfactionOfRequiredInterfaces) {
        this.componentName = componentName;
        this.satisfactionOfRequiredInterfaces = satisfactionOfRequiredInterfaces;
    }

    public UnparametrizedComponentInstance(ComponentInstance composition) {
        Map<String, ComponentInstance> resolvedRequiredInterfaces = composition.getSatisfactionOfRequiredInterfaces();
        this.satisfactionOfRequiredInterfaces = new HashMap<String, UnparametrizedComponentInstance>();
        resolvedRequiredInterfaces.keySet().forEach(r -> this.satisfactionOfRequiredInterfaces.put((String)r, new UnparametrizedComponentInstance((ComponentInstance)resolvedRequiredInterfaces.get(r))));
        this.componentName = composition.getComponent().getName();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Map<String, UnparametrizedComponentInstance> getSatisfactionOfRequiredInterfaces() {
        return this.satisfactionOfRequiredInterfaces;
    }

    public UnparametrizedComponentInstance getSubComposition(List<String> path) {
        UnparametrizedComponentInstance current = this;
        for (String requiredInterface : path) {
            if (!current.getSatisfactionOfRequiredInterfaces().containsKey(requiredInterface)) {
                throw new IllegalArgumentException("Invalid path " + path + " (size " + path.size() + "). The component " + current.getComponentName() + " does not have a required interface with id \"" + requiredInterface + "\"");
            }
            current = current.getSatisfactionOfRequiredInterfaces().get(requiredInterface);
        }
        return current;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.componentName).append(this.satisfactionOfRequiredInterfaces).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != UnparametrizedComponentInstance.class) {
            return false;
        }
        UnparametrizedComponentInstance other = (UnparametrizedComponentInstance)obj;
        return new EqualsBuilder().append((Object)this.componentName, (Object)other.componentName).append(this.satisfactionOfRequiredInterfaces, other.satisfactionOfRequiredInterfaces).isEquals();
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("componentName", this.componentName);
        fields.put("satisfactionOfRequiredInterfaces", this.satisfactionOfRequiredInterfaces);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }
}

