/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.optimizingfactory;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.components.exceptions.ComponentInstantiationFailedException;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.EvaluatedSoftwareConfigurationSolution;
import ai.libs.jaicore.components.model.SoftwareConfigurationProblem;
import ai.libs.jaicore.components.optimizingfactory.OptimizingFactoryProblem;
import ai.libs.jaicore.components.optimizingfactory.SoftwareConfigurationAlgorithm;
import ai.libs.jaicore.components.optimizingfactory.SoftwareConfigurationAlgorithmFactory;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizingFactory<P extends SoftwareConfigurationProblem<V>, T, C extends EvaluatedSoftwareConfigurationSolution<V>, V extends Comparable<V>>
extends AAlgorithm<OptimizingFactoryProblem<P, T, V>, T> {
    private Logger localLogger = LoggerFactory.getLogger(OptimizingFactory.class);
    private String loggerName;
    private final SoftwareConfigurationAlgorithmFactory<P, C, V, ?> factoryForOptimizationAlgorithm;
    private T constructedObject;
    private V performanceOfObject;
    private ComponentInstance componentInstanceOfObject;
    private final SoftwareConfigurationAlgorithm<P, C, V> optimizer;

    public OptimizingFactory(OptimizingFactoryProblem<P, T, V> problem, SoftwareConfigurationAlgorithmFactory<P, C, V, ?> factoryForOptimizationAlgorithm) {
        super(problem);
        this.factoryForOptimizationAlgorithm = factoryForOptimizationAlgorithm;
        this.optimizer = (SoftwareConfigurationAlgorithm)this.factoryForOptimizationAlgorithm.getAlgorithm(((OptimizingFactoryProblem)this.getInput()).getConfigurationProblem());
        this.optimizer.registerListener(new Object(){

            @Subscribe
            public void receiveAlgorithmEvent(IAlgorithmEvent event) {
                if (!(event instanceof AlgorithmInitializedEvent) && !(event instanceof AlgorithmFinishedEvent)) {
                    OptimizingFactory.this.post(event);
                }
            }
        });
    }

    public IAlgorithmEvent nextWithException() throws AlgorithmException, InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        switch (this.getState()) {
            case CREATED: {
                IAlgorithmEvent initEvent = this.optimizer.next();
                assert (initEvent instanceof AlgorithmInitializedEvent) : "The first event emitted by the optimizer has not been its AlgorithmInitializationEvent";
                return this.activate();
            }
            case ACTIVE: {
                EvaluatedSoftwareConfigurationSolution solutionModel = (EvaluatedSoftwareConfigurationSolution)this.optimizer.call();
                try {
                    this.constructedObject = ((OptimizingFactoryProblem)this.getInput()).getBaseFactory().getComponentInstantiation(solutionModel.getComponentInstance());
                    this.performanceOfObject = solutionModel.getScore();
                    this.componentInstanceOfObject = solutionModel.getComponentInstance();
                    return this.terminate();
                }
                catch (ComponentInstantiationFailedException e) {
                    throw new AlgorithmException("Could not conduct next step in OptimizingFactory due to an exception in the component instantiation.", (Throwable)e);
                }
            }
        }
        throw new IllegalStateException("Cannot do anything in state " + this.getState());
    }

    public T call() throws AlgorithmException, InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        while (this.hasNext()) {
            this.nextWithException();
        }
        return this.constructedObject;
    }

    public SoftwareConfigurationAlgorithm<P, C, V> getOptimizer() {
        return this.optimizer;
    }

    public AlgorithmInitializedEvent init() {
        IAlgorithmEvent e = null;
        while (this.hasNext()) {
            e = this.next();
            if (!(e instanceof AlgorithmInitializedEvent)) continue;
            return (AlgorithmInitializedEvent)e;
        }
        throw new IllegalStateException("Could not complete initialization");
    }

    public V getPerformanceOfObject() {
        return this.performanceOfObject;
    }

    public ComponentInstance getComponentInstanceOfObject() {
        return this.componentInstanceOfObject;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.localLogger.info("Switching logger from {} to {}", (Object)this.localLogger.getName(), (Object)name);
        this.loggerName = name;
        this.localLogger = LoggerFactory.getLogger((String)name);
        this.localLogger.info("Activated logger {} with name {}", (Object)name, (Object)this.localLogger.getName());
        if (this.optimizer instanceof ILoggingCustomizable) {
            this.optimizer.setLoggerName(name + ".optimizer");
        }
        super.setLoggerName(this.loggerName + "._algorithm");
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("factoryForOptimizationAlgorithm", this.factoryForOptimizationAlgorithm);
        fields.put("constructedObject", this.constructedObject);
        fields.put("performanceOfObject", this.performanceOfObject);
        fields.put("optimizer", this.optimizer);
        return ToJSONStringUtil.toJSONString(fields);
    }

    public void cancel() {
        this.localLogger.info("Received cancel. First canceling the optimizer {}, then my own routine!", (Object)this.optimizer.getId());
        this.optimizer.cancel();
        this.localLogger.debug("Now canceling the OptimizingFactory itself.");
        super.cancel();
        assert (this.isCanceled()) : "Cancel-flag must be true at end of cancel routine!";
    }

    public void setTimeout(Timeout to) {
        super.setTimeout(to);
        this.localLogger.info("Forwarding timeout {} to optimizer.", (Object)to);
        this.optimizer.setTimeout(to);
    }
}

