/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.components.serialization;

import ai.libs.jaicore.components.model.ComponentInstance;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;

public class CompositionSerializer {
    private CompositionSerializer() {
    }

    public static ObjectNode serializeComponentInstance(ComponentInstance instance) {
        Objects.requireNonNull(instance);
        ObjectMapper om = new ObjectMapper();
        ObjectNode on = om.createObjectNode();
        on.put("component", instance.getComponent().getName());
        ObjectNode params = om.createObjectNode();
        for (String paramName : instance.getParameterValues().keySet()) {
            params.put(paramName, instance.getParameterValues().get(paramName));
        }
        on.set("params", (JsonNode)params);
        ObjectNode requiredInterfaces = om.createObjectNode();
        for (String requiredInterface : instance.getSatisfactionOfRequiredInterfaces().keySet()) {
            requiredInterfaces.set(requiredInterface, (JsonNode)CompositionSerializer.serializeComponentInstance(instance.getSatisfactionOfRequiredInterfaces().get(requiredInterface)));
        }
        on.set("requiredInterfaces", (JsonNode)requiredInterfaces);
        return on;
    }
}

