/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ea.algorithm.moea.moeaframework;

import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.EAlgorithmState;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.ea.algorithm.AEvolutionaryAlgorithm;
import ai.libs.jaicore.ea.algorithm.moea.moeaframework.IMOEAFrameworkAlgorithmConfig;
import ai.libs.jaicore.ea.algorithm.moea.moeaframework.IMOEAFrameworkAlgorithmInput;
import ai.libs.jaicore.ea.algorithm.moea.moeaframework.MOEAFrameworkAlgorithmResult;
import ai.libs.jaicore.ea.algorithm.moea.moeaframework.NSGAII;
import ai.libs.jaicore.ea.algorithm.moea.moeaframework.event.MOEAFrameworkAlgorithmResultEvent;
import ai.libs.jaicore.ea.algorithm.moea.moeaframework.util.MOEAFrameworkUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.NondominatedSortingPopulation;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.comparator.ChainedComparator;
import org.moeaframework.core.comparator.CrowdingComparator;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;
import org.moeaframework.core.operator.RandomInitialization;
import org.moeaframework.core.operator.TournamentSelection;
import org.moeaframework.core.spi.OperatorFactory;
import org.moeaframework.util.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MOEAFrameworkAlgorithm
extends AEvolutionaryAlgorithm<Population> {
    private Logger logger = LoggerFactory.getLogger(MOEAFrameworkAlgorithm.class);
    private Algorithm algorithm;
    private int numberOfGenerationsEvolved = 0;
    private double bestFitness = 1.0;
    private int numberOfGenerationsWOChange = 0;

    public MOEAFrameworkAlgorithm(IMOEAFrameworkAlgorithmConfig config, IMOEAFrameworkAlgorithmInput input) {
        super(config, input);
    }

    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        this.checkAndConductTermination();
        this.logger.info("{} step1: {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)this.getState());
        switch (this.getState()) {
            case CREATED: {
                try {
                    this.numberOfGenerationsEvolved = 0;
                    TypedProperties properties = new TypedProperties();
                    properties.setInt("populationSize", this.getConfig().populationSize());
                    properties.setDouble("sbx.rate", this.getConfig().crossoverRate());
                    properties.setDouble("pm.rate", this.getConfig().mutationRate());
                    RandomInitialization initialization = new RandomInitialization((Problem)this.getInput().getProblem(), this.getConfig().populationSize());
                    NondominatedSortingPopulation population = new NondominatedSortingPopulation();
                    TournamentSelection selection = new TournamentSelection(2, (DominanceComparator)new ChainedComparator(new DominanceComparator[]{new ParetoDominanceComparator(), new CrowdingComparator()}));
                    Variation variation = OperatorFactory.getInstance().getVariation(null, properties, (Problem)this.getInput().getProblem());
                    this.algorithm = new NSGAII((Problem)this.getInput().getProblem(), population, null, (Selection)selection, variation, (Initialization)initialization);
                    this.logger.info("{} step2", (Object)((Object)((Object)this)).getClass().getName());
                    this.algorithm.step();
                    return super.activate();
                }
                catch (Exception e) {
                    throw new AlgorithmException((Throwable)e, "Could not create the algorithm.");
                }
            }
            case ACTIVE: {
                this.logger.info("{} step3", (Object)((Object)((Object)this)).getClass().getName());
                this.algorithm.step();
                ++this.numberOfGenerationsWOChange;
                if (this.getCurrentResult().getResult().get(0).getObjective(0) + this.getConfig().earlyTerminationEpsilon() < this.bestFitness) {
                    this.bestFitness = this.getCurrentResult().getResult().get(0).getObjective(0);
                    this.numberOfGenerationsWOChange = 0;
                }
                return new MOEAFrameworkAlgorithmResultEvent(this.getId(), this.getCurrentResult());
            }
        }
        throw new AlgorithmException("The current algorithm state is >inactive<.");
    }

    public void reset() {
        this.setState(EAlgorithmState.CREATED);
    }

    public MOEAFrameworkAlgorithmResult getCurrentResult() throws AlgorithmException {
        this.algorithm.getResult();
        Population population = null;
        try {
            population = this.getPopulation();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AlgorithmException((Throwable)e, "Could not get the result!");
        }
        return new MOEAFrameworkAlgorithmResult(this.algorithm.getResult(), population);
    }

    public int getNumberOfGenerationsEvolved() {
        return this.numberOfGenerationsEvolved;
    }

    public int getNumberOfEvaluations() {
        if (this.algorithm == null) {
            return 0;
        }
        return this.algorithm.getNumberOfEvaluations();
    }

    public MOEAFrameworkAlgorithmResult call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        while (!(this.getState() != EAlgorithmState.CREATED && this.getState() != EAlgorithmState.ACTIVE || this.getConfig().numberOfGenerations() > 0 && this.numberOfGenerationsEvolved >= this.getConfig().numberOfGenerations() || this.getConfig().numberOfEvaluations() > 0 && this.algorithm.getNumberOfEvaluations() >= this.getConfig().numberOfEvaluations())) {
            this.nextWithException();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("\n=============\nCurrent Result:\n{}\nGen: {}/{}\nEvals: {}/{}\n=============", new Object[]{MOEAFrameworkUtil.populationToString(this.getCurrentResult().getResult()), this.numberOfGenerationsEvolved, this.getConfig().numberOfGenerations(), this.getNumberOfEvaluations(), this.getConfig().numberOfEvaluations()});
            }
            ++this.numberOfGenerationsEvolved;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("State: {} ", (Object)(this.getState() == EAlgorithmState.CREATED || this.getState() == EAlgorithmState.ACTIVE ? 1 : 0));
            this.logger.info("Generations: {} {}", (Object)(this.getConfig().numberOfGenerations() <= 0 ? 1 : 0), (Object)(this.numberOfGenerationsEvolved < this.getConfig().numberOfGenerations() ? 1 : 0));
            this.logger.info("Evaluations: {}", (Object)(this.getConfig().numberOfEvaluations() <= 0 || this.algorithm.getNumberOfEvaluations() < this.getConfig().numberOfEvaluations() ? 1 : 0));
            this.logger.info("Gen: {}/{}", (Object)this.numberOfGenerationsEvolved, (Object)this.getConfig().numberOfGenerations());
            this.logger.info("Evals: {}/{}", (Object)this.getNumberOfEvaluations(), (Object)this.getConfig().numberOfEvaluations());
        }
        return this.getCurrentResult();
    }

    public boolean terminateEvolution() {
        boolean condition;
        boolean bl = condition = this.getState() == EAlgorithmState.INACTIVE;
        if (this.getConfig().numberOfEvaluations() > 0) {
            boolean bl2 = condition = condition || this.getNumberOfEvaluations() >= this.getConfig().numberOfEvaluations();
        }
        if (this.getConfig().numberOfGenerations() > 0) {
            boolean bl3 = condition = condition || this.getNumberOfGenerationsEvolved() >= this.getConfig().numberOfGenerations();
        }
        if (this.getConfig().earlyTerminationGenerations() >= 0.0) {
            condition = condition || (double)this.numberOfGenerationsWOChange >= this.getConfig().earlyTerminationGenerations();
        }
        return condition;
    }

    public IMOEAFrameworkAlgorithmConfig getConfig() {
        return (IMOEAFrameworkAlgorithmConfig)super.getConfig();
    }

    public IMOEAFrameworkAlgorithmInput getInput() {
        return (IMOEAFrameworkAlgorithmInput)super.getInput();
    }

    protected Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Population getPopulation() throws IllegalAccessException, InvocationTargetException {
        if (this.algorithm instanceof NSGAII) {
            return ((NSGAII)this.algorithm).getPopulation();
        }
        Method getPopulationMethod = null;
        try {
            getPopulationMethod = this.getAlgorithm().getClass().getMethod("getPopulation", null);
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.logger.error("Encountered exception: {}", (Throwable)e);
        }
        if (getPopulationMethod == null) {
            throw new UnsupportedOperationException("The method getPopulation is not available for " + this.getAlgorithm().getClass().getName());
        }
        return (Population)getPopulationMethod.invoke((Object)this.getAlgorithm(), (Object[])null);
    }

    public List<Solution> getPopulationAsList() throws IllegalAccessException, InvocationTargetException {
        LinkedList<Solution> population = new LinkedList<Solution>();
        for (Solution solution : this.getPopulation()) {
            population.add(solution);
        }
        return population;
    }
}

