/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ea.algorithm.moea.moeaframework;

import ai.libs.jaicore.ea.algorithm.moea.moeaframework.AbstractEvolutionaryAlgorithm;
import java.util.ArrayList;
import java.util.LinkedList;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.EpsilonBoxEvolutionaryAlgorithm;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.NondominatedSortingPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.comparator.ChainedComparator;
import org.moeaframework.core.comparator.CrowdingComparator;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;
import org.moeaframework.core.operator.TournamentSelection;

public class NSGAII
extends AbstractEvolutionaryAlgorithm
implements EpsilonBoxEvolutionaryAlgorithm {
    private final Selection selection;
    private final Variation variation;

    public NSGAII(Problem problem, NondominatedSortingPopulation population, EpsilonBoxDominanceArchive archive, Selection selection, Variation variation, Initialization initialization) {
        super(problem, (Population)population, (NondominatedPopulation)archive, initialization);
        this.selection = selection;
        this.variation = variation;
    }

    @Override
    public void iterate() {
        NondominatedSortingPopulation population = this.getPopulation();
        EpsilonBoxDominanceArchive archive = this.getArchive();
        Population offspring = new Population();
        int populationSize = population.size();
        if (this.selection == null) {
            LinkedList pool = new LinkedList();
            ChainedComparator comparator = new ChainedComparator(new DominanceComparator[]{new ParetoDominanceComparator(), new CrowdingComparator()});
            while (offspring.size() < populationSize) {
                while (pool.size() < 2 * this.variation.getArity()) {
                    ArrayList<Solution> poolAdditions = new ArrayList<Solution>();
                    for (Solution solution : population) {
                        poolAdditions.add(solution);
                    }
                    PRNG.shuffle(poolAdditions);
                    pool.addAll(poolAdditions);
                }
                Solution[] parents = new Solution[this.variation.getArity()];
                for (int i = 0; i < parents.length; ++i) {
                    parents[i] = TournamentSelection.binaryTournament((Solution)((Solution)pool.removeFirst()), (Solution)((Solution)pool.removeFirst()), (DominanceComparator)comparator);
                }
                offspring.addAll(this.variation.evolve(parents));
            }
        } else {
            while (offspring.size() < populationSize) {
                Solution[] parents = this.selection.select(this.variation.getArity(), (Population)population);
                offspring.addAll(this.variation.evolve(parents));
            }
        }
        this.evaluateAll((Iterable<Solution>)offspring);
        if (archive != null) {
            archive.addAll((Iterable)offspring);
        }
        population.addAll((Iterable)offspring);
        population.truncate(populationSize);
    }

    public EpsilonBoxDominanceArchive getArchive() {
        return (EpsilonBoxDominanceArchive)super.getArchive();
    }

    public NondominatedSortingPopulation getPopulation() {
        return (NondominatedSortingPopulation)super.getPopulation();
    }
}

