/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ea.algorithm.moea.moeaframework;

import ai.libs.jaicore.ea.algorithm.moea.moeaframework.IBatchEvaluationProblem;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import org.moeaframework.algorithm.AlgorithmInitializationException;
import org.moeaframework.algorithm.AlgorithmTerminationException;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;

public abstract class AbstractAlgorithm
implements Algorithm {
    protected final Problem problem;
    protected int numberOfEvaluations;
    protected boolean initialized;
    protected boolean terminated;

    protected AbstractAlgorithm(Problem problem) {
        this.problem = problem;
    }

    public void evaluateAll(Iterable<Solution> solutions) {
        if (this.problem instanceof IBatchEvaluationProblem) {
            LinkedList<Solution> solutionList = new LinkedList<Solution>();
            for (Solution solution : solutions) {
                solutionList.add(solution);
            }
            ((IBatchEvaluationProblem)this.problem).evaluateBatch(solutionList);
            this.numberOfEvaluations += solutionList.size();
        } else {
            for (Solution solution : solutions) {
                this.evaluate(solution);
            }
        }
    }

    public void evaluateAll(Solution[] solutions) {
        this.evaluateAll(Arrays.asList(solutions));
    }

    public void evaluate(Solution solution) {
        this.problem.evaluate(solution);
        ++this.numberOfEvaluations;
    }

    public int getNumberOfEvaluations() {
        return this.numberOfEvaluations;
    }

    public Problem getProblem() {
        return this.problem;
    }

    protected void initialize() {
        if (this.initialized) {
            throw new AlgorithmInitializationException((Algorithm)this, "algorithm already initialized");
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void step() {
        if (this.isTerminated()) {
            throw new AlgorithmTerminationException((Algorithm)this, "algorithm already terminated");
        }
        if (!this.isInitialized()) {
            this.initialize();
        } else {
            this.iterate();
        }
    }

    protected abstract void iterate();

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() {
        if (this.terminated) {
            throw new AlgorithmTerminationException((Algorithm)this, "algorithm already terminated");
        }
        this.terminated = true;
    }

    public Serializable getState() throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }

    public void setState(Object state) throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }
}

