/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.basic.StringUtil;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.IExperimentDatabaseHandle;
import ai.libs.jaicore.experiments.IExperimentKeyGenerator;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.IExperimentSetEvaluator;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyExistsInDatabaseException;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentEvaluationFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentUpdateFailedException;
import ai.libs.jaicore.experiments.exceptions.IllegalExperimentSetupException;
import ai.libs.jaicore.experiments.exceptions.IllegalKeyDescriptorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentRunner {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentRunner.class);
    private static final String PROTOCOL_JAVA = "java:";
    private static final int MAX_MEM_DEVIATION = 50;
    private static final String LOGMESSAGE_CREATEINSTANCE = "Create a new instance of {} and ask it for the number of possible values.";
    private final IExperimentSetConfig config;
    private final IExperimentSetEvaluator conductor;
    private final IExperimentDatabaseHandle handle;
    private final Collection<ExperimentDBEntry> knownExperimentEntries = new HashSet<ExperimentDBEntry>();
    private Map<String, List<String>> valuesForKeyFields = new HashMap<String, List<String>>();
    private int memoryLimit;
    private int cpuLimit;
    private int totalNumberOfExperiments;
    private final Random random = new Random(System.currentTimeMillis());
    private boolean condMemoryLimitCheck = false;

    public ExperimentRunner(IExperimentSetConfig config, IExperimentSetEvaluator conductor, IExperimentDatabaseHandle databaseHandle) {
        this.config = config;
        if (config.getMemoryLimitInMB() == null) {
            throw new IllegalArgumentException("Memory field (mem.max) must be set in configuration");
        }
        if (config.getNumberOfCPUs() == null) {
            throw new IllegalArgumentException("Max CPU field (cpu.max) must be set in configuration");
        }
        if (config.getKeyFields() == null) {
            throw new IllegalArgumentException("Key fields (keyfields) entry must be set in configuration!");
        }
        if (config.getResultFields() == null) {
            throw new IllegalArgumentException("Result fields (resultfields) entry must be set in configuration!");
        }
        this.conductor = conductor;
        this.handle = databaseHandle;
    }

    private void updateExperimentSetupAccordingToConfig() throws IllegalKeyDescriptorException, ExperimentDBInteractionFailedException {
        if (this.condMemoryLimitCheck) {
            if (Math.abs((int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L) - this.config.getMemoryLimitInMB()) > 50) {
                logger.error("The true memory limit is {}, which differs from the {} specified in the config by more than the allowed {}MB!", new Object[]{this.memoryLimit, this.config.getMemoryLimitInMB(), 50});
            }
        } else {
            this.memoryLimit = this.config.getMemoryLimitInMB();
        }
        this.cpuLimit = this.config.getNumberOfCPUs();
        int numExperiments = 1;
        for (String key : this.config.getKeyFields()) {
            String propertyVals = this.config.removeProperty(key);
            if (propertyVals == null) {
                throw new IllegalArgumentException("No property values defined for key field \"" + key + "\"");
            }
            List vals = Arrays.asList(StringUtil.explode((String)propertyVals, (String)",")).stream().map(String::trim).collect(Collectors.toList());
            this.config.setProperty(key, propertyVals);
            this.valuesForKeyFields.put(key, vals);
            numExperiments *= this.getNumberOfValuesForKey(key);
        }
        this.handle.setup(this.config);
        for (ExperimentDBEntry experiment : this.handle.getConductedExperiments()) {
            if (this.isExperimentInLineWithSetup(experiment.getExperiment())) {
                this.knownExperimentEntries.add(experiment);
                continue;
            }
            logger.warn("Experiment with id {} and keys {} seems outdated. The reason can be an illegal key name or an outdated value for one of the keys. Enable DEBUG mode for more details.", (Object)experiment.getId(), experiment.getExperiment().getValuesOfKeyFields());
        }
        this.totalNumberOfExperiments = numExperiments;
    }

    private boolean isExperimentInLineWithSetup(Experiment experiment) {
        for (Map.Entry<String, String> keyEntry : experiment.getValuesOfKeyFields().entrySet()) {
            try {
                if (this.isValueForKeyValid(keyEntry.getKey(), keyEntry.getValue())) continue;
                logger.debug("Experiment {} seems outdated. The value {} for key {} is not admissible anymore. Consider removing it.", new Object[]{experiment, keyEntry.getKey(), keyEntry.getValue()});
                return false;
            }
            catch (IllegalKeyDescriptorException e) {
                logger.debug("Experiment {} seems outdated. The key {} is not defined in the current setup.", (Object)experiment, (Object)keyEntry.getKey());
                return false;
            }
        }
        return true;
    }

    private Experiment getExperimentForNumber(int id) throws IllegalExperimentSetupException {
        logger.debug("Computing experiment for id {}", (Object)id);
        if (id < 0) {
            throw new IllegalArgumentException("Experiment ID must be positive!");
        }
        if (id >= this.totalNumberOfExperiments) {
            throw new IllegalArgumentException("Invalid experiment ID " + id + ". Only " + this.totalNumberOfExperiments + " are possible with the given config.");
        }
        HashMap<String, Integer> blockSizes = new HashMap<String, Integer>();
        int size = 1;
        ArrayList<String> keyOrder = new ArrayList<String>(this.config.getKeyFields());
        Collections.reverse(keyOrder);
        for (String key : keyOrder) {
            blockSizes.put(key, size);
            int numValuesForKey = this.getNumberOfValuesForKey(key);
            if (numValuesForKey < 1) {
                throw new IllegalExperimentSetupException("Key \"" + key + "\" has no valid values.");
            }
            logger.trace("Identified {} possible values for key {}", (Object)numValuesForKey, (Object)key);
            size *= numValuesForKey;
        }
        HashMap<String, String> keyFieldValues = new HashMap<String, String>();
        int k = id;
        for (String key : this.config.getKeyFields()) {
            int s = (Integer)blockSizes.get(key);
            int index = (int)Math.floor((float)k / ((float)s * 1.0f));
            String value = this.getValueForKey(key, index);
            logger.trace("Determined value {} for key {}", (Object)value, (Object)key);
            keyFieldValues.put(key, value);
            k %= s;
        }
        assert (SetUtil.differenceEmpty(this.config.getKeyFields(), keyFieldValues.keySet()));
        return new Experiment(this.memoryLimit, this.cpuLimit, keyFieldValues);
    }

    private void checkUniquenessOfKey(String key) {
        if (this.valuesForKeyFields.get(key).size() > 1) {
            throw new UnsupportedOperationException("The value for key " + key + " seems to be a java class, but there are multiple values defined.");
        }
    }

    private void checkKeyGenerator(Class<?> c) throws IllegalKeyDescriptorException {
        if (!IExperimentKeyGenerator.class.isAssignableFrom(c)) {
            throw new IllegalKeyDescriptorException("The specified class " + c.getName() + " does not implement the " + IExperimentKeyGenerator.class.getName() + " interface.");
        }
    }

    private int getNumberOfValuesForKey(String key) throws IllegalKeyDescriptorException {
        List<String> possibleValues = this.valuesForKeyFields.get(key);
        if (possibleValues.isEmpty()) {
            return 0;
        }
        if (!possibleValues.get(0).startsWith(PROTOCOL_JAVA)) {
            return possibleValues.size();
        }
        this.checkUniquenessOfKey(key);
        try {
            Class<?> c = Class.forName(possibleValues.get(0).substring(5).trim());
            this.checkKeyGenerator(c);
            logger.trace(LOGMESSAGE_CREATEINSTANCE, (Object)c.getName());
            return ((IExperimentKeyGenerator)c.newInstance()).getNumberOfValues();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalKeyDescriptorException(e);
        }
    }

    private String getValueForKey(String key, int indexOfValue) throws IllegalKeyDescriptorException {
        List<String> possibleValues = this.valuesForKeyFields.get(key);
        assert (!possibleValues.isEmpty()) : "No values specified for key " + key;
        if (!possibleValues.get(0).startsWith(PROTOCOL_JAVA)) {
            return possibleValues.get(indexOfValue);
        }
        this.checkUniquenessOfKey(key);
        try {
            Class<?> c = Class.forName(possibleValues.get(0).substring(5).trim());
            this.checkKeyGenerator(c);
            logger.trace(LOGMESSAGE_CREATEINSTANCE, (Object)c.getName());
            Object value = ((IExperimentKeyGenerator)c.newInstance()).getValue(indexOfValue);
            if (value == null) {
                throw new NoSuchElementException("No value could be found for index " + indexOfValue + " in keyfield " + key);
            }
            return value.toString();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalKeyDescriptorException(e);
        }
    }

    private boolean isValueForKeyValid(String key, String value) throws IllegalKeyDescriptorException {
        List<String> possibleValues = this.valuesForKeyFields.get(key);
        assert (!possibleValues.isEmpty()) : "No values specified for key " + key;
        if (!possibleValues.get(0).startsWith(PROTOCOL_JAVA)) {
            return possibleValues.contains(value);
        }
        this.checkUniquenessOfKey(key);
        try {
            Class<?> c = Class.forName(possibleValues.get(0).substring(5).trim());
            this.checkKeyGenerator(c);
            logger.trace(LOGMESSAGE_CREATEINSTANCE, (Object)c.getName());
            return ((IExperimentKeyGenerator)c.newInstance()).isValueValid(value);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalKeyDescriptorException(e);
        }
    }

    public void randomlyConductExperiments(int maxNumberOfExperiments, boolean reload) throws ExperimentDBInteractionFailedException, IllegalExperimentSetupException {
        this.updateExperimentSetupAccordingToConfig();
        if (this.totalNumberOfExperiments <= 0) {
            logger.info("Number of total experiments is 0");
            return;
        }
        logger.info("Now conducting new experiment. {}/{} experiments have already been started or even been completed", (Object)this.knownExperimentEntries.size(), (Object)this.totalNumberOfExperiments);
        int numberOfConductedExperiments = 0;
        while (!Thread.interrupted() && this.knownExperimentEntries.size() < this.totalNumberOfExperiments && numberOfConductedExperiments < maxNumberOfExperiments) {
            if (reload) {
                this.config.reload();
            }
            this.updateExperimentSetupAccordingToConfig();
            int k = this.random.nextInt(this.totalNumberOfExperiments);
            logger.info("Now conducting {}/{}", (Object)k, (Object)this.totalNumberOfExperiments);
            Experiment exp = this.getExperimentForNumber(k);
            this.checkExperimentValidity(exp);
            logger.info("Conduct experiment with key values: {}", exp.getValuesOfKeyFields());
            if (!this.conductExperimentIfNotAlreadyConducted(exp)) continue;
            ++numberOfConductedExperiments;
        }
    }

    public void randomlyConductExperiments(boolean reload) throws ExperimentDBInteractionFailedException, IllegalExperimentSetupException {
        this.randomlyConductExperiments(-1, reload);
    }

    public boolean conductExperimentIfNotAlreadyConducted(Experiment exp) throws ExperimentDBInteractionFailedException {
        ExperimentDBEntry expEntry;
        try {
            expEntry = this.handle.createAndGetExperiment(exp);
        }
        catch (ExperimentAlreadyExistsInDatabaseException e) {
            return false;
        }
        assert (expEntry != null);
        Throwable error = null;
        this.knownExperimentEntries.add(expEntry);
        try {
            this.conductor.evaluate(expEntry, m -> {
                try {
                    this.handle.updateExperiment(expEntry, m);
                }
                catch (ExperimentUpdateFailedException e) {
                    logger.error("Error in updating experiment data. Message of {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                }
            });
        }
        catch (ExperimentEvaluationFailedException e) {
            error = e.getCause();
            logger.error("Experiment failed due to {}. Message: {}. Stack trace: {}", new Object[]{error.getClass().getName(), error.getMessage(), Arrays.asList(error.getStackTrace()).stream().map(s -> "\n\t" + s).collect(Collectors.toList())});
        }
        this.handle.finishExperiment(expEntry, error);
        return true;
    }

    public void setConditionMemoryLimitCheck(boolean doCheck) {
        this.condMemoryLimitCheck = doCheck;
    }

    private void checkExperimentValidity(Experiment experiment) {
        if (SetUtil.differenceNotEmpty(this.config.getKeyFields(), experiment.getValuesOfKeyFields().keySet())) {
            throw new IllegalArgumentException("The experiment " + experiment + " is invalid, because key fields have not been defined: " + SetUtil.difference(this.config.getKeyFields(), experiment.getValuesOfKeyFields().keySet()));
        }
    }
}

