/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments.databasehandle;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.IExperimentDatabaseHandle;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentUpdateFailedException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ExperimenterFileDBHandle
implements IExperimentDatabaseHandle {
    private final File file;
    private final Set<ExperimentDBEntry> knownExperiments = new HashSet<ExperimentDBEntry>();
    private final List<String> keyFields = new ArrayList<String>();

    public ExperimenterFileDBHandle(File file) {
        this.file = file;
    }

    @Override
    public void setup(IExperimentSetConfig config) throws ExperimentDBInteractionFailedException {
        this.keyFields.clear();
        this.keyFields.addAll(config.getKeyFields());
    }

    @Override
    public Collection<ExperimentDBEntry> getConductedExperiments() throws ExperimentDBInteractionFailedException {
        ArrayList<ExperimentDBEntry> experiments = new ArrayList<ExperimentDBEntry>();
        if (!this.file.exists() || !this.file.isFile()) {
            return experiments;
        }
        try {
            for (String line : FileUtil.readFileAsList((File)this.file)) {
                List values = Arrays.asList(line.split(",")).stream().map(String::trim).collect(Collectors.toList());
                int id = Integer.parseInt((String)values.remove(0));
                int memory = Integer.parseInt((String)values.remove(0));
                int cpus = Integer.parseInt((String)values.remove(0));
                HashMap<String, String> keyValues = new HashMap<String, String>();
                for (int i = 0; i < this.keyFields.size(); ++i) {
                    keyValues.put(this.keyFields.get(i), values.isEmpty() ? null : (String)values.get(i));
                }
                Experiment experiment = new Experiment(memory, cpus, keyValues);
                experiments.add(new ExperimentDBEntry(id, experiment));
            }
        }
        catch (IOException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
        this.knownExperiments.addAll(experiments);
        return experiments;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExperimentDBEntry createAndGetExperiment(Experiment experiment) throws ExperimentDBInteractionFailedException {
        Optional<ExperimentDBEntry> knownEntry = this.getConductedExperiments().stream().filter(e -> e.getExperiment().equals(experiment)).findFirst();
        if (knownEntry.isPresent()) {
            throw new IllegalArgumentException("Does already exist.");
        }
        try (FileWriter fw = new FileWriter(this.file, true);){
            int id = this.keyFields.size() + 1;
            fw.write(id + ", " + experiment.getMemoryInMB() + ", " + experiment.getNumCPUs() + ", " + System.currentTimeMillis() + "\n");
            ExperimentDBEntry entry = new ExperimentDBEntry(id, experiment);
            this.knownExperiments.add(entry);
            ExperimentDBEntry experimentDBEntry = entry;
            return experimentDBEntry;
        }
        catch (IOException e2) {
            throw new ExperimentDBInteractionFailedException(e2);
        }
    }

    @Override
    public void updateExperiment(ExperimentDBEntry exp, Map<String, ? extends Object> values) throws ExperimentUpdateFailedException {
    }

    @Override
    public void finishExperiment(ExperimentDBEntry exp) throws ExperimentDBInteractionFailedException {
    }

    @Override
    public void finishExperiment(ExperimentDBEntry exp, Throwable errror) throws ExperimentDBInteractionFailedException {
    }
}

