/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments.databasehandle;

import ai.libs.jaicore.basic.IDatabaseConfig;
import ai.libs.jaicore.basic.SQLAdapter;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.IExperimentDatabaseHandle;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentUpdateFailedException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimenterSQLHandle
implements IExperimentDatabaseHandle {
    private static final Logger logger = LoggerFactory.getLogger(ExperimenterSQLHandle.class);
    private static final String FIELD_ID = "experiment_id";
    private static final String FIELD_MEMORY = "memory";
    private static final String FIELD_HOST = "host";
    private static final String FIELD_NUMCPUS = "cpus";
    private static final String FIELD_TIME = "time";
    private final SQLAdapter adapter;
    private final String tablename;
    private final Collection<ExperimentDBEntry> knownExperimentEntries = new HashSet<ExperimentDBEntry>();
    private IExperimentSetConfig config;

    public ExperimenterSQLHandle(SQLAdapter adapter, String tablename) {
        this.adapter = adapter;
        this.tablename = tablename;
    }

    public ExperimenterSQLHandle(IDatabaseConfig config) {
        if (config.getDBHost() == null) {
            throw new IllegalArgumentException("DB host must not be null in experiment config.");
        }
        if (config.getDBUsername() == null) {
            throw new IllegalArgumentException("DB user must not be null in experiment config.");
        }
        if (config.getDBPassword() == null) {
            throw new IllegalArgumentException("DB password must not be null in experiment config.");
        }
        if (config.getDBDatabaseName() == null) {
            throw new IllegalArgumentException("DB database name must not be null in experiment config.");
        }
        if (config.getDBTableName() == null) {
            throw new IllegalArgumentException("DB table must not be null in experiment config.");
        }
        this.adapter = new SQLAdapter(config.getDBHost(), config.getDBUsername(), config.getDBPassword(), config.getDBDatabaseName(), config.getDBSSL() == null || config.getDBSSL() != false);
        this.tablename = config.getDBTableName();
    }

    @Override
    public void setup(IExperimentSetConfig config) throws ExperimentDBInteractionFailedException {
        this.config = config;
        StringBuilder sqlMainTable = new StringBuilder();
        StringBuilder keyFields = new StringBuilder();
        sqlMainTable.append("CREATE TABLE IF NOT EXISTS `" + this.tablename + "` (");
        sqlMainTable.append("`experiment_id` int(10) NOT NULL AUTO_INCREMENT,");
        for (String key : this.config.getKeyFields()) {
            String shortKey = this.getDatabaseFieldnameForConfigEntry(key);
            sqlMainTable.append("`" + shortKey + "` VARCHAR(100) NOT NULL,");
            keyFields.append("`" + shortKey + "`,");
        }
        sqlMainTable.append("`cpus` int(2) NOT NULL,");
        sqlMainTable.append("`host` varchar(255) NOT NULL,");
        sqlMainTable.append("`memory_max` int(6) NOT NULL,");
        sqlMainTable.append("`time_start` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,");
        for (String result : this.config.getResultFields()) {
            sqlMainTable.append("`" + result + "` VARCHAR(500) NULL,");
            if (this.config.getFieldsForWhichToIgnoreTime() == null || !this.config.getFieldsForWhichToIgnoreTime().contains(result)) {
                sqlMainTable.append("`" + result + "_" + FIELD_TIME + "` TIMESTAMP NULL,");
            }
            if (config.getFieldsForWhichToIgnoreMemory() != null && config.getFieldsForWhichToIgnoreMemory().contains(result)) continue;
            sqlMainTable.append("`" + result + "_" + FIELD_MEMORY + "` int(6) NULL,");
        }
        sqlMainTable.append("`exception` TEXT NULL,");
        sqlMainTable.append("`time_end` TIMESTAMP NULL,");
        sqlMainTable.append("PRIMARY KEY (`experiment_id`)");
        sqlMainTable.append(", UNIQUE KEY `keyFields` (" + keyFields.toString() + "`" + FIELD_NUMCPUS + "`, `" + FIELD_MEMORY + "_max`)");
        sqlMainTable.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin");
        try {
            this.adapter.update(sqlMainTable.toString(), new String[0]);
        }
        catch (SQLException e) {
            logger.error("An SQL exception occured with the following query: {}", (Object)sqlMainTable);
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ExperimentDBEntry> getConductedExperiments() throws ExperimentDBInteractionFailedException {
        HashSet<ExperimentDBEntry> experimentEntries = new HashSet<ExperimentDBEntry>();
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append("SELECT * FROM ");
        queryStringSB.append(this.tablename);
        try (ResultSet rs = this.adapter.getPreparedStatement(queryStringSB.toString()).executeQuery();){
            while (rs.next()) {
                HashMap<String, String> keyValues = new HashMap<String, String>();
                for (String key : this.config.getKeyFields()) {
                    String dbKey = this.getDatabaseFieldnameForConfigEntry(key);
                    keyValues.put(dbKey, rs.getString(dbKey));
                }
                experimentEntries.add(new ExperimentDBEntry(rs.getInt(FIELD_ID), new Experiment(rs.getInt("memory_max"), rs.getInt(FIELD_NUMCPUS), keyValues)));
            }
            this.knownExperimentEntries.addAll(experimentEntries);
            HashSet<ExperimentDBEntry> hashSet = experimentEntries;
            return hashSet;
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    public ExperimentDBEntry createAndGetExperiment(Map<String, String> values) throws ExperimentDBInteractionFailedException {
        return this.createAndGetExperiment(new Experiment(this.config.getMemoryLimitInMB(), this.config.getNumberOfCPUs(), values));
    }

    @Override
    public ExperimentDBEntry createAndGetExperiment(Experiment experiment) throws ExperimentDBInteractionFailedException {
        try {
            Optional<ExperimentDBEntry> existingExperiment = this.knownExperimentEntries.stream().filter(e -> e.getExperiment().equals(experiment)).findAny();
            if (existingExperiment.isPresent()) {
                return null;
            }
            HashMap<String, String> valuesToInsert = new HashMap<String, String>(experiment.getValuesOfKeyFields());
            valuesToInsert.put("memory_max", (String)((Object)Integer.valueOf(experiment.getMemoryInMB())));
            valuesToInsert.put(FIELD_NUMCPUS, (String)((Object)Integer.valueOf(experiment.getNumCPUs())));
            valuesToInsert.put(FIELD_HOST, InetAddress.getLocalHost().getHostName());
            logger.debug("Inserting mem: {}, cpus: {}, host: {}, and key fields: {}", new Object[]{experiment.getMemoryInMB(), experiment.getNumCPUs(), valuesToInsert.get(FIELD_HOST), experiment.getValuesOfKeyFields()});
            int id = this.adapter.insert(this.tablename, valuesToInsert);
            return new ExperimentDBEntry(id, experiment);
        }
        catch (UnknownHostException | SQLException e2) {
            throw new ExperimentDBInteractionFailedException(e2);
        }
    }

    @Override
    public void updateExperiment(ExperimentDBEntry exp, Map<String, ? extends Object> values) throws ExperimentUpdateFailedException {
        List<String> writableFields = this.config.getResultFields();
        writableFields.add("exception");
        writableFields.add("time_end");
        if (!writableFields.containsAll(values.keySet())) {
            throw new IllegalArgumentException("The value set contains non-result fields: " + SetUtil.difference(values.keySet(), writableFields));
        }
        String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String memoryUsageInMB = String.valueOf((int)Runtime.getRuntime().totalMemory() / 1024 / 1024);
        HashMap<String, String> valuesToWrite = new HashMap<String, String>();
        values.keySet().forEach(k -> valuesToWrite.put((String)k, values.get(k).toString()));
        for (String result : values.keySet()) {
            if (!this.config.getResultFields().contains(result)) continue;
            if (this.config.getFieldsForWhichToIgnoreTime() == null || !this.config.getFieldsForWhichToIgnoreTime().contains(result)) {
                valuesToWrite.put(result + "_" + FIELD_TIME, now);
            }
            if (this.config.getFieldsForWhichToIgnoreMemory() != null && this.config.getFieldsForWhichToIgnoreMemory().contains(result)) continue;
            valuesToWrite.put(result + "_" + FIELD_MEMORY, memoryUsageInMB);
        }
        HashMap<String, String> where = new HashMap<String, String>();
        where.put(FIELD_ID, String.valueOf(exp.getId()));
        try {
            this.adapter.update(this.tablename, valuesToWrite, where);
        }
        catch (SQLException e) {
            throw new ExperimentUpdateFailedException(e);
        }
    }

    @Override
    public void finishExperiment(ExperimentDBEntry expEntry, Throwable error) throws ExperimentDBInteractionFailedException {
        HashMap<String, String> valuesToAddAfterRun = new HashMap<String, String>();
        if (error != null) {
            StringBuilder exceptionEntry = new StringBuilder();
            exceptionEntry.append(error.getClass().getName() + "\n" + error.getMessage());
            for (StackTraceElement se : error.getStackTrace()) {
                exceptionEntry.append("\n\t" + se);
            }
            valuesToAddAfterRun.put("exception", exceptionEntry.toString());
        }
        valuesToAddAfterRun.put("time_end", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        this.updateExperiment(expEntry, valuesToAddAfterRun);
    }

    @Override
    public void finishExperiment(ExperimentDBEntry expEntry) throws ExperimentDBInteractionFailedException {
        this.finishExperiment(expEntry, null);
    }

    private String getDatabaseFieldnameForConfigEntry(String configKey) {
        return configKey.replace("\\.", "_");
    }
}

