/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.StringUtil;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.sets.LDSRelationComputer;
import ai.libs.jaicore.basic.sets.RelationComputationProblem;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.IExperimentDatabaseHandle;
import ai.libs.jaicore.experiments.IExperimentKeyGenerator;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyExistsInDatabaseException;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.IllegalExperimentSetupException;
import ai.libs.jaicore.experiments.exceptions.IllegalKeyDescriptorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentDatabasePreparer
implements ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(ExperimentDatabasePreparer.class);
    private static final String PROTOCOL_JAVA = "java:";
    private static final int MAX_MEM_DEVIATION = 50;
    private static final String LOGMESSAGE_CREATEINSTANCE = "Create a new instance of {} and ask it for the number of possible values.";
    private final IExperimentSetConfig config;
    private final IExperimentDatabaseHandle handle;
    private final Collection<Map<String, String>> keysForWhichResultsAreKnown = new HashSet<Map<String, String>>();
    private List<Map<String, String>> possibleKeyCombinations;
    private final String[] keyFields;
    private final Map<String, IExperimentKeyGenerator<?>> valueGeneratorsPerKey = new HashMap();
    private final Map<String, List<String>> valuesForKeyFieldsInConfig = new HashMap<String, List<String>>();
    private int memoryLimit;
    private int cpuLimit;
    private int totalNumberOfExperiments;
    private boolean condMemoryLimitCheck = false;

    public ExperimentDatabasePreparer(IExperimentSetConfig config, IExperimentDatabaseHandle databaseHandle) throws ExperimentDBInteractionFailedException {
        this.config = config;
        this.keyFields = config.getKeyFields().toArray(new String[config.getKeyFields().size()]);
        if (config.getMemoryLimitInMB() == null) {
            throw new IllegalArgumentException("Memory field (mem.max) must be set in configuration");
        }
        if (config.getNumberOfCPUs() == null) {
            throw new IllegalArgumentException("Max CPU field (cpu.max) must be set in configuration");
        }
        if (config.getKeyFields() == null) {
            throw new IllegalArgumentException("Key fields (keyfields) entry must be set in configuration!");
        }
        if (config.getResultFields() == null) {
            throw new IllegalArgumentException("Result fields (resultfields) entry must be set in configuration!");
        }
        this.handle = databaseHandle;
        this.logger.debug("Created ExperimentRunner. Now updating its configuration from the database.");
        this.updateExperimentSetupAccordingToConfigFromDatabase();
        this.logger.info("Successfully created and initialized ExperimentRunner.");
    }

    public List<ExperimentDBEntry> synchronizeExperiments() throws ExperimentDBInteractionFailedException, IllegalExperimentSetupException, ExperimentAlreadyExistsInDatabaseException, AlgorithmTimeoutedException, InterruptedException, AlgorithmExecutionCanceledException {
        List<Map<String, String>> tmpPossibleKeyCombinations = this.getAllPossibleKeyCombinations();
        this.logger.debug("Determined {} possible combinations. Will now remove keys that are already contained.", (Object)tmpPossibleKeyCombinations.size());
        int removed = 0;
        List<ExperimentDBEntry> installedExperiments = this.handle.getAllExperiments();
        this.logger.debug("Identified {} installed experiments. Removing these from the list of all possible experiments.", (Object)installedExperiments.size());
        for (ExperimentDBEntry experiment : installedExperiments) {
            tmpPossibleKeyCombinations.remove(experiment.getExperiment().getValuesOfKeyFields());
            ++removed;
        }
        this.logger.debug("{} experiments already exist. Number of experiments that will be created now is {}.", (Object)removed, (Object)tmpPossibleKeyCombinations.size());
        if (tmpPossibleKeyCombinations.isEmpty()) {
            return new ArrayList<ExperimentDBEntry>(0);
        }
        List<ExperimentDBEntry> entries = this.handle.createAndGetExperiments(tmpPossibleKeyCombinations.stream().map(t -> new Experiment(this.memoryLimit, this.cpuLimit, (Map<String, String>)t)).collect(Collectors.toList()));
        this.logger.info("Ids of {} inserted entries: {}", (Object)entries.size(), entries.stream().map(ExperimentDBEntry::getId).collect(Collectors.toList()));
        return entries;
    }

    private void updateExperimentSetupAccordingToConfigFromDatabase() throws ExperimentDBInteractionFailedException {
        if (this.condMemoryLimitCheck) {
            if (Math.abs((int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L) - this.config.getMemoryLimitInMB()) > 50) {
                this.logger.error("The true memory limit is {}, which differs from the {} specified in the config by more than the allowed {}MB!", new Object[]{this.memoryLimit, this.config.getMemoryLimitInMB(), 50});
            }
        } else {
            this.memoryLimit = this.config.getMemoryLimitInMB();
        }
        this.cpuLimit = this.config.getNumberOfCPUs();
        this.handle.setup(this.config);
        this.logger.debug("Reading all experiments from database.");
        this.totalNumberOfExperiments = this.handle.getNumberOfAllExperiments();
        this.logger.debug("Identified {} experiments. Now deriving the possible values for each key from the experiments.", (Object)this.totalNumberOfExperiments);
        for (String key : this.keyFields) {
            String propertyVals = this.config.removeProperty(key);
            if (propertyVals == null) {
                throw new IllegalArgumentException("No property values defined for key field \"" + key + "\"");
            }
            List vals = Arrays.asList(StringUtil.explode((String)propertyVals, (String)",")).stream().map(String::trim).collect(Collectors.toList());
            this.config.setProperty(key, propertyVals);
            this.valuesForKeyFieldsInConfig.put(key, vals);
        }
        for (ExperimentDBEntry experiment : this.handle.getConductedExperiments()) {
            if (this.isExperimentInLineWithSetup(experiment.getExperiment())) {
                this.keysForWhichResultsAreKnown.add(experiment.getExperiment().getValuesOfKeyFields());
                continue;
            }
            this.logger.warn("Experiment with id {} and keys {} seems outdated. The reason can be an illegal key name or an outdated value for one of the keys. Enable DEBUG mode for more details.", (Object)experiment.getId(), experiment.getExperiment().getValuesOfKeyFields());
        }
    }

    private void updateExperimentSetupAccordingToConfigFromScratch() throws IllegalKeyDescriptorException, ExperimentDBInteractionFailedException {
        if (this.condMemoryLimitCheck) {
            if (Math.abs((int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L) - this.config.getMemoryLimitInMB()) > 50) {
                this.logger.error("The true memory limit is {}, which differs from the {} specified in the config by more than the allowed {}MB!", new Object[]{this.memoryLimit, this.config.getMemoryLimitInMB(), 50});
            }
        } else {
            this.memoryLimit = this.config.getMemoryLimitInMB();
        }
        this.cpuLimit = this.config.getNumberOfCPUs();
        int numExperiments = 1;
        for (String key : this.keyFields) {
            String propertyVals = this.config.removeProperty(key);
            if (propertyVals == null) {
                throw new IllegalArgumentException("No property values defined for key field \"" + key + "\"");
            }
            List vals = Arrays.asList(StringUtil.explode((String)propertyVals, (String)",")).stream().map(String::trim).collect(Collectors.toList());
            this.config.setProperty(key, propertyVals);
            this.valuesForKeyFieldsInConfig.put(key, vals);
            numExperiments *= this.getNumberOfValuesForKey(key);
        }
        this.handle.setup(this.config);
        for (ExperimentDBEntry experiment : this.handle.getConductedExperiments()) {
            if (this.isExperimentInLineWithSetup(experiment.getExperiment())) {
                this.keysForWhichResultsAreKnown.add(experiment.getExperiment().getValuesOfKeyFields());
                continue;
            }
            this.logger.warn("Experiment with id {} and keys {} seems outdated. The reason can be an illegal key name or an outdated value for one of the keys. Enable DEBUG mode for more details.", (Object)experiment.getId(), experiment.getExperiment().getValuesOfKeyFields());
        }
        this.totalNumberOfExperiments = numExperiments;
    }

    private boolean isExperimentInLineWithSetup(Experiment experiment) {
        for (Map.Entry<String, String> keyEntry : experiment.getValuesOfKeyFields().entrySet()) {
            try {
                if (this.isValueForKeyValid(keyEntry.getKey(), keyEntry.getValue())) continue;
                this.logger.debug("Experiment {} seems outdated. The value {} for key {} is not admissible anymore. Consider removing it.", new Object[]{experiment, keyEntry.getKey(), keyEntry.getValue()});
                return false;
            }
            catch (IllegalKeyDescriptorException e) {
                this.logger.debug("Experiment {} seems outdated. The key {} is not defined in the current setup.", (Object)experiment, (Object)keyEntry.getKey());
                return false;
            }
        }
        return true;
    }

    public List<Map<String, String>> getAllPossibleKeyCombinations() throws IllegalExperimentSetupException, ExperimentDBInteractionFailedException, AlgorithmTimeoutedException, InterruptedException, AlgorithmExecutionCanceledException {
        if (this.possibleKeyCombinations == null) {
            this.logger.debug("Computing all possible experiments.");
            this.updateExperimentSetupAccordingToConfigFromScratch();
            ArrayList<List<String>> values = new ArrayList<List<String>>();
            for (String key : this.keyFields) {
                if (!this.valuesForKeyFieldsInConfig.containsKey(key)) {
                    throw new IllegalStateException("No values for key " + key + " have been defined!");
                }
                List<String> valuesForKey = this.getAllValuesForKey(key);
                this.logger.debug("Retrieving {} values for key {}. Enable TRACE to see all values.", (Object)valuesForKey.size(), (Object)key);
                this.logger.trace("Values for key {}: {}", (Object)key, valuesForKey);
                values.add(valuesForKey);
            }
            ArrayList<Predicate> constraints = new ArrayList<Predicate>();
            if (this.config.getConstraints() != null) {
                for (String p : this.config.getConstraints()) {
                    if (!p.startsWith(PROTOCOL_JAVA)) {
                        this.logger.warn("Ignoring constraint {} since currently only java constraints are allowed.", (Object)p);
                        continue;
                    }
                    try {
                        constraints.add((Predicate)Class.forName(p.substring(PROTOCOL_JAVA.length()).trim()).newInstance());
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        this.logger.error("Error in loading constraint {}: {}", (Object)p, (Object)e);
                    }
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Building relation from {} cartesian product with {} constraints.", (Object)values.stream().map(l -> "" + l.size()).collect(Collectors.joining(" x ")), (Object)constraints.size());
            }
            RelationComputationProblem problem = constraints.isEmpty() ? new RelationComputationProblem(values) : new RelationComputationProblem(values, (Predicate)constraints.get(0));
            LDSRelationComputer lc = new LDSRelationComputer(problem);
            lc.setLoggerName(this.getLoggerName() + ".relationcomputer");
            List combinationsAsList = lc.call();
            this.logger.info("Obtained {} key combinations. Now building maps from these.", (Object)combinationsAsList.size());
            this.possibleKeyCombinations = combinationsAsList.stream().map(this::mapValuesToKeyValueMap).collect(Collectors.toList());
        }
        return this.possibleKeyCombinations;
    }

    private Map<String, String> mapValuesToKeyValueMap(List<String> values) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        for (String key : this.keyFields) {
            map.put(key, values.get(i++));
        }
        return map;
    }

    private void checkUniquenessOfKey(String key) {
        if (this.valuesForKeyFieldsInConfig.get(key).size() > 1) {
            throw new UnsupportedOperationException("The value for key " + key + " seems to be a java class, but there are multiple values defined.");
        }
    }

    private void checkKeyGenerator(Class<?> c) throws IllegalKeyDescriptorException {
        if (!IExperimentKeyGenerator.class.isAssignableFrom(c)) {
            throw new IllegalKeyDescriptorException("The specified class " + c.getName() + " does not implement the " + IExperimentKeyGenerator.class.getName() + " interface.");
        }
    }

    private int getNumberOfValuesForKey(String key) throws IllegalKeyDescriptorException {
        List<String> possibleValues = this.valuesForKeyFieldsInConfig.get(key);
        if (possibleValues.isEmpty()) {
            return 0;
        }
        if (!possibleValues.get(0).startsWith(PROTOCOL_JAVA)) {
            return possibleValues.size();
        }
        this.checkUniquenessOfKey(key);
        try {
            Class<?> c = Class.forName(possibleValues.get(0).substring(5).trim());
            this.checkKeyGenerator(c);
            this.logger.trace(LOGMESSAGE_CREATEINSTANCE, (Object)c.getName());
            return ((IExperimentKeyGenerator)c.newInstance()).getNumberOfValues();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalKeyDescriptorException(e);
        }
    }

    private String getValueForKey(String key, int indexOfValue) {
        List<String> possibleValues = this.valuesForKeyFieldsInConfig.get(key);
        assert (!possibleValues.isEmpty()) : "No values specified for key " + key;
        if (!possibleValues.get(0).startsWith(PROTOCOL_JAVA)) {
            return possibleValues.get(indexOfValue);
        }
        this.checkUniquenessOfKey(key);
        IExperimentKeyGenerator keyGenerator = this.valueGeneratorsPerKey.computeIfAbsent(key, k -> {
            try {
                Class<?> c = Class.forName(((String)possibleValues.get(0)).substring(5).trim());
                this.checkKeyGenerator(c);
                this.logger.trace(LOGMESSAGE_CREATEINSTANCE, (Object)c.getName());
                return (IExperimentKeyGenerator)c.newInstance();
            }
            catch (IllegalKeyDescriptorException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        });
        Object value = keyGenerator.getValue(indexOfValue);
        if (value == null) {
            throw new NoSuchElementException("No value could be found for index " + indexOfValue + " in keyfield " + key);
        }
        return value.toString();
    }

    public List<String> getAllValuesForKey(String key) throws IllegalKeyDescriptorException {
        int n = this.getNumberOfValuesForKey(key);
        ArrayList<String> vals = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            vals.add(this.getValueForKey(key, i));
        }
        return vals;
    }

    private boolean isValueForKeyValid(String key, String value) throws IllegalKeyDescriptorException {
        List<String> possibleValues = this.valuesForKeyFieldsInConfig.get(key);
        assert (!possibleValues.isEmpty()) : "No values specified for key " + key;
        if (!possibleValues.get(0).startsWith(PROTOCOL_JAVA)) {
            return possibleValues.contains(value);
        }
        this.checkUniquenessOfKey(key);
        try {
            Class<?> c = Class.forName(possibleValues.get(0).substring(5).trim());
            this.checkKeyGenerator(c);
            this.logger.trace(LOGMESSAGE_CREATEINSTANCE, (Object)c.getName());
            return ((IExperimentKeyGenerator)c.newInstance()).isValueValid(value);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalKeyDescriptorException(e);
        }
    }

    public void setConditionMemoryLimitCheck(boolean doCheck) {
        this.condMemoryLimitCheck = doCheck;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.handle instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.handle).setLoggerName(name + ".handle");
        }
    }
}

