/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.IExperimentDatabaseHandle;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.IExperimentSetEvaluator;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyStartedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentEvaluationFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentUpdateFailedException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentRunner
implements ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(ExperimentRunner.class);
    private static final double MAX_MEM_DEVIATION = 0.15;
    private final IExperimentSetConfig config;
    private final IExperimentSetEvaluator conductor;
    private final IExperimentDatabaseHandle handle;
    private final int availableMemoryInMB;

    public ExperimentRunner(IExperimentSetConfig config, IExperimentSetEvaluator conductor, IExperimentDatabaseHandle databaseHandle) throws ExperimentDBInteractionFailedException {
        this.config = config;
        this.conductor = conductor;
        this.handle = databaseHandle;
        this.logger.debug("Created ExperimentRunner. Now updating its configuration from the database.");
        this.logger.info("Successfully created and initialized ExperimentRunner.");
        this.handle.setup(config);
        this.availableMemoryInMB = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
    }

    public void randomlyConductExperiments(int maxNumberOfExperiments) throws ExperimentDBInteractionFailedException, InterruptedException {
        this.logger.info("Starting to run up to {} experiments.", (Object)maxNumberOfExperiments);
        int numberOfConductedExperiments = 0;
        while (!(Thread.interrupted() || maxNumberOfExperiments > 0 && numberOfConductedExperiments >= maxNumberOfExperiments)) {
            List<ExperimentDBEntry> openRandomExperiments = this.handle.getRandomOpenExperiments(1);
            if (openRandomExperiments.isEmpty()) {
                this.logger.info("No more open experiments found.");
                break;
            }
            ExperimentDBEntry exp = openRandomExperiments.get(0);
            this.checkExperimentValidity(exp.getExperiment());
            this.logger.info("Conduct experiment with key values: {}", exp.getExperiment().getValuesOfKeyFields());
            try {
                this.conductExperiment(exp);
                ++numberOfConductedExperiments;
            }
            catch (ExperimentAlreadyStartedException e) {
                this.logger.warn("Experiment was conducted in the meanwhile.");
            }
        }
        this.logger.info("Successfully finished {} experiments.", (Object)numberOfConductedExperiments);
    }

    public void randomlyConductExperiments() throws ExperimentDBInteractionFailedException, InterruptedException {
        this.randomlyConductExperiments(-1);
    }

    public void conductExperiment(ExperimentDBEntry expEntry) throws ExperimentDBInteractionFailedException, ExperimentAlreadyStartedException, InterruptedException {
        if (expEntry == null) {
            throw new IllegalArgumentException("Cannot conduct NULL experiment!");
        }
        Throwable error = null;
        try {
            double memoryDeviation = (float)Math.abs(expEntry.getExperiment().getMemoryInMB() - this.availableMemoryInMB) * 1.0f / (float)expEntry.getExperiment().getMemoryInMB();
            if (memoryDeviation > 0.15) {
                throw new IllegalStateException("Cannot conduct experiment " + expEntry.getExperiment() + ", because the available memory is " + this.availableMemoryInMB + " where declared is " + expEntry.getExperiment().getMemoryInMB() + ". Deviation: " + memoryDeviation);
            }
            if (expEntry.getExperiment().getNumCPUs() > Runtime.getRuntime().availableProcessors()) {
                throw new IllegalStateException("Cannot conduct experiment " + expEntry.getExperiment() + ", because only " + Runtime.getRuntime().availableProcessors() + " CPU cores are available where declared is " + expEntry.getExperiment().getNumCPUs());
            }
            this.handle.startExperiment(expEntry);
            this.conductor.evaluate(expEntry, m -> {
                try {
                    this.handle.updateExperiment(expEntry, m);
                }
                catch (ExperimentUpdateFailedException e) {
                    this.logger.error("Error in updating experiment data. Message of {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                }
            });
        }
        catch (ExperimentEvaluationFailedException e) {
            error = e.getCause();
            this.logger.error("Experiment failed due to {}. Message: {}. Stack trace: {}", new Object[]{error.getClass().getName(), error.getMessage(), Arrays.asList(error.getStackTrace()).stream().map(s -> "\n\t" + s).collect(Collectors.toList())});
        }
        this.handle.finishExperiment(expEntry, error);
    }

    private void checkExperimentValidity(Experiment experiment) {
        if (SetUtil.differenceNotEmpty(this.config.getKeyFields(), experiment.getValuesOfKeyFields().keySet())) {
            throw new IllegalArgumentException("The experiment " + experiment + " is invalid, because key fields have not been defined: " + SetUtil.difference(this.config.getKeyFields(), experiment.getValuesOfKeyFields().keySet()));
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.handle instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.handle).setLoggerName(name + ".handle");
        }
    }
}

