/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments.databasehandle;

import ai.libs.jaicore.basic.IDatabaseConfig;
import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.SQLAdapter;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.IExperimentDatabaseHandle;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyExistsInDatabaseException;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyStartedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentUpdateFailedException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AExperimenterSQLHandle
implements IExperimentDatabaseHandle,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(AExperimenterSQLHandle.class);
    private static final String ERROR_NOSETUP = "No key fields defined. Setup the handler before using it.";
    private static final String FIELD_ID = "experiment_id";
    private static final String FIELD_MEMORY = "memory";
    private static final String FIELD_HOST = "host";
    private static final String FIELD_NUMCPUS = "cpus";
    private static final String FIELD_TIME = "time";
    private static final String FIELD_TIME_START = "time_started";
    private static final String FIELD_TIME_END = "time_end";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final SQLAdapter adapter;
    private final String tablename;
    private IExperimentSetConfig config;
    private String[] keyFields;
    private String[] resultFields;

    public AExperimenterSQLHandle(SQLAdapter adapter, String tablename) {
        this.adapter = adapter;
        this.tablename = tablename;
    }

    public AExperimenterSQLHandle(IDatabaseConfig config) {
        if (config.getDBDriver() == null) {
            throw new IllegalArgumentException("DB driver must not be null in experiment config.");
        }
        if (config.getDBHost() == null) {
            throw new IllegalArgumentException("DB host must not be null in experiment config.");
        }
        if (config.getDBUsername() == null) {
            throw new IllegalArgumentException("DB user must not be null in experiment config.");
        }
        if (config.getDBPassword() == null) {
            throw new IllegalArgumentException("DB password must not be null in experiment config.");
        }
        if (config.getDBDatabaseName() == null) {
            throw new IllegalArgumentException("DB database name must not be null in experiment config.");
        }
        if (config.getDBTableName() == null) {
            throw new IllegalArgumentException("DB table must not be null in experiment config.");
        }
        this.adapter = new SQLAdapter(config.getDBDriver(), config.getDBHost(), config.getDBUsername(), config.getDBPassword(), config.getDBDatabaseName(), null, config.getDBSSL() == null || config.getDBSSL() != false);
        this.tablename = config.getDBTableName();
    }

    @Override
    public void setup(IExperimentSetConfig config) throws ExperimentDBInteractionFailedException {
        this.config = config;
        this.keyFields = config.getKeyFields().toArray(new String[0]);
        this.resultFields = config.getResultFields().toArray(new String[0]);
        StringBuilder sqlMainTable = new StringBuilder();
        StringBuilder keyFieldsSB = new StringBuilder();
        sqlMainTable.append("CREATE TABLE IF NOT EXISTS `" + this.tablename + "` (");
        sqlMainTable.append("`experiment_id` int(10) NOT NULL AUTO_INCREMENT,");
        for (String key : this.keyFields) {
            String shortKey = this.getDatabaseFieldnameForConfigEntry(key);
            sqlMainTable.append("`" + shortKey + "` VARCHAR(1000) NOT NULL,");
            keyFieldsSB.append("`" + shortKey + "`,");
        }
        sqlMainTable.append("`cpus` int(2) NOT NULL,");
        sqlMainTable.append("`memory_max` int(6) NOT NULL,");
        sqlMainTable.append("`time_created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,");
        sqlMainTable.append("`host` varchar(255) NULL,");
        sqlMainTable.append("`time_started` TIMESTAMP NULL,");
        for (String result : this.resultFields) {
            sqlMainTable.append("`" + result + "` VARCHAR(500) NULL,");
            if (this.config.getFieldsForWhichToIgnoreTime() == null || !this.config.getFieldsForWhichToIgnoreTime().contains(result)) {
                sqlMainTable.append("`" + result + "_" + FIELD_TIME + "` TIMESTAMP NULL,");
            }
            if (config.getFieldsForWhichToIgnoreMemory() != null && config.getFieldsForWhichToIgnoreMemory().contains(result)) continue;
            sqlMainTable.append("`" + result + "_" + FIELD_MEMORY + "` int(6) NULL,");
        }
        sqlMainTable.append("`exception` TEXT NULL,");
        sqlMainTable.append("`time_end` TIMESTAMP NULL,");
        sqlMainTable.append("PRIMARY KEY (`experiment_id`)");
        sqlMainTable.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin");
        try {
            this.adapter.update(sqlMainTable.toString(), new String[0]);
        }
        catch (SQLException e) {
            this.logger.error("An SQL exception occured with the following query: {}", (Object)sqlMainTable);
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    private String getSQLPrefixForSelectQuery() {
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append("SELECT * FROM `");
        queryStringSB.append(this.tablename);
        queryStringSB.append("` ");
        return queryStringSB.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> getConsideredValuesForKey(String key) throws ExperimentDBInteractionFailedException {
        if (this.config == null || this.keyFields == null) {
            throw new IllegalStateException(ERROR_NOSETUP);
        }
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append("SELECT DISTINCT(`" + key + "`) FROM ");
        queryStringSB.append(this.tablename);
        try (PreparedStatement stmt = this.adapter.getPreparedStatement(queryStringSB.toString());){
            ArrayList<String> arrayList;
            block16: {
                ResultSet rs = stmt.executeQuery();
                try {
                    ArrayList<String> values = new ArrayList<String>();
                    while (rs.next()) {
                        values.add(rs.getString(1));
                    }
                    arrayList = values;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getNumberOfAllExperiments() throws ExperimentDBInteractionFailedException {
        if (this.config == null || this.keyFields == null) {
            throw new IllegalStateException(ERROR_NOSETUP);
        }
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append("SELECT COUNT(*) FROM ");
        queryStringSB.append(this.tablename);
        try (PreparedStatement stmt = this.adapter.getPreparedStatement(queryStringSB.toString());){
            int n;
            block15: {
                ResultSet rs = stmt.executeQuery();
                try {
                    rs.next();
                    n = rs.getInt(1);
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public List<ExperimentDBEntry> getAllExperiments() throws ExperimentDBInteractionFailedException {
        try {
            return this.getExperimentsForSQLQuery(this.getSQLPrefixForSelectQuery());
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public List<ExperimentDBEntry> getOpenExperiments() throws ExperimentDBInteractionFailedException {
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append(this.getSQLPrefixForSelectQuery());
        queryStringSB.append("WHERE time_started IS NULL");
        try {
            return this.getExperimentsForSQLQuery(queryStringSB.toString());
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public List<ExperimentDBEntry> getRandomOpenExperiments(int limit) throws ExperimentDBInteractionFailedException {
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append(this.getSQLPrefixForSelectQuery());
        queryStringSB.append("WHERE time_started IS NULL");
        queryStringSB.append(" ORDER BY RAND() LIMIT " + limit);
        try {
            return this.getExperimentsForSQLQuery(queryStringSB.toString());
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public List<ExperimentDBEntry> getRunningExperiments() throws ExperimentDBInteractionFailedException {
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append(this.getSQLPrefixForSelectQuery());
        queryStringSB.append("WHERE time_started IS NOT NULL AND time_end IS NULL");
        try {
            return this.getExperimentsForSQLQuery(queryStringSB.toString());
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public List<ExperimentDBEntry> getConductedExperiments() throws ExperimentDBInteractionFailedException {
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append(this.getSQLPrefixForSelectQuery());
        queryStringSB.append("WHERE time_started IS NOT NULL");
        try {
            return this.getExperimentsForSQLQuery(queryStringSB.toString());
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    private List<ExperimentDBEntry> getExperimentsForSQLQuery(String sql) throws SQLException {
        if (this.config == null || this.keyFields == null) {
            throw new IllegalStateException(ERROR_NOSETUP);
        }
        this.logger.debug("Executing query {}", (Object)sql);
        try (ResultSet rs = this.adapter.getPreparedStatement(sql).executeQuery();){
            this.logger.debug("Obtained results, now building experiment objects.");
            List<ExperimentDBEntry> list = this.getAllFromResultSet(rs);
            return list;
        }
    }

    private List<ExperimentDBEntry> getAllFromResultSet(ResultSet rs) throws SQLException {
        ArrayList<ExperimentDBEntry> experimentEntries = new ArrayList<ExperimentDBEntry>();
        int i = 0;
        long startAll = System.currentTimeMillis();
        while (rs.next()) {
            long start = System.currentTimeMillis();
            ExperimentDBEntry entry = this.getCurrentFromResultSet(rs);
            this.logger.trace("Building {}-th object took {}ms.", (Object)(++i), (Object)(System.currentTimeMillis() - start));
            experimentEntries.add(entry);
            if (i % 1000 != 0) continue;
            this.logger.debug("{} objects have been built within {}ms.", (Object)i, (Object)(System.currentTimeMillis() - startAll));
        }
        return experimentEntries;
    }

    private ExperimentDBEntry getCurrentFromResultSet(ResultSet rs) throws SQLException {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        for (String key : this.keyFields) {
            String dbKey = this.getDatabaseFieldnameForConfigEntry(key);
            keyValues.put(dbKey, rs.getString(dbKey));
            rs.getString(key);
        }
        HashMap<String, Object> resultValues = new HashMap<String, Object>();
        for (String key : this.resultFields) {
            String dbKey = this.getDatabaseFieldnameForConfigEntry(key);
            resultValues.put(dbKey, rs.getString(dbKey));
        }
        return new ExperimentDBEntry(rs.getInt(FIELD_ID), new Experiment(rs.getInt("memory_max"), rs.getInt(FIELD_NUMCPUS), keyValues, resultValues));
    }

    public ExperimentDBEntry createAndGetExperiment(Map<String, String> values) throws ExperimentDBInteractionFailedException, ExperimentAlreadyExistsInDatabaseException {
        return this.createAndGetExperiment(new Experiment(this.config.getMemoryLimitInMB(), this.config.getNumberOfCPUs(), values));
    }

    @Override
    public ExperimentDBEntry createAndGetExperiment(Experiment experiment) throws ExperimentDBInteractionFailedException, ExperimentAlreadyExistsInDatabaseException {
        try {
            Optional<ExperimentDBEntry> existingExperiment = this.getConductedExperiments().stream().filter(e -> e.getExperiment().equals(experiment)).findAny();
            if (existingExperiment.isPresent()) {
                throw new ExperimentAlreadyExistsInDatabaseException();
            }
            HashMap<String, String> valuesToInsert = new HashMap<String, String>(experiment.getValuesOfKeyFields());
            valuesToInsert.put("memory_max", (String)((Object)Integer.valueOf(experiment.getMemoryInMB())));
            valuesToInsert.put(FIELD_NUMCPUS, (String)((Object)Integer.valueOf(experiment.getNumCPUs())));
            this.logger.debug("Inserting mem: {}, cpus: {}, host: {}, and key fields: {}", new Object[]{experiment.getMemoryInMB(), experiment.getNumCPUs(), valuesToInsert.get(FIELD_HOST), experiment.getValuesOfKeyFields()});
            int id = this.adapter.insert(this.tablename, valuesToInsert)[0];
            return new ExperimentDBEntry(id, experiment);
        }
        catch (SQLException e2) {
            throw new ExperimentDBInteractionFailedException(e2);
        }
    }

    @Override
    public List<ExperimentDBEntry> createAndGetExperiments(List<Experiment> experiments) throws ExperimentDBInteractionFailedException, ExperimentAlreadyExistsInDatabaseException {
        if (experiments == null || experiments.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("memory_max");
        keys.add(FIELD_NUMCPUS);
        for (String key : this.keyFields) {
            keys.add(key);
        }
        ArrayList values = new ArrayList();
        for (Experiment exp : experiments) {
            ArrayList<String> datarow = new ArrayList<String>(keys.size());
            datarow.add("" + exp.getMemoryInMB());
            datarow.add("" + exp.getNumCPUs());
            for (String key : this.keyFields) {
                datarow.add(exp.getValuesOfKeyFields().get(key));
            }
            values.add(datarow);
        }
        try {
            this.logger.debug("Inserting {} entries", (Object)values.size());
            int[] ids = this.adapter.insertMultiple(this.tablename, keys, values);
            this.logger.debug("Inserted {} entries", (Object)ids.length);
            int n = ids.length;
            ArrayList<ExperimentDBEntry> entries = new ArrayList<ExperimentDBEntry>(n);
            for (int i = 0; i < n; ++i) {
                entries.add(new ExperimentDBEntry(ids[i], experiments.get(i)));
            }
            return entries;
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public void updateExperiment(ExperimentDBEntry exp, Map<String, ? extends Object> values) throws ExperimentUpdateFailedException {
        this.updateExperimentConditionally(exp, new HashMap<String, String>(), values);
    }

    @Override
    public boolean updateExperimentConditionally(ExperimentDBEntry exp, Map<String, String> conditions, Map<String, ? extends Object> values) throws ExperimentUpdateFailedException {
        List<String> resultFieldsAsList = Arrays.asList(this.resultFields);
        ArrayList<String> writableFields = new ArrayList<String>(resultFieldsAsList);
        writableFields.add(FIELD_HOST);
        writableFields.add(FIELD_TIME_START);
        writableFields.add("exception");
        writableFields.add(FIELD_TIME_END);
        if (!writableFields.containsAll(values.keySet())) {
            throw new IllegalArgumentException("The value set contains non-result fields: " + SetUtil.difference(values.keySet(), writableFields));
        }
        String now = new SimpleDateFormat(DATE_FORMAT).format(new Date());
        String memoryUsageInMB = String.valueOf((int)Runtime.getRuntime().totalMemory() / 1024 / 1024);
        HashMap<String, String> valuesToWrite = new HashMap<String, String>();
        values.keySet().forEach(k -> valuesToWrite.put((String)k, values.get(k).toString()));
        for (String result : values.keySet()) {
            if (!resultFieldsAsList.contains(result)) continue;
            if (this.config.getFieldsForWhichToIgnoreTime() == null || !this.config.getFieldsForWhichToIgnoreTime().contains(result)) {
                valuesToWrite.put(result + "_" + FIELD_TIME, now);
            }
            if (this.config.getFieldsForWhichToIgnoreMemory() != null && this.config.getFieldsForWhichToIgnoreMemory().contains(result)) continue;
            valuesToWrite.put(result + "_" + FIELD_MEMORY, memoryUsageInMB);
        }
        HashMap<String, String> where = new HashMap<String, String>();
        where.putAll(conditions);
        where.put(FIELD_ID, String.valueOf(exp.getId()));
        try {
            return this.adapter.update(this.tablename, valuesToWrite, where) >= 1;
        }
        catch (SQLException e) {
            throw new ExperimentUpdateFailedException(e);
        }
    }

    @Override
    public void finishExperiment(ExperimentDBEntry expEntry, Throwable error) throws ExperimentDBInteractionFailedException {
        HashMap<String, String> valuesToAddAfterRun = new HashMap<String, String>();
        if (error != null) {
            StringBuilder exceptionEntry = new StringBuilder();
            exceptionEntry.append(error.getClass().getName() + "\n" + error.getMessage());
            for (StackTraceElement se : error.getStackTrace()) {
                exceptionEntry.append("\n\t" + se);
            }
            valuesToAddAfterRun.put("exception", exceptionEntry.toString());
        }
        valuesToAddAfterRun.put(FIELD_TIME_END, new SimpleDateFormat(DATE_FORMAT).format(new Date()));
        this.updateExperiment(expEntry, valuesToAddAfterRun);
    }

    @Override
    public void finishExperiment(ExperimentDBEntry expEntry) throws ExperimentDBInteractionFailedException {
        this.finishExperiment(expEntry, null);
    }

    private String getDatabaseFieldnameForConfigEntry(String configKey) {
        return configKey.replace("\\.", "_");
    }

    @Override
    public void deleteExperiment(ExperimentDBEntry exp) throws ExperimentDBInteractionFailedException {
        try (PreparedStatement statement = this.adapter.getPreparedStatement("DELETE FROM `" + this.tablename + "` WHERE experiment_id = ?");){
            statement.setInt(1, exp.getId());
            statement.execute();
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public void deleteDatabase() throws ExperimentDBInteractionFailedException {
        try (PreparedStatement statement = this.adapter.getPreparedStatement("DROP TABLE `" + this.tablename + "`");){
            statement.execute();
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public void startExperiment(ExperimentDBEntry exp) throws ExperimentUpdateFailedException, ExperimentAlreadyStartedException {
        HashMap<String, String> initValues = new HashMap<String, String>();
        initValues.put(FIELD_TIME_START, new SimpleDateFormat(DATE_FORMAT).format(new Date()));
        try {
            initValues.put(FIELD_HOST, InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            throw new ExperimentUpdateFailedException(e);
        }
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put(FIELD_TIME_START, null);
        if (!this.updateExperimentConditionally(exp, condition, initValues)) {
            throw new ExperimentAlreadyStartedException();
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.adapter.setLoggerName(name + ".adapter");
    }

    @Override
    public ExperimentDBEntry getExperimentWithId(int id) throws ExperimentDBInteractionFailedException {
        if (this.config == null || this.keyFields == null) {
            throw new IllegalStateException(ERROR_NOSETUP);
        }
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append("SELECT * FROM `");
        queryStringSB.append(this.tablename);
        queryStringSB.append("` WHERE experiment_id = " + id);
        try {
            return this.getExperimentsForSQLQuery(queryStringSB.toString()).get(0);
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }
}

