/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.IEventBasedResultUpdater;
import ai.libs.jaicore.experiments.IExperimentDecoder;
import ai.libs.jaicore.experiments.IExperimentIntermediateResultProcessor;
import ai.libs.jaicore.experiments.IExperimentRunController;
import ai.libs.jaicore.experiments.IExperimentSetEvaluator;
import ai.libs.jaicore.experiments.IExperimentTerminationCriterion;
import ai.libs.jaicore.experiments.exceptions.ExperimentDecodingException;
import ai.libs.jaicore.experiments.exceptions.ExperimentEvaluationFailedException;
import ai.libs.jaicore.logging.LoggerUtil;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmBenchmarker
implements IExperimentSetEvaluator,
ILoggingCustomizable {
    private final IExperimentRunController<?> controller;
    private final Caps<?, ?> caps;
    private Logger logger = LoggerFactory.getLogger(AlgorithmBenchmarker.class);
    private Thread eventThread;

    public <I, A extends IAlgorithm<? extends I, ?>> AlgorithmBenchmarker(IExperimentDecoder<I, A> decoder, IExperimentRunController<?> controller) {
        this.caps = new Caps<I, A>(decoder);
        this.controller = controller;
    }

    @Override
    public final void evaluate(ExperimentDBEntry experimentEntry, IExperimentIntermediateResultProcessor processor) throws ExperimentEvaluationFailedException, InterruptedException {
        try {
            this.logger.info("Starting evaluation of experiment entry with keys {}", experimentEntry.getExperiment().getValuesOfKeyFields());
            IAlgorithm algorithm = (IAlgorithm)((Caps)this.caps).decoder.getAlgorithm(experimentEntry.getExperiment());
            this.logger.debug("Created optimizer {} for problem instance {}. Configuring logger name if possible.", (Object)algorithm, algorithm.getInput());
            if (algorithm instanceof ILoggingCustomizable) {
                ((ILoggingCustomizable)algorithm).setLoggerName(this.getLoggerName() + ".optimizer");
            }
            List<IEventBasedResultUpdater> resultUpdaters = this.controller.getResultUpdaterComputer(experimentEntry.getExperiment());
            List<IExperimentTerminationCriterion> terminationCriteria = this.controller.getTerminationCriteria(experimentEntry.getExperiment());
            final LinkedBlockingQueue eventQueue = new LinkedBlockingQueue();
            this.eventThread = new Thread(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    IAlgorithmEvent e = (IAlgorithmEvent)eventQueue.poll();
                    HashMap<String, Object> results = new HashMap<String, Object>();
                    for (IEventBasedResultUpdater updater : resultUpdaters) {
                        updater.processEvent(e, results);
                    }
                    if (!results.isEmpty()) {
                        processor.processResults(results);
                    }
                    if (!terminationCriteria.stream().anyMatch(c -> c.doesTerminate(e, algorithm))) continue;
                    this.logger.info("Stopping algorithm execution, because termination criterion fired.");
                    algorithm.cancel();
                    return;
                }
            }, "Experiment Event Processor");
            this.eventThread.start();
            algorithm.registerListener(new Object(){

                @Subscribe
                public void receiveEvent(IAlgorithmEvent e) {
                    eventQueue.add(e);
                }
            });
            Thread t = new Thread(() -> {
                try {
                    algorithm.call();
                }
                catch (AlgorithmExecutionCanceledException e) {
                    this.logger.info("CANCEL");
                }
                catch (NoSuchElementException e) {
                    this.logger.info("NO SUCH ELEMENT");
                }
                catch (Exception e) {
                    this.logger.error(LoggerUtil.getExceptionInfo((Throwable)e));
                }
            });
            t.start();
            t.join();
            HashMap<String, Object> results = new HashMap<String, Object>();
            for (IEventBasedResultUpdater updater : resultUpdaters) {
                updater.finish(results);
            }
            if (!results.isEmpty()) {
                processor.processResults(results);
            }
        }
        catch (ExperimentDecodingException e1) {
            throw new ExperimentEvaluationFailedException(e1);
        }
        finally {
            if (this.eventThread != null) {
                this.eventThread.interrupt();
                this.eventThread = null;
            }
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    private class Caps<I, A extends IAlgorithm<? extends I, ?>> {
        private final IExperimentDecoder<I, A> decoder;

        public Caps(IExperimentDecoder<I, A> decoder) {
            this.decoder = decoder;
        }
    }
}

