/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.db.IDatabaseConfig;
import ai.libs.jaicore.experiments.AlgorithmBenchmarker;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.ExperimentDatabasePreparer;
import ai.libs.jaicore.experiments.ExperimentDomain;
import ai.libs.jaicore.experiments.ExperimentRunner;
import ai.libs.jaicore.experiments.IExperimentBuilder;
import ai.libs.jaicore.experiments.IExperimentDatabaseHandle;
import ai.libs.jaicore.experiments.IExperimentRunController;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.IExperimentSetEvaluator;
import ai.libs.jaicore.experiments.databasehandle.ExperimenterMySQLHandle;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyExistsInDatabaseException;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentEvaluationFailedException;
import ai.libs.jaicore.experiments.exceptions.IllegalExperimentSetupException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.aeonbits.owner.ConfigFactory;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;

public class ExperimenterFrontend {
    private IExperimentSetConfig config;
    private IExperimentDatabaseHandle databaseHandle;
    private IExperimentSetEvaluator evaluator;
    private ExperimentDomain<?, ?, ?> domain;
    private IExperimentRunController<?> controller;
    private String loggerNameForAlgorithm;

    public ExperimenterFrontend withLoggerNameForAlgorithm(String loggerName) {
        this.loggerNameForAlgorithm = loggerName;
        return this;
    }

    public ExperimenterFrontend withDatabaseConfig(String databaseConfigFileName) {
        return this.withDatabaseConfig(new File(databaseConfigFileName));
    }

    public ExperimenterFrontend withDatabaseConfig(File ... databaseConfigFiles) {
        return this.withDatabaseConfig((IDatabaseConfig)((IDatabaseConfig)ConfigFactory.create(IDatabaseConfig.class, (Map[])new Map[0])).loadPropertiesFromFileArray(databaseConfigFiles));
    }

    public ExperimenterFrontend withDatabaseConfig(IDatabaseConfig databaseConfig) {
        this.databaseHandle = new ExperimenterMySQLHandle(databaseConfig);
        return this;
    }

    public ExperimenterFrontend withExperimentsConfig(File configFile) {
        return this.withExperimentsConfig((IExperimentSetConfig)((IExperimentSetConfig)ConfigFactory.create(IExperimentSetConfig.class, (Map[])new Map[0])).loadPropertiesFromFile(configFile));
    }

    public ExperimenterFrontend withExperimentsConfig(IExperimentSetConfig config) {
        this.config = config;
        return this;
    }

    public ExperimenterFrontend clearDatabase() throws ExperimentDBInteractionFailedException {
        this.databaseHandle.deleteDatabase();
        return this;
    }

    public ExperimenterFrontend withEvaluator(IExperimentSetEvaluator evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    public <B extends IExperimentBuilder, I, A extends IAlgorithm<? extends I, ?>> ExperimenterFrontend withAlgorithmExperimentDomain(ExperimentDomain<B, I, A> domain) {
        this.evaluator = null;
        this.withExperimentsConfig(domain.getConfig());
        this.domain = domain;
        return this;
    }

    public ExperimenterFrontend withController(IExperimentRunController<?> controller) {
        this.controller = controller;
        return this;
    }

    public ExperimenterFrontend synchronizeDatabase() throws ExperimentDBInteractionFailedException, AlgorithmTimeoutedException, IllegalExperimentSetupException, ExperimentAlreadyExistsInDatabaseException, InterruptedException, AlgorithmExecutionCanceledException {
        ExperimentDatabasePreparer preparer = new ExperimentDatabasePreparer(this.config, this.databaseHandle);
        preparer.synchronizeExperiments();
        return this;
    }

    private void prepareEvaluator() {
        if (this.controller == null) {
            throw new IllegalStateException("Cannot prepare evaluator, because no experiment controller has been set!");
        }
        if (this.domain != null) {
            this.evaluator = new AlgorithmBenchmarker(this.domain.getDecoder(), this.controller);
            if (this.loggerNameForAlgorithm != null) {
                ((AlgorithmBenchmarker)this.evaluator).setLoggerName(this.loggerNameForAlgorithm);
            }
        }
    }

    public void randomlyConductExperiments() throws ExperimentDBInteractionFailedException, InterruptedException {
        this.prepareEvaluator();
        new ExperimentRunner(this.config, this.evaluator, this.databaseHandle).randomlyConductExperiments();
    }

    public ExperimenterFrontend randomlyConductExperiments(int limit) throws ExperimentDBInteractionFailedException, InterruptedException {
        if (this.config == null) {
            throw new IllegalStateException("Cannot conduct experiments. No experiment config has been set, yet.");
        }
        if (this.databaseHandle == null) {
            throw new IllegalStateException("Cannot conduct experiments. No database handle has been set, yet.");
        }
        this.prepareEvaluator();
        ExperimentRunner runner = new ExperimentRunner(this.config, this.evaluator, this.databaseHandle);
        runner.setLoggerName(this.loggerNameForAlgorithm + ".runner");
        runner.randomlyConductExperiments(limit);
        return this;
    }

    public <O> O simulateExperiment(Experiment experiment, IExperimentRunController<O> controller) throws ExperimentEvaluationFailedException, InterruptedException {
        this.withController(controller);
        this.prepareEvaluator();
        ExperimentDBEntry experimentEntry = new ExperimentDBEntry(-1, experiment);
        HashMap<String, Object> results = new HashMap<String, Object>();
        this.evaluator.evaluate(experimentEntry, results::putAll);
        Experiment expCopy = new Experiment(experiment);
        expCopy.setValuesOfResultFields(results);
        return controller.parseResultMap(expCopy);
    }
}

