/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyExistsInDatabaseException;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyStartedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentUpdateFailedException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface IExperimentDatabaseHandle {
    public void setup(IExperimentSetConfig var1) throws ExperimentDBInteractionFailedException;

    public Collection<String> getConsideredValuesForKey(String var1) throws ExperimentDBInteractionFailedException;

    public List<ExperimentDBEntry> getAllExperiments() throws ExperimentDBInteractionFailedException;

    public int getNumberOfAllExperiments() throws ExperimentDBInteractionFailedException;

    public List<ExperimentDBEntry> getConductedExperiments() throws ExperimentDBInteractionFailedException;

    public List<ExperimentDBEntry> getOpenExperiments() throws ExperimentDBInteractionFailedException;

    public List<ExperimentDBEntry> getRandomOpenExperiments(int var1) throws ExperimentDBInteractionFailedException;

    public List<ExperimentDBEntry> getRunningExperiments() throws ExperimentDBInteractionFailedException;

    public ExperimentDBEntry getExperimentWithId(int var1) throws ExperimentDBInteractionFailedException;

    public ExperimentDBEntry createAndGetExperiment(Experiment var1) throws ExperimentDBInteractionFailedException, ExperimentAlreadyExistsInDatabaseException;

    public List<ExperimentDBEntry> createAndGetExperiments(List<Experiment> var1) throws ExperimentDBInteractionFailedException, ExperimentAlreadyExistsInDatabaseException;

    public void startExperiment(ExperimentDBEntry var1) throws ExperimentAlreadyStartedException, ExperimentUpdateFailedException;

    public void updateExperiment(ExperimentDBEntry var1, Map<String, ? extends Object> var2) throws ExperimentUpdateFailedException;

    public boolean updateExperimentConditionally(ExperimentDBEntry var1, Map<String, String> var2, Map<String, ? extends Object> var3) throws ExperimentUpdateFailedException;

    public void finishExperiment(ExperimentDBEntry var1) throws ExperimentDBInteractionFailedException;

    public void finishExperiment(ExperimentDBEntry var1, Throwable var2) throws ExperimentDBInteractionFailedException;

    public void deleteExperiment(ExperimentDBEntry var1) throws ExperimentDBInteractionFailedException;

    public void deleteDatabase() throws ExperimentDBInteractionFailedException;
}

