/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments.databasehandle;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.db.IDatabaseAdapter;
import ai.libs.jaicore.db.IDatabaseConfig;
import ai.libs.jaicore.db.sql.SQLAdapter;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.IExperimentDatabaseHandle;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyExistsInDatabaseException;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyStartedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentUpdateFailedException;
import ai.libs.jaicore.logging.LoggerUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.kvstore.IKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AExperimenterSQLHandle
implements IExperimentDatabaseHandle,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(AExperimenterSQLHandle.class);
    private static final String ERROR_NOSETUP = "No key fields defined. Setup the handler before using it.";
    private static final String FIELD_ID = "experiment_id";
    private static final String FIELD_MEMORY = "memory";
    private static final String FIELD_MEMORY_MAX = "memory_max";
    private static final String FIELD_HOST = "host";
    private static final String FIELD_NUMCPUS = "cpus";
    private static final String FIELD_TIME = "time";
    private static final String FIELD_TIME_START = "time_started";
    private static final String FIELD_TIME_END = "time_end";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected final IDatabaseAdapter adapter;
    protected final String tablename;
    private IExperimentSetConfig config;
    private String[] keyFields;
    private String[] resultFields;

    public AExperimenterSQLHandle(IDatabaseAdapter adapter, String tablename) {
        this.adapter = adapter;
        this.tablename = tablename;
    }

    public AExperimenterSQLHandle(IDatabaseConfig config) {
        if (config.getDBDriver() == null) {
            throw new IllegalArgumentException("DB driver must not be null in experiment config.");
        }
        if (config.getDBHost() == null) {
            throw new IllegalArgumentException("DB host must not be null in experiment config.");
        }
        if (config.getDBUsername() == null) {
            throw new IllegalArgumentException("DB user must not be null in experiment config.");
        }
        if (config.getDBPassword() == null) {
            throw new IllegalArgumentException("DB password must not be null in experiment config.");
        }
        if (config.getDBDatabaseName() == null) {
            throw new IllegalArgumentException("DB database name must not be null in experiment config.");
        }
        if (config.getDBTableName() == null) {
            throw new IllegalArgumentException("DB table must not be null in experiment config.");
        }
        this.adapter = new SQLAdapter(config.getDBDriver(), config.getDBHost(), config.getDBUsername(), config.getDBPassword(), config.getDBDatabaseName(), null, config.getDBSSL() == null || config.getDBSSL() != false);
        this.tablename = config.getDBTableName();
    }

    protected String getSetupCreateTableQuery() {
        StringBuilder sqlMainTable = new StringBuilder();
        StringBuilder keyFieldsSB = new StringBuilder();
        sqlMainTable.append("CREATE TABLE IF NOT EXISTS `" + this.tablename + "` (");
        sqlMainTable.append("`experiment_id` int(10) NOT NULL AUTO_INCREMENT,");
        for (String key : this.keyFields) {
            String shortKey = this.getDatabaseFieldnameForConfigEntry(key);
            sqlMainTable.append("`" + shortKey + "` VARCHAR(1000) NOT NULL,");
            keyFieldsSB.append("`" + shortKey + "`,");
        }
        sqlMainTable.append("`cpus` int(2) NOT NULL,");
        sqlMainTable.append("`memory_max` int(6) NOT NULL,");
        sqlMainTable.append("`time_created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,");
        sqlMainTable.append("`host` varchar(255) NULL,");
        sqlMainTable.append("`time_started` TIMESTAMP NULL,");
        for (String result : this.resultFields) {
            sqlMainTable.append("`" + result + "` VARCHAR(500) NULL,");
            if (this.config.getFieldsForWhichToIgnoreTime() == null || !this.config.getFieldsForWhichToIgnoreTime().contains(result)) {
                sqlMainTable.append("`" + result + "_" + FIELD_TIME + "` TIMESTAMP NULL,");
            }
            if (this.config.getFieldsForWhichToIgnoreMemory() != null && this.config.getFieldsForWhichToIgnoreMemory().contains(result)) continue;
            sqlMainTable.append("`" + result + "_" + FIELD_MEMORY + "` int(6) NULL,");
        }
        sqlMainTable.append("`exception` TEXT NULL,");
        sqlMainTable.append("`time_end` TIMESTAMP NULL,");
        sqlMainTable.append("PRIMARY KEY (`experiment_id`)");
        sqlMainTable.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin");
        return sqlMainTable.toString();
    }

    @Override
    public void setup(IExperimentSetConfig config) throws ExperimentDBInteractionFailedException {
        this.config = config;
        this.keyFields = config.getKeyFields().toArray(new String[0]);
        this.resultFields = config.getResultFields().toArray(new String[0]);
        String createTableQuery = this.getSetupCreateTableQuery();
        try {
            this.adapter.update(createTableQuery, new String[0]);
        }
        catch (SQLException e) {
            this.logger.error("An SQL exception occured with the following query: {}", (Object)createTableQuery);
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    protected String getSQLPrefixForKeySelectQuery() {
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append("SELECT `experiment_id`, `memory_max`, `cpus`, " + Arrays.stream(this.keyFields).collect(Collectors.joining(", ")) + " FROM `");
        queryStringSB.append(this.tablename);
        queryStringSB.append("` ");
        return queryStringSB.toString();
    }

    protected String getSQLPrefixForSelectQuery() {
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append("SELECT * FROM `");
        queryStringSB.append(this.tablename);
        queryStringSB.append("` ");
        return queryStringSB.toString();
    }

    @Override
    public Collection<String> getConsideredValuesForKey(String key) throws ExperimentDBInteractionFailedException {
        if (this.config == null || this.keyFields == null) {
            throw new IllegalStateException(ERROR_NOSETUP);
        }
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append("SELECT DISTINCT(`" + key + "`) as d FROM ");
        queryStringSB.append(this.tablename);
        try {
            List res = this.adapter.getRowsOfTable(queryStringSB.toString());
            return res.stream().map(x -> x.getAsString("d")).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public int getNumberOfAllExperiments() throws ExperimentDBInteractionFailedException {
        if (this.config == null || this.keyFields == null) {
            throw new IllegalStateException(ERROR_NOSETUP);
        }
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append("SELECT COUNT(*) as c FROM ");
        queryStringSB.append(this.tablename);
        try {
            List res = this.adapter.getResultsOfQuery(queryStringSB.toString());
            return ((IKVStore)res.get(0)).getAsInt("c");
        }
        catch (Exception e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public List<ExperimentDBEntry> getAllExperiments() throws ExperimentDBInteractionFailedException {
        try {
            return this.getExperimentsForSQLQuery(this.getSQLPrefixForSelectQuery());
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public List<ExperimentDBEntry> getOpenExperiments() throws ExperimentDBInteractionFailedException {
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append(this.getSQLPrefixForKeySelectQuery());
        queryStringSB.append("WHERE time_started IS NULL");
        try {
            return this.getExperimentsForSQLQuery(queryStringSB.toString());
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public List<ExperimentDBEntry> getRandomOpenExperiments(int limit) throws ExperimentDBInteractionFailedException {
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append(this.getSQLPrefixForKeySelectQuery());
        queryStringSB.append("WHERE time_started IS NULL");
        queryStringSB.append(" ORDER BY RAND() LIMIT " + limit);
        try {
            return this.getExperimentsForSQLQuery(queryStringSB.toString());
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public List<ExperimentDBEntry> getRunningExperiments() throws ExperimentDBInteractionFailedException {
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append(this.getSQLPrefixForKeySelectQuery());
        queryStringSB.append("WHERE time_started IS NOT NULL AND time_end IS NULL");
        try {
            return this.getExperimentsForSQLQuery(queryStringSB.toString());
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public List<ExperimentDBEntry> getConductedExperiments() throws ExperimentDBInteractionFailedException {
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append(this.getSQLPrefixForSelectQuery());
        queryStringSB.append("WHERE time_started IS NOT NULL");
        try {
            return this.getExperimentsForSQLQuery(queryStringSB.toString());
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException("Given query was:\n" + queryStringSB.toString(), e);
        }
    }

    protected List<ExperimentDBEntry> getExperimentsForSQLQuery(String sql) throws SQLException {
        if (this.config == null || this.keyFields == null) {
            throw new IllegalStateException(ERROR_NOSETUP);
        }
        this.logger.debug("Executing query {}", (Object)sql);
        List res = this.adapter.getResultsOfQuery(sql);
        this.logger.debug("Obtained results, now building experiment objects.");
        ArrayList<ExperimentDBEntry> experimentEntries = new ArrayList<ExperimentDBEntry>();
        int i = 0;
        long startAll = System.currentTimeMillis();
        for (IKVStore store : res) {
            long start = System.currentTimeMillis();
            HashMap<String, String> keyValues = new HashMap<String, String>();
            for (String key : this.keyFields) {
                String dbKey = this.getDatabaseFieldnameForConfigEntry(key);
                keyValues.put(dbKey, store.getAsString(dbKey));
            }
            HashMap<String, Object> resultValues = new HashMap<String, Object>();
            for (String key : this.resultFields) {
                String dbKey = this.getDatabaseFieldnameForConfigEntry(key);
                resultValues.put(dbKey, store.getAsString(dbKey));
            }
            ExperimentDBEntry entry = new ExperimentDBEntry(store.getAsInt(FIELD_ID), new Experiment(store.getAsInt(FIELD_MEMORY_MAX), store.getAsInt(FIELD_NUMCPUS), keyValues, resultValues));
            this.logger.trace("Building {}-th object took {}ms.", (Object)(++i), (Object)(System.currentTimeMillis() - start));
            experimentEntries.add(entry);
            if (i % 1000 != 0) continue;
            this.logger.debug("{} objects have been built within {}ms.", (Object)i, (Object)(System.currentTimeMillis() - startAll));
        }
        return experimentEntries;
    }

    public ExperimentDBEntry createAndGetExperiment(Map<String, String> values) throws ExperimentDBInteractionFailedException, ExperimentAlreadyExistsInDatabaseException {
        return this.createAndGetExperiment(new Experiment(this.config.getMemoryLimitInMB(), this.config.getNumberOfCPUs(), values));
    }

    @Override
    public ExperimentDBEntry createAndGetExperiment(Experiment experiment) throws ExperimentDBInteractionFailedException, ExperimentAlreadyExistsInDatabaseException {
        try {
            Optional<ExperimentDBEntry> existingExperiment = this.getConductedExperiments().stream().filter(e -> e.getExperiment().equals(experiment)).findAny();
            if (existingExperiment.isPresent()) {
                throw new ExperimentAlreadyExistsInDatabaseException();
            }
            HashMap<String, String> valuesToInsert = new HashMap<String, String>(experiment.getValuesOfKeyFields());
            valuesToInsert.put(FIELD_MEMORY_MAX, (String)((Object)Integer.valueOf(experiment.getMemoryInMB())));
            valuesToInsert.put(FIELD_NUMCPUS, (String)((Object)Integer.valueOf(experiment.getNumCPUs())));
            this.logger.debug("Inserting mem: {}, cpus: {}, host: {}, and key fields: {}", new Object[]{experiment.getMemoryInMB(), experiment.getNumCPUs(), valuesToInsert.get(FIELD_HOST), experiment.getValuesOfKeyFields()});
            int id = this.adapter.insert(this.tablename, valuesToInsert)[0];
            return new ExperimentDBEntry(id, experiment);
        }
        catch (SQLException e2) {
            throw new ExperimentDBInteractionFailedException(e2);
        }
    }

    @Override
    public List<ExperimentDBEntry> createAndGetExperiments(List<Experiment> experiments) throws ExperimentDBInteractionFailedException, ExperimentAlreadyExistsInDatabaseException {
        if (experiments == null || experiments.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(FIELD_MEMORY_MAX);
        keys.add(FIELD_NUMCPUS);
        keys.addAll(Arrays.asList(this.keyFields));
        ArrayList values = new ArrayList();
        for (Experiment exp : experiments) {
            ArrayList<String> datarow = new ArrayList<String>(keys.size());
            datarow.add("" + exp.getMemoryInMB());
            datarow.add("" + exp.getNumCPUs());
            for (String key : this.keyFields) {
                datarow.add(exp.getValuesOfKeyFields().get(key));
            }
            values.add(datarow);
        }
        try {
            this.logger.debug("Inserting {} entries", (Object)values.size());
            int[] ids = this.adapter.insertMultiple(this.tablename, keys, values);
            this.logger.debug("Inserted {} entries", (Object)ids.length);
            int n = ids.length;
            ArrayList<ExperimentDBEntry> entries = new ArrayList<ExperimentDBEntry>(n);
            for (int i = 0; i < n; ++i) {
                entries.add(new ExperimentDBEntry(ids[i], experiments.get(i)));
            }
            return entries;
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public void updateExperiment(ExperimentDBEntry exp, Map<String, ? extends Object> values) throws ExperimentUpdateFailedException {
        this.updateExperimentConditionally(exp, new HashMap<String, String>(), values);
    }

    @Override
    public boolean updateExperimentConditionally(ExperimentDBEntry exp, Map<String, String> conditions, Map<String, ? extends Object> values) throws ExperimentUpdateFailedException {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("No values provided for experiment update of experiment " + exp);
        }
        List<String> resultFieldsAsList = Arrays.asList(this.resultFields);
        ArrayList<String> writableFields = new ArrayList<String>(resultFieldsAsList);
        writableFields.add(FIELD_HOST);
        writableFields.add(FIELD_TIME_START);
        writableFields.add("exception");
        writableFields.add(FIELD_TIME_END);
        if (!writableFields.containsAll(values.keySet())) {
            throw new IllegalArgumentException("The value set contains non-result fields: " + SetUtil.difference(values.keySet(), writableFields));
        }
        String now = new SimpleDateFormat(DATE_FORMAT).format(new Date());
        String memoryUsageInMB = String.valueOf((int)Runtime.getRuntime().totalMemory() / 1024 / 1024);
        HashMap<String, String> valuesToWrite = new HashMap<String, String>();
        values.keySet().forEach(k -> valuesToWrite.put((String)k, values.get(k).toString()));
        for (String result : values.keySet()) {
            if (!resultFieldsAsList.contains(result)) continue;
            if (this.config.getFieldsForWhichToIgnoreTime() == null || !this.config.getFieldsForWhichToIgnoreTime().contains(result)) {
                valuesToWrite.put(result + "_" + FIELD_TIME, now);
            }
            if (this.config.getFieldsForWhichToIgnoreMemory() != null && this.config.getFieldsForWhichToIgnoreMemory().contains(result)) continue;
            valuesToWrite.put(result + "_" + FIELD_MEMORY, memoryUsageInMB);
        }
        HashMap<String, String> where = new HashMap<String, String>();
        where.putAll(conditions);
        where.put(FIELD_ID, String.valueOf(exp.getId()));
        try {
            return this.adapter.update(this.tablename, valuesToWrite, where) >= 1;
        }
        catch (SQLException e) {
            throw new ExperimentUpdateFailedException(e);
        }
    }

    @Override
    public void finishExperiment(ExperimentDBEntry expEntry, Throwable error) throws ExperimentDBInteractionFailedException {
        HashMap<String, String> valuesToAddAfterRun = new HashMap<String, String>();
        if (error != null) {
            valuesToAddAfterRun.put("exception", LoggerUtil.getExceptionInfo((Throwable)error));
        }
        valuesToAddAfterRun.put(FIELD_TIME_END, new SimpleDateFormat(DATE_FORMAT).format(new Date()));
        this.updateExperiment(expEntry, valuesToAddAfterRun);
    }

    @Override
    public void finishExperiment(ExperimentDBEntry expEntry) throws ExperimentDBInteractionFailedException {
        this.finishExperiment(expEntry, null);
    }

    protected String getDatabaseFieldnameForConfigEntry(String configKey) {
        return configKey.replace("\\.", "_");
    }

    @Override
    public void deleteExperiment(ExperimentDBEntry exp) throws ExperimentDBInteractionFailedException {
        String deleteExperimentQuery = "DELETE FROM `" + this.tablename + "` WHERE experiment_id = " + exp.getId();
        try {
            this.adapter.query(deleteExperimentQuery);
        }
        catch (Exception e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public void deleteDatabase() throws ExperimentDBInteractionFailedException {
        String dropTableQuery = "DROP TABLE `" + this.tablename + "`";
        try {
            this.adapter.query(dropTableQuery);
        }
        catch (Exception e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }

    @Override
    public void startExperiment(ExperimentDBEntry exp) throws ExperimentUpdateFailedException, ExperimentAlreadyStartedException {
        HashMap<String, String> initValues = new HashMap<String, String>();
        initValues.put(FIELD_TIME_START, new SimpleDateFormat(DATE_FORMAT).format(new Date()));
        try {
            initValues.put(FIELD_HOST, InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            throw new ExperimentUpdateFailedException(e);
        }
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put(FIELD_TIME_START, null);
        if (!this.updateExperimentConditionally(exp, condition, initValues)) {
            throw new ExperimentAlreadyStartedException();
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.adapter.setLoggerName(name + ".adapter");
    }

    @Override
    public ExperimentDBEntry getExperimentWithId(int id) throws ExperimentDBInteractionFailedException {
        if (this.config == null || this.keyFields == null) {
            throw new IllegalStateException(ERROR_NOSETUP);
        }
        StringBuilder queryStringSB = new StringBuilder();
        queryStringSB.append("SELECT * FROM `");
        queryStringSB.append(this.tablename);
        queryStringSB.append("` WHERE `experiment_id` = " + id);
        try {
            return this.getExperimentsForSQLQuery(queryStringSB.toString()).get(0);
        }
        catch (SQLException e) {
            throw new ExperimentDBInteractionFailedException(e);
        }
    }
}

