/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.ExperimentSetAnalyzer;
import ai.libs.jaicore.experiments.IExperimentDatabaseHandle;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.IExperimentSetEvaluator;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyStartedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentEvaluationFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentFailurePredictionException;
import ai.libs.jaicore.experiments.exceptions.ExperimentUpdateFailedException;
import ai.libs.jaicore.logging.LoggerUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentRunner
implements ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(ExperimentRunner.class);
    private static final double MAX_MEM_DEVIATION = 0.15;
    private boolean checkMemory = true;
    private final IExperimentSetConfig config;
    private final IExperimentSetEvaluator evaluator;
    private final IExperimentDatabaseHandle handle;
    private final int availableMemoryInMB;
    private final String executorInfo;
    private boolean allExperimentsFinished = false;

    public ExperimentRunner(IExperimentSetConfig config, IExperimentSetEvaluator evaluator, IExperimentDatabaseHandle databaseHandle) throws ExperimentDBInteractionFailedException {
        this(config, evaluator, databaseHandle, null);
    }

    public ExperimentRunner(IExperimentSetConfig config, IExperimentSetEvaluator evaluator, IExperimentDatabaseHandle databaseHandle, String executorInfo) throws ExperimentDBInteractionFailedException {
        if (databaseHandle == null) {
            throw new IllegalArgumentException("Cannot create ExperimentRunner without database handle!");
        }
        this.config = config;
        this.evaluator = evaluator;
        this.handle = databaseHandle;
        this.logger.debug("Created ExperimentRunner. Now updating its configuration from the database.");
        this.logger.info("Successfully created and initialized ExperimentRunner.");
        this.handle.setup(config);
        this.availableMemoryInMB = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        this.executorInfo = executorInfo;
    }

    public void setCheckMemory(boolean checkMemory) {
        this.checkMemory = checkMemory;
    }

    public void randomlyConductExperiments(int maxNumberOfExperiments) throws ExperimentDBInteractionFailedException, InterruptedException {
        this.logger.info("Starting to run up to {} experiments.", (Object)maxNumberOfExperiments);
        int numberOfConductedExperiments = 0;
        while (maxNumberOfExperiments <= 0 || numberOfConductedExperiments < maxNumberOfExperiments) {
            List<ExperimentDBEntry> openRandomExperiments = this.handle.getRandomOpenExperiments(maxNumberOfExperiments);
            if (openRandomExperiments.isEmpty()) {
                this.logger.info("No more open experiments found.");
                this.allExperimentsFinished = true;
                break;
            }
            if (Thread.interrupted()) {
                this.logger.info("Experimenter Thread is interrupted, throwing InterruptedException.");
                throw new InterruptedException();
            }
            ExperimentDBEntry exp = openRandomExperiments.get(0);
            this.checkExperimentValidity(exp.getExperiment());
            this.logger.info("Conduct experiment #{} with key values: {}", (Object)(numberOfConductedExperiments + 1), exp.getExperiment().getValuesOfKeyFields());
            Thread expThread = new Thread(() -> {
                try {
                    this.handle.startExperiment(exp, this.executorInfo);
                    this.conductExperiment(exp);
                }
                catch (InterruptedException e) {
                    this.logger.info("Experiment interrupted.");
                    Thread.currentThread().interrupt();
                }
                catch (ExperimentAlreadyStartedException | ExperimentDBInteractionFailedException e) {
                    this.logger.error(LoggerUtil.getExceptionInfo((Throwable)e));
                }
            }, "Thread of experiment id " + exp.getId());
            expThread.start();
            expThread.join();
            this.logger.info("Finished experiment #{} with key values {}", (Object)(++numberOfConductedExperiments), exp.getExperiment().getValuesOfKeyFields());
        }
        this.logger.info("Successfully finished {} experiments.", (Object)numberOfConductedExperiments);
    }

    public void sequentiallyConductExperiments(int maxNumberOfExperiments) throws ExperimentDBInteractionFailedException, InterruptedException {
        this.logger.info("Starting to run up to {} experiments.", (Object)maxNumberOfExperiments);
        int numberOfConductedExperiments = 0;
        while (maxNumberOfExperiments <= 0 || numberOfConductedExperiments < maxNumberOfExperiments) {
            Optional<ExperimentDBEntry> nextExperiment = this.handle.startNextExperiment(this.executorInfo);
            if (!nextExperiment.isPresent()) {
                this.logger.info("After running {}/{} experiments, no more un-started experiments were found.", (Object)numberOfConductedExperiments, (Object)maxNumberOfExperiments);
                this.allExperimentsFinished = true;
                break;
            }
            if (Thread.interrupted()) {
                this.logger.info("Experimenter Thread is interrupted, throwing InterruptedException.");
                throw new InterruptedException();
            }
            ExperimentDBEntry exp = nextExperiment.get();
            this.checkExperimentValidity(exp.getExperiment());
            this.logger.info("Conduct experiment #{} with key values: {}", (Object)(numberOfConductedExperiments + 1), exp.getExperiment().getValuesOfKeyFields());
            Thread expThread = new Thread(() -> {
                try {
                    this.conductExperiment(exp);
                }
                catch (InterruptedException e) {
                    this.logger.info("Experiment interrupted.");
                    Thread.currentThread().interrupt();
                }
                catch (ExperimentDBInteractionFailedException e) {
                    this.logger.error(LoggerUtil.getExceptionInfo((Throwable)e));
                }
            });
            expThread.start();
            expThread.join();
            this.logger.info("Finished experiment #{} with key values {}", (Object)(++numberOfConductedExperiments), exp.getExperiment().getValuesOfKeyFields());
        }
        this.logger.info("Successfully finished {} experiments.", (Object)numberOfConductedExperiments);
    }

    public void randomlyConductExperiments() throws ExperimentDBInteractionFailedException, InterruptedException {
        this.randomlyConductExperiments(-1);
    }

    public void sequentiallyConductExperiments() throws ExperimentDBInteractionFailedException, InterruptedException {
        this.sequentiallyConductExperiments(-1);
    }

    protected void conductExperiment(ExperimentDBEntry expEntry) throws ExperimentDBInteractionFailedException, InterruptedException {
        if (expEntry == null) {
            throw new IllegalArgumentException("Cannot conduct NULL experiment!");
        }
        assert (this.handle.hasExperimentStarted(expEntry));
        Throwable error = null;
        try {
            double memoryDeviation;
            if (this.checkMemory && (memoryDeviation = (double)((float)Math.abs(expEntry.getExperiment().getMemoryInMB() - this.availableMemoryInMB) * 1.0f / (float)expEntry.getExperiment().getMemoryInMB())) > 0.15) {
                throw new IllegalStateException("Cannot conduct experiment " + expEntry.getExperiment() + ", because the available memory is " + this.availableMemoryInMB + " where declared is " + expEntry.getExperiment().getMemoryInMB() + ". Deviation: " + memoryDeviation);
            }
            if (expEntry.getExperiment().getNumCPUs() > Runtime.getRuntime().availableProcessors()) {
                throw new IllegalStateException("Cannot conduct experiment " + expEntry.getExperiment() + ", because only " + Runtime.getRuntime().availableProcessors() + " CPU cores are available where declared is " + expEntry.getExperiment().getNumCPUs());
            }
            this.evaluator.evaluate(expEntry, m -> {
                try {
                    this.logger.info("Updating experiment with id {} with the following map: {}", (Object)expEntry.getId(), (Object)m);
                    this.handle.updateExperiment(expEntry, m);
                }
                catch (ExperimentUpdateFailedException e) {
                    this.logger.error("Error in updating experiment data. Message of {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                }
            });
        }
        catch (ExperimentEvaluationFailedException e) {
            error = e.getCause();
        }
        catch (ExperimentFailurePredictionException | RuntimeException e) {
            error = e;
        }
        if (error != null) {
            this.logger.error("Experiment failed due to {}. Message: {}. Detail info: {}", new Object[]{error.getClass().getName(), error.getMessage(), LoggerUtil.getExceptionInfo((Throwable)error)});
        }
        this.handle.finishExperiment(expEntry, error);
    }

    private void checkExperimentValidity(Experiment experiment) {
        ExperimentSetAnalyzer analyzer = new ExperimentSetAnalyzer(this.config);
        List keyFields = this.config.getKeyFields().stream().map(k -> (String)analyzer.getNameTypeSplitForAttribute((String)k).getX()).collect(Collectors.toList());
        if (SetUtil.differenceNotEmpty(keyFields, experiment.getValuesOfKeyFields().keySet())) {
            throw new IllegalArgumentException("The experiment " + experiment + " is invalid, because key fields have not been defined: " + SetUtil.difference(this.config.getKeyFields(), experiment.getValuesOfKeyFields().keySet()));
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.handle instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.handle).setLoggerName(name + ".handle");
        }
    }

    public boolean mightHaveMoreExperiments() {
        return !this.allExperimentsFinished;
    }
}

