/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.basic.StringUtil;
import ai.libs.jaicore.basic.sets.LDSRelationComputer;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.RelationComputationProblem;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.IExperimentKeyGenerator;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.exceptions.IllegalExperimentSetupException;
import ai.libs.jaicore.experiments.exceptions.IllegalKeyDescriptorException;
import ai.libs.jaicore.logging.LoggerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentSetAnalyzer {
    private static final String PROTOCOL_JAVA = "java:";
    private static final String LOGMESSAGE_CREATEINSTANCE = "Create a new instance of {} and ask it for the number of possible values.";
    private static final ThreadLocal<ScriptEngine> scriptEngine = ThreadLocal.withInitial(() -> {
        ScriptEngineManager mgr = new ScriptEngineManager();
        return mgr.getEngineByName("JavaScript");
    });
    private final Logger logger = LoggerFactory.getLogger(ExperimentSetAnalyzer.class);
    private final IExperimentSetConfig config;
    private List<String> keyFields;
    private Map<String, List<String>> valuesForKeyFieldsInConfig;
    private List<Map<String, String>> possibleKeyCombinations;
    private Map<String, IExperimentKeyGenerator<?>> valueGeneratorsPerKey = new HashMap();
    private int numExperimentsTotal;

    public ExperimentSetAnalyzer(IExperimentSetConfig config) {
        this.config = config;
        this.reloadConfiguration();
        scriptEngine.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadConfiguration() {
        IExperimentSetConfig iExperimentSetConfig = this.config;
        synchronized (iExperimentSetConfig) {
            this.possibleKeyCombinations = null;
            this.valueGeneratorsPerKey.clear();
            this.keyFields = Collections.unmodifiableList(this.config.getKeyFields().stream().map(k -> (String)this.getNameTypeSplitForAttribute((String)k).getX()).collect(Collectors.toList()));
            this.numExperimentsTotal = 1;
            this.valuesForKeyFieldsInConfig = new HashMap<String, List<String>>();
            for (String key : this.keyFields) {
                String propertyVals = this.config.removeProperty(key);
                if (propertyVals == null) {
                    throw new IllegalArgumentException("Invalid experiment set configuration! No property values defined for key field \"" + key + "\"");
                }
                List vals = Arrays.asList(StringUtil.explode((String)propertyVals, (String)",")).stream().map(String::trim).collect(Collectors.toList());
                this.config.setProperty(key, propertyVals);
                this.valuesForKeyFieldsInConfig.put(key, vals);
                try {
                    this.numExperimentsTotal *= this.getNumberOfValuesForKey(key);
                }
                catch (IllegalKeyDescriptorException e) {
                    this.logger.error(LoggerUtil.getExceptionInfo((Throwable)e));
                }
            }
        }
    }

    public boolean isValueForKeyValid(String key, String value) throws IllegalKeyDescriptorException {
        if (!this.keyFields.contains(key)) {
            throw new IllegalStateException("Key \"" + key + "\" is not defined in experiment setup.");
        }
        List<String> possibleValues = this.valuesForKeyFieldsInConfig.get(key);
        if (possibleValues.isEmpty()) {
            throw new IllegalStateException("No values specified for key " + key);
        }
        if (!possibleValues.get(0).startsWith(PROTOCOL_JAVA)) {
            return possibleValues.contains(value);
        }
        this.checkThatKeyOnlyAllowsOneValue(key);
        try {
            Class<?> c = Class.forName(possibleValues.get(0).substring(PROTOCOL_JAVA.length()).trim());
            this.checkKeyGenerator(c);
            this.logger.trace(LOGMESSAGE_CREATEINSTANCE, (Object)c.getName());
            return ((IExperimentKeyGenerator)c.getConstructor(new Class[0]).newInstance(new Object[0])).isValueValid(value);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalKeyDescriptorException(e);
        }
    }

    public boolean isExperimentInLineWithSetup(Experiment experiment) {
        Collection additionalKeys = SetUtil.difference(experiment.getValuesOfKeyFields().keySet(), this.keyFields);
        List missingKeys = SetUtil.difference(this.keyFields, experiment.getValuesOfKeyFields().keySet());
        if (!additionalKeys.isEmpty() || !missingKeys.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, String> keyEntry : experiment.getValuesOfKeyFields().entrySet()) {
            try {
                if (this.isValueForKeyValid(keyEntry.getKey(), keyEntry.getValue())) continue;
                this.logger.debug("Experiment {} seems outdated. The value {} for key {} is not admissible anymore. Consider removing it.", new Object[]{experiment, keyEntry.getKey(), keyEntry.getValue()});
                return false;
            }
            catch (IllegalKeyDescriptorException e) {
                this.logger.debug("Experiment {} seems outdated. The key {} is not defined in the current setup.", (Object)experiment, (Object)keyEntry.getKey());
                return false;
            }
        }
        return true;
    }

    public List<Map<String, String>> getAllPossibleKeyCombinations() throws IllegalExperimentSetupException, AlgorithmTimeoutedException, InterruptedException, AlgorithmExecutionCanceledException {
        if (this.possibleKeyCombinations == null) {
            this.logger.debug("Computing all possible experiments.");
            ArrayList<List<String>> values = new ArrayList<List<String>>();
            for (String string : this.keyFields) {
                if (!this.valuesForKeyFieldsInConfig.containsKey(string)) {
                    throw new IllegalStateException("No values for key " + string + " have been defined!");
                }
                List<String> valuesForKey = this.getAllValuesForKey(string);
                this.logger.debug("Retrieving {} values for key {}. Enable TRACE to see all values.", (Object)valuesForKey.size(), (Object)string);
                this.logger.trace("Values for key {}: {}", (Object)string, valuesForKey);
                values.add(valuesForKey);
            }
            ArrayList<Predicate> constraints = new ArrayList<Predicate>();
            if (this.config.getConstraints() != null) {
                for (final String p : this.config.getConstraints()) {
                    if (p.startsWith(PROTOCOL_JAVA)) {
                        try {
                            constraints.add((Predicate)Class.forName(p.substring(PROTOCOL_JAVA.length()).trim()).getConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            this.logger.error("Error in loading constraint {}: {}", (Object)p, (Object)LoggerUtil.getExceptionInfo((Throwable)e));
                        }
                        continue;
                    }
                    this.logger.info("Parsing constraint {}", (Object)p);
                    Predicate<List<String>> predicate = new Predicate<List<String>>(){
                        private final int highestRequiredIndex;
                        {
                            this.highestRequiredIndex = ExperimentSetAnalyzer.this.keyFields.stream().filter(p::contains).map(k -> ExperimentSetAnalyzer.this.keyFields.indexOf(k)).max(Integer::compare).get();
                        }

                        @Override
                        public boolean test(List<String> t) {
                            String evaluatedConstraint = p;
                            int n = t.size();
                            if (n <= this.highestRequiredIndex) {
                                return true;
                            }
                            for (int i = 0; i < n; ++i) {
                                evaluatedConstraint = evaluatedConstraint.replace((CharSequence)ExperimentSetAnalyzer.this.keyFields.get(i), t.get(i));
                            }
                            try {
                                ScriptEngine engine = (ScriptEngine)scriptEngine.get();
                                Object evaluation = engine.eval(evaluatedConstraint);
                                if (evaluation instanceof Boolean) {
                                    return (Boolean)evaluation;
                                }
                                ExperimentSetAnalyzer.this.logger.error("The evaluation of constraint={} did not return a boolean but instead: {}. Predicate falls back to `false`. \nThe original constraint is: {}", new Object[]{evaluatedConstraint, evaluation, p});
                                return false;
                            }
                            catch (ScriptException e) {
                                ExperimentSetAnalyzer.this.logger.error(LoggerUtil.getExceptionInfo((Throwable)e));
                                return false;
                            }
                        }
                    };
                    constraints.add(predicate);
                }
            }
            Predicate<List> predicate = t -> {
                for (Predicate c : constraints) {
                    if (c.test(t)) continue;
                    return false;
                }
                return true;
            };
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Building relation from {} cartesian product with {} constraints.", (Object)values.stream().map(l -> "" + l.size()).collect(Collectors.joining(" x ")), (Object)constraints.size());
            }
            RelationComputationProblem problem = constraints.isEmpty() ? new RelationComputationProblem(values) : new RelationComputationProblem(values, predicate);
            LDSRelationComputer lc = new LDSRelationComputer(problem);
            lc.setLoggerName(this.logger.getName() + ".relationcomputer");
            List combinationsAsList = lc.call();
            this.logger.info("Obtained {} key combinations. Now building maps from these.", (Object)combinationsAsList.size());
            this.possibleKeyCombinations = Collections.unmodifiableList(combinationsAsList.stream().map(c -> Collections.unmodifiableMap(this.mapValuesToKeyValueMap((List<String>)c))).collect(Collectors.toList()));
        }
        return this.possibleKeyCombinations;
    }

    private Map<String, String> mapValuesToKeyValueMap(List<String> values) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        for (String key : this.keyFields) {
            map.put(key, values.get(i++));
        }
        return map;
    }

    public int getNumberOfValuesForKey(String key) throws IllegalKeyDescriptorException {
        List<String> possibleValues = this.valuesForKeyFieldsInConfig.get(key);
        if (possibleValues.isEmpty()) {
            return 0;
        }
        if (!possibleValues.get(0).startsWith(PROTOCOL_JAVA)) {
            return possibleValues.size();
        }
        this.checkThatKeyOnlyAllowsOneValue(key);
        try {
            Class<?> c = Class.forName(possibleValues.get(0).substring(PROTOCOL_JAVA.length()).trim());
            this.checkKeyGenerator(c);
            this.logger.trace(LOGMESSAGE_CREATEINSTANCE, (Object)c.getName());
            return ((IExperimentKeyGenerator)c.getConstructor(new Class[0]).newInstance(new Object[0])).getNumberOfValues();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalKeyDescriptorException(e);
        }
    }

    public String getValueForKey(String key, int indexOfValue) {
        List<String> possibleValues = this.valuesForKeyFieldsInConfig.get(key);
        if (possibleValues.isEmpty()) {
            throw new IllegalArgumentException("No values specified for key " + key);
        }
        if (!possibleValues.get(0).startsWith(PROTOCOL_JAVA)) {
            return possibleValues.get(indexOfValue);
        }
        this.checkThatKeyOnlyAllowsOneValue(key);
        IExperimentKeyGenerator keyGenerator = this.valueGeneratorsPerKey.computeIfAbsent(key, k -> {
            try {
                Class<?> c = Class.forName(((String)possibleValues.get(0)).substring(PROTOCOL_JAVA.length()).trim());
                this.checkKeyGenerator(c);
                this.logger.trace(LOGMESSAGE_CREATEINSTANCE, (Object)c.getName());
                return (IExperimentKeyGenerator)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalKeyDescriptorException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        });
        Object value = keyGenerator.getValue(indexOfValue);
        if (value == null) {
            throw new NoSuchElementException("No value could be found for index " + indexOfValue + " in keyfield " + key);
        }
        return value.toString();
    }

    public List<String> getAllValuesForKey(String key) throws IllegalKeyDescriptorException {
        int n = this.getNumberOfValuesForKey(key);
        ArrayList<String> vals = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            vals.add(this.getValueForKey(key, i));
        }
        return Collections.unmodifiableList(vals);
    }

    public int getNumExperimentsTotal() {
        return this.numExperimentsTotal;
    }

    private void checkThatKeyOnlyAllowsOneValue(String key) {
        if (this.valuesForKeyFieldsInConfig.get(key).size() > 1) {
            throw new UnsupportedOperationException("The value for key " + key + " seems to be a java class, but there are multiple values defined.");
        }
    }

    private void checkKeyGenerator(Class<?> c) throws IllegalKeyDescriptorException {
        if (!IExperimentKeyGenerator.class.isAssignableFrom(c)) {
            throw new IllegalKeyDescriptorException("The specified class " + c.getName() + " does not implement the " + IExperimentKeyGenerator.class.getName() + " interface.");
        }
    }

    public Pair<String, String> getNameTypeSplitForAttribute(String name) {
        String[] parts = name.split(":");
        String type = parts.length == 2 ? parts[1] : null;
        return new Pair((Object)parts[0], (Object)type);
    }
}

