/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments.resultcomputers;

import ai.libs.jaicore.basic.MathExt;
import ai.libs.jaicore.experiments.IEventBasedResultUpdater;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Map;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.events.result.IScoredSolutionCandidateFoundEvent;

public class SolutionPerformanceHistoryComputer
implements IEventBasedResultUpdater {
    private ArrayNode observations = new ObjectMapper().createArrayNode();
    private final long start = System.currentTimeMillis();
    private final int saveRate;

    public SolutionPerformanceHistoryComputer(int saveRate) {
        this.saveRate = saveRate;
    }

    @Override
    public void processEvent(IAlgorithmEvent e, Map<String, Object> currentResults) {
        if (e instanceof IScoredSolutionCandidateFoundEvent) {
            double score = (Double)((IScoredSolutionCandidateFoundEvent)e).getScore();
            ArrayNode observation = new ObjectMapper().createArrayNode();
            observation.insert(0, System.currentTimeMillis() - this.start);
            observation.insert(1, MathExt.round((double)score, (int)5));
            this.observations.add((JsonNode)observation);
            if (this.observations.size() % this.saveRate == 0) {
                currentResults.put("history", this.observations);
            }
        }
    }

    @Override
    public void finish(Map<String, Object> currentResults) {
        currentResults.put("history", this.observations);
    }

    @Override
    public void setAlgorithm(IAlgorithm<?, ?> algorithm) {
        throw new UnsupportedOperationException("Setting the algorithm is currently not allowed.");
    }
}

