/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.db.sql.SQLAdapter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentAdditionalTableLoader {
    private static Logger logger = LoggerFactory.getLogger(ExperimentAdditionalTableLoader.class);

    private ExperimentAdditionalTableLoader() {
    }

    public static void executeStatementsFromDirectory(String folder, SQLAdapter adapter) throws IOException {
        try (Stream<Path> paths = Files.walk(Paths.get(folder, new String[0]), new FileVisitOption[0]);){
            paths.filter(f -> f.toFile().isFile()).forEach(file -> {
                try {
                    logger.info("Execute_Statement");
                    ExperimentAdditionalTableLoader.executeStatementInFile(file, adapter);
                }
                catch (IOException e) {
                    logger.warn("Could not load sql file {} for creating tables for the experimenter: {}", (Object)file.getFileName(), (Object)e.getMessage());
                }
                catch (SQLException e) {
                    logger.warn("Could not execute sql in the file {} and not create the table for the experimenter: {}", (Object)file.getFileName(), (Object)e.getMessage());
                }
            });
        }
    }

    private static void executeStatementInFile(Path file, SQLAdapter adapter) throws IOException, SQLException {
        String createTableStatement = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        String insertValuesStatement = null;
        String insertInto = "INSERT INTO";
        if (createTableStatement.contains(insertInto)) {
            String[] parts = createTableStatement.split(insertInto);
            createTableStatement = parts[0];
            insertValuesStatement = insertInto + parts[1];
        }
        adapter.update(createTableStatement);
        logger.info("Executed SQL statement: {}", (Object)createTableStatement);
        if (insertValuesStatement != null) {
            adapter.update(insertValuesStatement);
            logger.info("Executed SQL statement: {}", (Object)createTableStatement);
        }
    }
}

