/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.ExperimentSetAnalyzer;
import ai.libs.jaicore.experiments.IExperimentDatabaseHandle;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyExistsInDatabaseException;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.IllegalExperimentSetupException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentDatabasePreparer
implements ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(ExperimentDatabasePreparer.class);
    private final IExperimentSetConfig experimentConfig;
    private final ExperimentSetAnalyzer configAnalyzer;
    private final IExperimentDatabaseHandle handle;
    private final int memoryLimit;
    private final int cpuLimit;

    public ExperimentDatabasePreparer(IExperimentSetConfig config, IExperimentDatabaseHandle databaseHandle) {
        if (config.getKeyFields() == null) {
            throw new IllegalArgumentException("Configuration has not defined any key fields. Make sure to specify the keyfields entry in the config file.");
        }
        if (config.getMemoryLimitInMB() == null) {
            throw new IllegalArgumentException("Memory field (mem.max) must be set in configuration");
        }
        if (config.getNumberOfCPUs() == null) {
            throw new IllegalArgumentException("Max CPU field (cpu.max) must be set in configuration");
        }
        if (config.getKeyFields() == null) {
            throw new IllegalArgumentException("Key fields (keyfields) entry must be set in configuration!");
        }
        if (config.getResultFields() == null) {
            throw new IllegalArgumentException("Result fields (resultfields) entry must be set in configuration!");
        }
        this.memoryLimit = config.getMemoryLimitInMB();
        this.cpuLimit = config.getNumberOfCPUs();
        this.configAnalyzer = new ExperimentSetAnalyzer(config);
        this.handle = databaseHandle;
        this.experimentConfig = config;
        this.logger.info("Successfully created and initialized ExperimentDatabasePreparer.");
    }

    public List<ExperimentDBEntry> synchronizeExperiments() throws ExperimentDBInteractionFailedException, IllegalExperimentSetupException, ExperimentAlreadyExistsInDatabaseException, AlgorithmTimeoutedException, InterruptedException, AlgorithmExecutionCanceledException {
        this.logger.info("Creating experiment table if not existent.");
        this.handle.setup(this.experimentConfig);
        this.logger.info("Table ready. Now synchronizing experiments.");
        ArrayList<Map<String, String>> tmpPossibleKeyCombinations = new ArrayList<Map<String, String>>(this.configAnalyzer.getAllPossibleKeyCombinations());
        this.logger.debug("Determined {} possible combinations. Will now remove keys that are already contained.", (Object)tmpPossibleKeyCombinations.size());
        List<ExperimentDBEntry> installedExperiments = this.handle.getAllExperiments();
        this.logger.debug("Identified {} installed experiments. Removing these from the list of all possible experiments.", (Object)installedExperiments.size());
        int removed = 0;
        for (ExperimentDBEntry experiment : installedExperiments) {
            if (tmpPossibleKeyCombinations.contains(experiment.getExperiment().getValuesOfKeyFields())) {
                tmpPossibleKeyCombinations.remove(experiment.getExperiment().getValuesOfKeyFields());
                ++removed;
                continue;
            }
            this.logger.warn("Experiment with id {} and keys {} seems outdated. The reason can be an illegal key name or an outdated value for one of the keys. Enable DEBUG mode for more details.", (Object)experiment.getId(), experiment.getExperiment().getValuesOfKeyFields());
        }
        this.logger.debug("{} experiments already exist. Number of experiments that will be created now is {}.", (Object)removed, (Object)tmpPossibleKeyCombinations.size());
        if (tmpPossibleKeyCombinations.isEmpty()) {
            return new ArrayList<ExperimentDBEntry>(0);
        }
        List<ExperimentDBEntry> entries = this.handle.createOrGetExperiments(tmpPossibleKeyCombinations.stream().map(t -> new Experiment(this.memoryLimit, this.cpuLimit, (Map<String, String>)t)).collect(Collectors.toList()));
        this.logger.info("Ids of {} inserted entries: {}", (Object)entries.size(), entries.stream().map(ExperimentDBEntry::getId).collect(Collectors.toList()));
        return entries;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.handle instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.handle).setLoggerName(name + ".handle");
        }
    }

    public ExperimentSetAnalyzer getConfigAnalyzer() {
        return this.configAnalyzer;
    }

    public IExperimentDatabaseHandle getHandle() {
        return this.handle;
    }
}

