/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.db.IDatabaseConfig;
import ai.libs.jaicore.db.sql.rest.IRestDatabaseConfig;
import ai.libs.jaicore.experiments.AlgorithmBenchmarker;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.ExperimentDatabasePreparer;
import ai.libs.jaicore.experiments.ExperimentDomain;
import ai.libs.jaicore.experiments.ExperimentRunner;
import ai.libs.jaicore.experiments.IExperimentBuilder;
import ai.libs.jaicore.experiments.IExperimentDatabaseHandle;
import ai.libs.jaicore.experiments.IExperimentRunController;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.IExperimentSetEvaluator;
import ai.libs.jaicore.experiments.databasehandle.ExperimenterMySQLHandle;
import ai.libs.jaicore.experiments.databasehandle.ExperimenterRestSQLHandle;
import ai.libs.jaicore.experiments.exceptions.ExperimentAlreadyExistsInDatabaseException;
import ai.libs.jaicore.experiments.exceptions.ExperimentDBInteractionFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentEvaluationFailedException;
import ai.libs.jaicore.experiments.exceptions.ExperimentFailurePredictionException;
import ai.libs.jaicore.experiments.exceptions.IllegalExperimentSetupException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.aeonbits.owner.ConfigFactory;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimenterFrontend
implements ILoggingCustomizable {
    private static final String MSG_NO_MORE_EXPERIMENTS = "No more experiments to conduct.";
    private static final String MSG_NOTABLE = "No table set in the database configuration!";
    private IExperimentSetConfig config;
    private IExperimentDatabaseHandle databaseHandle;
    private IExperimentSetEvaluator evaluator;
    private ExperimentDomain<?, ?, ?> domain;
    private IExperimentRunController<?> controller;
    private String loggerNameForAlgorithm;
    private ExperimentRunner runner;
    private String executorInfo;
    private Logger logger = LoggerFactory.getLogger((String)"expfe");

    public ExperimenterFrontend withLoggerNameForAlgorithm(String loggerName) {
        this.loggerNameForAlgorithm = loggerName;
        return this;
    }

    public ExperimenterFrontend withDatabaseConfig(String databaseConfigFileName) {
        return this.withDatabaseConfig(new File(databaseConfigFileName));
    }

    public ExperimenterFrontend withDatabaseConfig(File ... databaseConfigFiles) {
        return this.withDatabaseConfig((IDatabaseConfig)((IDatabaseConfig)ConfigFactory.create(IDatabaseConfig.class, (Map[])new Map[0])).loadPropertiesFromFileArray(databaseConfigFiles));
    }

    public ExperimenterFrontend withRestDatabaseConfig(File ... databaseConfigFiles) {
        return this.withDatabaseConfig((IRestDatabaseConfig)((IRestDatabaseConfig)ConfigFactory.create(IRestDatabaseConfig.class, (Map[])new Map[0])).loadPropertiesFromFileArray(databaseConfigFiles));
    }

    public ExperimenterFrontend withDatabaseConfig(IRestDatabaseConfig databaseConfig) {
        this.databaseHandle = new ExperimenterRestSQLHandle(databaseConfig);
        if (databaseConfig.getTable() == null) {
            throw new IllegalArgumentException(MSG_NOTABLE);
        }
        return this;
    }

    public ExperimenterFrontend withDatabaseConfig(IDatabaseConfig databaseConfig) {
        this.databaseHandle = new ExperimenterMySQLHandle(databaseConfig);
        if (databaseConfig.getDBTableName() == null) {
            throw new IllegalArgumentException(MSG_NOTABLE);
        }
        return this;
    }

    public ExperimenterFrontend withExperimentsConfig(File configFile) {
        return this.withExperimentsConfig((IExperimentSetConfig)((IExperimentSetConfig)ConfigFactory.create(IExperimentSetConfig.class, (Map[])new Map[0])).loadPropertiesFromFile(configFile));
    }

    public ExperimenterFrontend withExperimentsConfig(IExperimentSetConfig config) {
        this.config = config;
        return this;
    }

    public ExperimenterFrontend clearDatabase() throws ExperimentDBInteractionFailedException {
        this.databaseHandle.deleteDatabase();
        return this;
    }

    public ExperimenterFrontend withEvaluator(IExperimentSetEvaluator evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    public ExperimenterFrontend withExecutorInfo(String executorInfo) {
        this.executorInfo = executorInfo;
        return this;
    }

    public String getExecutorInfo() {
        return this.executorInfo;
    }

    public <B extends IExperimentBuilder, I, A extends IAlgorithm<? extends I, ?>> ExperimenterFrontend withDomain(ExperimentDomain<B, I, A> domain) {
        this.evaluator = null;
        this.withExperimentsConfig(domain.getConfig());
        this.domain = domain;
        return this;
    }

    public ExperimenterFrontend withController(IExperimentRunController<?> controller) {
        this.controller = controller;
        return this;
    }

    public ExperimenterFrontend synchronizeDatabase() throws ExperimentDBInteractionFailedException, AlgorithmTimeoutedException, IllegalExperimentSetupException, ExperimentAlreadyExistsInDatabaseException, InterruptedException, AlgorithmExecutionCanceledException {
        ExperimentDatabasePreparer preparer = new ExperimentDatabasePreparer(this.config, this.databaseHandle);
        preparer.setLoggerName(this.getLoggerName() + ".preparer");
        preparer.synchronizeExperiments();
        return this;
    }

    private void prepareEvaluator() {
        if (this.evaluator != null) {
            throw new IllegalStateException("An evaluator has already been set manually. Preparing a domain specific one afterwards and overriding the manually set is not allowed!");
        }
        if (this.controller == null) {
            throw new IllegalStateException("Cannot prepare evaluator, because no experiment controller has been set!");
        }
        if (this.domain != null) {
            this.evaluator = new AlgorithmBenchmarker(this.domain.getDecoder(), this.controller);
            ((AlgorithmBenchmarker)this.evaluator).setLoggerName(this.loggerNameForAlgorithm != null ? this.loggerNameForAlgorithm : this.getLoggerName() + ".evaluator");
        }
    }

    private ExperimentRunner getExperimentRunner() throws ExperimentDBInteractionFailedException {
        if (this.runner == null) {
            if (this.config == null) {
                throw new IllegalStateException("Cannot conduct experiments. No experiment config has been set, yet.");
            }
            if (this.databaseHandle == null) {
                throw new IllegalStateException("Cannot conduct experiments. No database handle has been set, yet.");
            }
            if (this.evaluator == null) {
                this.prepareEvaluator();
            }
            this.runner = new ExperimentRunner(this.config, this.evaluator, this.databaseHandle, this.executorInfo);
            this.runner.setLoggerName(this.getLoggerName() + ".runner");
        }
        return this.runner;
    }

    public void randomlyConductExperiments() throws ExperimentDBInteractionFailedException, InterruptedException {
        if (!this.getExperimentRunner().mightHaveMoreExperiments()) {
            throw new IllegalStateException(MSG_NO_MORE_EXPERIMENTS);
        }
        this.getExperimentRunner().randomlyConductExperiments();
    }

    public void sequentiallyConductExperiments() throws ExperimentDBInteractionFailedException, InterruptedException {
        if (!this.getExperimentRunner().mightHaveMoreExperiments()) {
            throw new IllegalStateException(MSG_NO_MORE_EXPERIMENTS);
        }
        this.getExperimentRunner().sequentiallyConductExperiments();
    }

    public ExperimenterFrontend randomlyConductExperiments(int limit) throws ExperimentDBInteractionFailedException, InterruptedException {
        if (!this.getExperimentRunner().mightHaveMoreExperiments()) {
            throw new IllegalStateException(MSG_NO_MORE_EXPERIMENTS);
        }
        this.getExperimentRunner().randomlyConductExperiments(limit);
        return this;
    }

    public boolean mightHaveMoreExperiments() throws ExperimentDBInteractionFailedException {
        return this.getExperimentRunner().mightHaveMoreExperiments();
    }

    public <O> O simulateExperiment(Experiment experiment, IExperimentRunController<O> controller) throws ExperimentEvaluationFailedException, InterruptedException, ExperimentFailurePredictionException {
        this.withController(controller);
        this.prepareEvaluator();
        ExperimentDBEntry experimentEntry = new ExperimentDBEntry(-1, experiment);
        HashMap<String, Object> results = new HashMap<String, Object>();
        this.evaluator.evaluate(experimentEntry, results::putAll);
        Experiment expCopy = new Experiment(experiment);
        expCopy.setValuesOfResultFields(results);
        return controller.parseResultMap(expCopy);
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }
}

