/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentSetAnalyzer;
import ai.libs.jaicore.experiments.IExperimentBuilder;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.experiments.exceptions.IllegalKeyDescriptorException;
import ai.libs.jaicore.logging.LoggerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AExperimentBuilder<B extends AExperimentBuilder<B>>
implements IExperimentBuilder {
    protected Logger logger = LoggerFactory.getLogger((String)("builder." + this.getClass().getName()));
    private int memory;
    private int numCPUs;
    private final Map<String, String> keyMap = new HashMap<String, String>();
    private final IExperimentSetConfig config;
    private final Class<?> configClass;
    private final ExperimentSetAnalyzer analyzer;

    public AExperimentBuilder(IExperimentSetConfig config) {
        this.config = config;
        Class<?> tmpConfigClass = null;
        for (Class<?> c : this.config.getClass().getInterfaces()) {
            if (!IExperimentSetConfig.class.isAssignableFrom(c)) continue;
            if (tmpConfigClass != null) {
                throw new IllegalStateException("Config interface is not unique!");
            }
            tmpConfigClass = c;
        }
        if (tmpConfigClass == null) {
            throw new IllegalArgumentException("Could not identify config interface of the given configuration");
        }
        this.configClass = tmpConfigClass;
        this.analyzer = new ExperimentSetAnalyzer(config);
    }

    protected void set(String key, Object value) {
        String valAsString = value.toString();
        try {
            if (!this.analyzer.isValueForKeyValid(key, valAsString)) {
                throw new IllegalArgumentException("\"" + valAsString + "\" is not a valid value for key \"" + key + "\"");
            }
        }
        catch (IllegalKeyDescriptorException e) {
            throw new IllegalArgumentException("\"" + key + "\" is not a valid key in this experiment setup.");
        }
        this.keyMap.put(key, valAsString);
    }

    protected abstract B getMe();

    public B withMem(int memoryInMB) {
        this.memory = memoryInMB;
        return this.getMe();
    }

    public B withCPUs(int numCPUs) {
        this.numCPUs = numCPUs;
        return this.getMe();
    }

    public B fork() {
        try {
            AExperimentBuilder builder;
            AExperimentBuilder cBuilder = builder = (AExperimentBuilder)this.getMe().getClass().getConstructor(this.configClass).newInstance(this.config);
            cBuilder.keyMap.putAll(this.keyMap);
            cBuilder.memory = this.memory;
            cBuilder.numCPUs = this.numCPUs;
            return (B)builder;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error(LoggerUtil.getExceptionInfo((Throwable)e));
            return null;
        }
    }

    public B withExperiment(Experiment experiment) {
        this.keyMap.putAll(experiment.getValuesOfKeyFields());
        this.memory = experiment.getMemoryInMB();
        this.numCPUs = experiment.getNumCPUs();
        return this.getMe();
    }

    @Override
    public Experiment build() {
        ExperimentSetAnalyzer ea = new ExperimentSetAnalyzer(this.config);
        List keyFieldNames = this.config.getKeyFields().stream().map(f -> (String)ea.getNameTypeSplitForAttribute((String)f).getX()).collect(Collectors.toList());
        if (!this.keyMap.keySet().containsAll(keyFieldNames)) {
            throw new IllegalStateException("Cannot build experiment. Required fields have not been defined: " + SetUtil.difference(keyFieldNames, this.keyMap.keySet()));
        }
        this.preBuildHook();
        return new Experiment(this.memory, this.numCPUs, this.keyMap);
    }

    protected void preBuildHook() {
    }
}

