/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.experiments.Experiment;
import ai.libs.jaicore.experiments.ExperimentDBEntry;
import ai.libs.jaicore.experiments.IEventBasedResultUpdater;
import ai.libs.jaicore.experiments.IExperimentDecoder;
import ai.libs.jaicore.experiments.IExperimentIntermediateResultProcessor;
import ai.libs.jaicore.experiments.IExperimentRunController;
import ai.libs.jaicore.experiments.IExperimentSetEvaluator;
import ai.libs.jaicore.experiments.IExperimentTerminationCriterion;
import ai.libs.jaicore.experiments.exceptions.ExperimentEvaluationFailedException;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmBenchmarker
implements IExperimentSetEvaluator,
ILoggingCustomizable {
    private final IExperimentRunController<?> controller;
    private final Caps<?, ?> caps;
    private Function<Experiment, Timeout> experimentSpecificTimeout;
    private Timeout timeout;
    private Logger logger = LoggerFactory.getLogger(AlgorithmBenchmarker.class);
    private Thread eventThread;
    private final List<Consumer<IAlgorithm<?, ?>>> preRunHooks = new ArrayList();

    public <I, A extends IAlgorithm<? extends I, ?>> AlgorithmBenchmarker(IExperimentDecoder<I, A> decoder, IExperimentRunController<?> controller) {
        this.caps = new Caps<I, A>(decoder);
        this.controller = controller;
    }

    @Override
    public final void evaluate(ExperimentDBEntry experimentEntry, IExperimentIntermediateResultProcessor processor) throws ExperimentEvaluationFailedException, InterruptedException {
        try {
            this.logger.info("Starting evaluation of experiment entry with keys {}", experimentEntry.getExperiment().getValuesOfKeyFields());
            IAlgorithm algorithm = (IAlgorithm)((Caps)this.caps).decoder.getAlgorithm(experimentEntry.getExperiment());
            this.logger.debug("Created algorithm {} of class {} for problem instance {}. Configuring logger name if possible.", new Object[]{algorithm, algorithm.getClass(), algorithm.getInput()});
            if (algorithm instanceof ILoggingCustomizable) {
                ((ILoggingCustomizable)algorithm).setLoggerName(this.getLoggerName() + ".algorithm");
            }
            if (this.experimentSpecificTimeout != null) {
                Timeout to = this.experimentSpecificTimeout.apply(experimentEntry.getExperiment());
                algorithm.setTimeout(to);
                this.logger.info("Set algorithm timeout to experiment specific timeout: {}", (Object)to);
            } else if (this.timeout != null) {
                algorithm.setTimeout(this.timeout);
                this.logger.info("Set algorithm timeout to general timeout: {}", (Object)this.timeout);
            }
            List<IEventBasedResultUpdater> resultUpdaters = this.controller.getResultUpdaterComputer(experimentEntry.getExperiment());
            resultUpdaters.forEach(ru -> ru.setAlgorithm(algorithm));
            List<IExperimentTerminationCriterion> terminationCriteria = this.controller.getTerminationCriteria(experimentEntry.getExperiment());
            final LinkedBlockingQueue eventQueue = new LinkedBlockingQueue();
            this.eventThread = new Thread(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    IAlgorithmEvent e;
                    try {
                        e = (IAlgorithmEvent)eventQueue.take();
                    }
                    catch (InterruptedException e1) {
                        break;
                    }
                    HashMap<String, Object> results = new HashMap<String, Object>();
                    for (IEventBasedResultUpdater updater : resultUpdaters) {
                        updater.processEvent(e, results);
                    }
                    if (!results.isEmpty()) {
                        processor.processResults(results);
                    }
                    if (!terminationCriteria.stream().anyMatch(c -> c.doesTerminate(e, algorithm))) continue;
                    this.logger.info("Stopping algorithm execution, because termination criterion fired.");
                    algorithm.cancel();
                    return;
                }
            }, "Experiment Event Processor");
            this.eventThread.start();
            algorithm.registerListener(new Object(){

                @Subscribe
                public void receiveEvent(IAlgorithmEvent e) {
                    eventQueue.add(e);
                }
            });
            this.preRunHooks.forEach(h -> h.accept(algorithm));
            this.logger.info("Running call method on {}", (Object)algorithm);
            try {
                algorithm.call();
            }
            catch (AlgorithmTimeoutedException e) {
                this.logger.info("Algorithm timed out.");
            }
            HashMap<String, Object> results = new HashMap<String, Object>();
            for (IEventBasedResultUpdater updater : resultUpdaters) {
                updater.finish(results);
            }
            if (!results.isEmpty()) {
                processor.processResults(results);
            }
        }
        catch (Throwable e1) {
            throw new ExperimentEvaluationFailedException(e1);
        }
        finally {
            if (this.eventThread != null) {
                this.eventThread.interrupt();
                this.eventThread = null;
            }
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Loggername is now {}", (Object)name);
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Timeout timeout) {
        this.timeout = timeout;
    }

    public Function<Experiment, Timeout> getExperimentSpecificTimeout() {
        return this.experimentSpecificTimeout;
    }

    public void setExperimentSpecificTimeout(Function<Experiment, Timeout> experimentSpecificTimeout) {
        this.experimentSpecificTimeout = experimentSpecificTimeout;
    }

    public void addPreRunHook(Consumer<IAlgorithm<?, ?>> hook) {
        this.preRunHooks.add(hook);
    }

    private class Caps<I, A extends IAlgorithm<? extends I, ?>> {
        private final IExperimentDecoder<I, A> decoder;

        public Caps(IExperimentDecoder<I, A> decoder) {
            this.decoder = decoder;
        }
    }
}

