/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import java.util.HashMap;
import java.util.Map;

public class Experiment {
    private final int memoryInMB;
    private final int numCPUs;
    private Map<String, String> valuesOfKeyFields;
    private Map<String, Object> valuesOfResultFields;
    private final String error;

    public Experiment(Experiment experiment) {
        this(experiment.getMemoryInMB(), experiment.getNumCPUs(), new HashMap<String, String>(experiment.getValuesOfKeyFields()), (Map<String, Object>)(experiment.getValuesOfResultFields() != null ? new HashMap<String, Object>(experiment.getValuesOfResultFields()) : null));
    }

    public Experiment(int memoryInMB, int numCPUs, Map<String, String> valuesOfKeyFields) {
        this(memoryInMB, numCPUs, valuesOfKeyFields, null);
    }

    public Experiment(int memoryInMB, int numCPUs, Map<String, String> valuesOfKeyFields, Map<String, Object> valuesOfResultFields) {
        this(memoryInMB, numCPUs, valuesOfKeyFields, valuesOfResultFields, "");
    }

    public Experiment(int memoryInMB, int numCPUs, Map<String, String> valuesOfKeyFields, Map<String, Object> valuesOfResultFields, String error) {
        this.memoryInMB = memoryInMB;
        this.numCPUs = numCPUs;
        this.valuesOfKeyFields = valuesOfKeyFields;
        this.valuesOfResultFields = valuesOfResultFields;
        this.error = error;
    }

    public Map<String, String> getValuesOfKeyFields() {
        return this.valuesOfKeyFields;
    }

    public Map<String, Object> getValuesOfResultFields() {
        return this.valuesOfResultFields;
    }

    public Map<String, Object> getJointMapOfKeysAndResults() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.valuesOfKeyFields);
        map.putAll(this.valuesOfResultFields);
        return map;
    }

    public void setValuesOfResultFields(Map<String, Object> valuesOfResultFields) {
        this.valuesOfResultFields = valuesOfResultFields;
    }

    public void setKeys(Map<String, String> keys) {
        this.valuesOfKeyFields = keys;
    }

    public int getMemoryInMB() {
        return this.memoryInMB;
    }

    public int getNumCPUs() {
        return this.numCPUs;
    }

    public String getError() {
        return this.error;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.memoryInMB;
        result = 31 * result + this.numCPUs;
        result = 31 * result + (this.valuesOfKeyFields == null ? 0 : this.valuesOfKeyFields.hashCode());
        result = 31 * result + (this.valuesOfResultFields == null ? 0 : this.valuesOfResultFields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Experiment other = (Experiment)obj;
        if (this.memoryInMB != other.memoryInMB) {
            return false;
        }
        if (this.numCPUs != other.numCPUs) {
            return false;
        }
        if (this.valuesOfKeyFields == null ? other.valuesOfKeyFields != null : !this.valuesOfKeyFields.equals(other.valuesOfKeyFields)) {
            return false;
        }
        return !(this.valuesOfResultFields == null ? other.valuesOfResultFields != null : !this.valuesOfResultFields.equals(other.valuesOfResultFields));
    }
}

