/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.experiments;

import ai.libs.jaicore.experiments.IExperimentBuilder;
import ai.libs.jaicore.experiments.IExperimentDecoder;
import ai.libs.jaicore.experiments.IExperimentSetConfig;
import ai.libs.jaicore.logging.LoggerUtil;
import java.lang.reflect.InvocationTargetException;
import org.api4.java.algorithm.IAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExperimentDomain<B extends IExperimentBuilder, I, A extends IAlgorithm<? extends I, ?>> {
    protected Logger logger = LoggerFactory.getLogger((String)"experimentsdomain");
    private final IExperimentSetConfig config;
    private final IExperimentDecoder<I, A> decoder;

    public ExperimentDomain(IExperimentSetConfig config, IExperimentDecoder<I, A> decoder) {
        this.config = config;
        this.decoder = decoder;
    }

    public IExperimentSetConfig getConfig() {
        return this.config;
    }

    public IExperimentDecoder<I, A> getDecoder() {
        return this.decoder;
    }

    public abstract Class<B> getBuilderClass();

    public B newBuilder() {
        try {
            return (B)((IExperimentBuilder)this.getBuilderClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error(LoggerUtil.getExceptionInfo((Throwable)e));
            return null;
        }
    }
}

