/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.plugin.graphview;

import ai.libs.jaicore.graphvisualizer.events.gui.DefaultGUIEventBus;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.GraphViewPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.NodeClickedEvent;
import org.graphstream.graph.Node;
import org.graphstream.ui.view.ViewerListener;
import org.graphstream.ui.view.ViewerPipe;

public class GraphMouseListener
implements ViewerListener,
Runnable {
    private boolean active;
    private GraphViewPluginModel viewModel;
    private ViewerPipe viewerPipe;

    public GraphMouseListener(GraphViewPluginModel viewModel, ViewerPipe viewerPipe) {
        this.viewModel = viewModel;
        this.viewerPipe = viewerPipe;
        this.active = true;
    }

    public void buttonPushed(String id) {
        Node viewGraphNode = this.viewModel.getGraph().getNode(id);
        Object searchGraphNode = this.viewModel.getSearchGraphNodeMappedToViewGraphNode(viewGraphNode);
        DefaultGUIEventBus.getInstance().postEvent(new NodeClickedEvent(viewGraphNode, searchGraphNode));
    }

    public void buttonReleased(String id) {
    }

    public void mouseLeft(String id) {
    }

    public void mouseOver(String id) {
    }

    public void viewClosed(String id) {
        this.active = false;
    }

    @Override
    public void run() {
        while (this.active) {
            this.viewerPipe.pump();
        }
    }
}

