/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.plugin.graphview;

import ai.libs.jaicore.basic.ResourceUtil;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.GraphViewPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.graphview.ViewGraphManipulationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.IdAlreadyInUseException;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;

public class GraphViewPluginModel
implements IGUIPluginModel {
    private static final String STYLESHEET_URL = "url('" + ResourceUtil.getResourceAsFile((String)"searchgraph.css") + "')";
    private int nodeIdCounter;
    private GraphViewPluginView view;
    private Graph graph;
    private ConcurrentMap<Object, Node> searchGraphNodesToViewGraphNodesMap;
    private ConcurrentMap<Node, Object> viewGraphNodesToSearchGraphNodesMap;
    private ConcurrentMap<Node, Set<Edge>> nodeToConnectedEdgesMap;

    public GraphViewPluginModel(GraphViewPluginView view) {
        this(view, STYLESHEET_URL);
    }

    public GraphViewPluginModel(GraphViewPluginView view, String searchGraphCSSPath) {
        this.view = view;
        this.searchGraphNodesToViewGraphNodesMap = new ConcurrentHashMap<Object, Node>();
        this.viewGraphNodesToSearchGraphNodesMap = new ConcurrentHashMap<Node, Object>();
        this.nodeToConnectedEdgesMap = new ConcurrentHashMap<Node, Set<Edge>>();
        this.nodeIdCounter = 0;
        this.initializeGraph(searchGraphCSSPath);
    }

    private void initializeGraph(String styleSheetURL) {
        this.graph = new SingleGraph("Search Graph");
        this.graph.setAttribute("ui.stylesheet", new Object[]{styleSheetURL});
    }

    public void addNode(Object node, List<Object> predecessorNodes, String typeOfNode) throws ViewGraphManipulationException {
        try {
            Node viewNode = this.graph.addNode(String.valueOf(this.nodeIdCounter));
            this.registerNodeMapping(node, viewNode);
            for (Object predecessorNode : predecessorNodes) {
                this.createEdge(node, predecessorNode);
            }
            this.switchNodeType(viewNode, typeOfNode);
            this.view.update();
            ++this.nodeIdCounter;
        }
        catch (IdAlreadyInUseException exception) {
            throw new ViewGraphManipulationException("Cannot add node " + node + " as the id " + this.nodeIdCounter + " is already in use.");
        }
    }

    private void createEdge(Object node, Object predecessorNode) throws ViewGraphManipulationException {
        Node viewNode = (Node)this.searchGraphNodesToViewGraphNodesMap.get(node);
        Node viewPredecessorNode = (Node)this.searchGraphNodesToViewGraphNodesMap.get(predecessorNode);
        if (viewPredecessorNode == null) {
            throw new ViewGraphManipulationException("Cannot add edge from node " + predecessorNode + " to node " + viewNode + " due to missing view node of predecessor.");
        }
        String edgeId = viewPredecessorNode.getId() + "-" + viewNode.getId();
        Edge edge = this.graph.addEdge(edgeId, viewPredecessorNode, viewNode, true);
        this.registerEdgeConnectedToNodesInMap(edge);
    }

    private void registerNodeMapping(Object node, Node viewNode) {
        this.searchGraphNodesToViewGraphNodesMap.put(node, viewNode);
        this.viewGraphNodesToSearchGraphNodesMap.put(viewNode, node);
    }

    private void registerEdgeConnectedToNodesInMap(Edge edge) {
        if (!this.nodeToConnectedEdgesMap.containsKey(edge.getNode0())) {
            this.nodeToConnectedEdgesMap.put(edge.getNode0(), new HashSet());
        }
        ((Set)this.nodeToConnectedEdgesMap.get(edge.getNode0())).add(edge);
        if (!this.nodeToConnectedEdgesMap.containsKey(edge.getNode1())) {
            this.nodeToConnectedEdgesMap.put(edge.getNode1(), new HashSet());
        }
        ((Set)this.nodeToConnectedEdgesMap.get(edge.getNode1())).add(edge);
    }

    public void switchNodeType(Object node, String newType) throws ViewGraphManipulationException {
        if (node == null) {
            throw new ViewGraphManipulationException("Cannot switch type of null node.");
        }
        Node viewNode = (Node)this.searchGraphNodesToViewGraphNodesMap.get(node);
        if (viewNode == null) {
            throw new ViewGraphManipulationException("Cannot switch type of node " + node + " without corresponding view node.");
        }
        this.switchNodeType(viewNode, newType);
        this.view.update();
    }

    private void switchNodeType(Node node, String newType) {
        if (!this.isLabeledAsRootNode(node)) {
            node.setAttribute("ui.class", new Object[]{newType});
        }
    }

    private boolean isLabeledAsRootNode(Node node) {
        return node.getAttribute("ui.class") != null && node.getAttribute("ui.class").equals("root");
    }

    public void removeNode(Object node) throws ViewGraphManipulationException {
        if (node == null) {
            throw new ViewGraphManipulationException("Cannot remove null node.");
        }
        Node viewNode = (Node)this.searchGraphNodesToViewGraphNodesMap.remove(node);
        if (viewNode == null) {
            throw new ViewGraphManipulationException("Cannot remove node " + node + " without corresponding view node.");
        }
        this.viewGraphNodesToSearchGraphNodesMap.remove(viewNode);
        Set connectedEdges = (Set)this.nodeToConnectedEdgesMap.remove(viewNode);
        this.graph.removeNode(viewNode);
        for (Edge edge : connectedEdges) {
            Node otherNode = edge.getNode0().equals(viewNode) ? edge.getNode1() : edge.getNode0();
            Set connectedEdgesOfOtherNode = (Set)this.nodeToConnectedEdgesMap.get(otherNode);
            connectedEdgesOfOtherNode.remove(edge);
            this.graph.removeEdge(edge);
        }
    }

    public void reset() {
        this.graph.clear();
        this.graph.setAttribute("ui.stylesheet", new Object[]{STYLESHEET_URL});
        this.searchGraphNodesToViewGraphNodesMap.clear();
        this.viewGraphNodesToSearchGraphNodesMap.clear();
        this.nodeToConnectedEdgesMap.clear();
        this.view.update();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Object getSearchGraphNodeMappedToViewGraphNode(Object searchGraphNode) {
        return this.viewGraphNodesToSearchGraphNodesMap.get(searchGraphNode);
    }
}

