/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.ScoredSolutionCandidateFoundEvent;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginController;
import ai.libs.jaicore.graphvisualizer.plugin.controlbar.ResetEvent;
import ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter.SolutionPerformanceTimelinePlugin;
import ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter.SolutionPerformanceTimelinePluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter.SolutionPerformanceTimelinePluginView;
import ai.libs.jaicore.graphvisualizer.plugin.timeslider.GoToTimeStepEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionPerformanceTimelinePluginController
extends ASimpleMVCPluginController<SolutionPerformanceTimelinePluginModel, SolutionPerformanceTimelinePluginView> {
    private Logger logger = LoggerFactory.getLogger(SolutionPerformanceTimelinePlugin.class);

    public SolutionPerformanceTimelinePluginController(SolutionPerformanceTimelinePluginModel model, SolutionPerformanceTimelinePluginView view) {
        super(model, view);
    }

    @Override
    public void handleGUIEvent(GUIEvent guiEvent) {
        if (guiEvent instanceof ResetEvent || guiEvent instanceof GoToTimeStepEvent) {
            ((SolutionPerformanceTimelinePluginModel)this.getModel()).clear();
        }
    }

    @Override
    public void handleAlgorithmEventInternally(AlgorithmEvent algorithmEvent) {
        if (algorithmEvent instanceof ScoredSolutionCandidateFoundEvent) {
            this.logger.debug("Received solution event {}", (Object)algorithmEvent);
            ScoredSolutionCandidateFoundEvent event = (ScoredSolutionCandidateFoundEvent)algorithmEvent;
            if (!(event.getScore() instanceof Number)) {
                this.logger.warn("Received SolutionCandidateFoundEvent, but the score is of type {}, which is not a number.", (Object)event.getScore().getClass().getName());
                return;
            }
            this.logger.debug("Adding solution to model and updating view.");
            ((SolutionPerformanceTimelinePluginModel)this.getModel()).addEntry(event);
        } else {
            this.logger.trace("Received and ignored irrelevant event {}", (Object)algorithmEvent);
        }
    }
}

