/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.window;

import ai.libs.jaicore.basic.algorithm.IAlgorithm;
import ai.libs.jaicore.graphvisualizer.events.graph.bus.AlgorithmEventSource;
import ai.libs.jaicore.graphvisualizer.events.gui.DefaultGUIEventBus;
import ai.libs.jaicore.graphvisualizer.events.recorder.AlgorithmEventHistory;
import ai.libs.jaicore.graphvisualizer.events.recorder.AlgorithmEventHistoryEntryDeliverer;
import ai.libs.jaicore.graphvisualizer.events.recorder.AlgorithmEventHistoryRecorder;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPlugin;
import ai.libs.jaicore.graphvisualizer.plugin.controlbar.ControlBarGUIPlugin;
import ai.libs.jaicore.graphvisualizer.plugin.speedslider.SpeedSliderGUIPlugin;
import ai.libs.jaicore.graphvisualizer.plugin.timeslider.TimeSliderGUIPlugin;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public class AlgorithmVisualizationWindow
implements Runnable {
    private AlgorithmEventSource algorithmEventSource;
    private AlgorithmEventHistoryEntryDeliverer algorithmEventHistoryPuller;
    private List<IGUIPlugin> visualizationPlugins;
    private IGUIPlugin mainPlugin;
    private TimeSliderGUIPlugin timeSliderGUIPlugin;
    private ControlBarGUIPlugin controlBarGUIPlugin;
    private SpeedSliderGUIPlugin speedSliderGUIPlugin;
    private String title = "MLPlan Graph Search Visualization";
    private Stage stage;
    private BorderPane rootLayout;
    private BorderPane topLayout;
    private TabPane pluginTabPane;

    public AlgorithmVisualizationWindow(AlgorithmEventHistory algorithmEventHistory, IGUIPlugin mainPlugin, IGUIPlugin ... visualizationPlugins) {
        this.mainPlugin = mainPlugin;
        this.algorithmEventHistoryPuller = new AlgorithmEventHistoryEntryDeliverer(algorithmEventHistory);
        this.algorithmEventSource = this.algorithmEventHistoryPuller;
        this.initializePlugins(visualizationPlugins);
        DefaultGUIEventBus.getInstance().registerListener(this.algorithmEventHistoryPuller);
    }

    public AlgorithmVisualizationWindow(IAlgorithm<?, ?> algorithm, IGUIPlugin mainPlugin, IGUIPlugin ... visualizationPlugins) {
        this.mainPlugin = mainPlugin;
        AlgorithmEventHistoryRecorder historyRecorder = new AlgorithmEventHistoryRecorder();
        algorithm.registerListener((Object)historyRecorder);
        this.algorithmEventHistoryPuller = new AlgorithmEventHistoryEntryDeliverer(historyRecorder.getHistory());
        this.algorithmEventSource = this.algorithmEventHistoryPuller;
        this.initializePlugins(visualizationPlugins);
        DefaultGUIEventBus.getInstance().registerListener(this.algorithmEventHistoryPuller);
    }

    private void initializePlugins(IGUIPlugin ... visualizationPlugins) {
        this.mainPlugin.setAlgorithmEventSource(this.algorithmEventSource);
        this.mainPlugin.setGUIEventSource(DefaultGUIEventBus.getInstance());
        this.timeSliderGUIPlugin = new TimeSliderGUIPlugin();
        this.timeSliderGUIPlugin.setAlgorithmEventSource(this.algorithmEventSource);
        this.timeSliderGUIPlugin.setGUIEventSource(DefaultGUIEventBus.getInstance());
        this.controlBarGUIPlugin = new ControlBarGUIPlugin();
        this.controlBarGUIPlugin.setAlgorithmEventSource(this.algorithmEventSource);
        this.controlBarGUIPlugin.setGUIEventSource(DefaultGUIEventBus.getInstance());
        this.speedSliderGUIPlugin = new SpeedSliderGUIPlugin();
        this.speedSliderGUIPlugin.setAlgorithmEventSource(this.algorithmEventSource);
        this.speedSliderGUIPlugin.setGUIEventSource(DefaultGUIEventBus.getInstance());
        this.visualizationPlugins = new ArrayList<IGUIPlugin>(visualizationPlugins.length);
        for (IGUIPlugin graphVisualizationPlugin : visualizationPlugins) {
            this.visualizationPlugins.add(graphVisualizationPlugin);
            graphVisualizationPlugin.setAlgorithmEventSource(this.algorithmEventSource);
            graphVisualizationPlugin.setGUIEventSource(DefaultGUIEventBus.getInstance());
        }
    }

    @Override
    public void run() {
        this.rootLayout = new BorderPane();
        this.initializeTopLayout();
        this.initializeCenterLayout();
        this.initializeBottomLayout();
        this.initializePluginTabs();
        Scene scene = new Scene((Parent)this.rootLayout, 800.0, 300.0);
        this.stage = new Stage();
        this.stage.setScene(scene);
        this.stage.setTitle(this.title);
        this.stage.setMaximized(true);
        this.stage.show();
        this.algorithmEventHistoryPuller.start();
    }

    private void initializeTopLayout() {
        this.topLayout = new BorderPane();
        this.initializeTopButtonToolBar();
        this.initializeVisualizationSpeedSlider();
        this.rootLayout.setTop((Node)this.topLayout);
    }

    private void initializeTopButtonToolBar() {
        this.topLayout.setTop(this.controlBarGUIPlugin.getView().getNode());
    }

    private void initializeVisualizationSpeedSlider() {
        this.topLayout.setBottom(this.speedSliderGUIPlugin.getView().getNode());
    }

    private void initializeCenterLayout() {
        SplitPane centerSplitLayout = new SplitPane();
        centerSplitLayout.setDividerPosition(0, 0.25);
        this.pluginTabPane = new TabPane();
        centerSplitLayout.getItems().add((Object)this.pluginTabPane);
        centerSplitLayout.getItems().add((Object)this.mainPlugin.getView().getNode());
        this.rootLayout.setCenter((Node)centerSplitLayout);
    }

    private void initializeBottomLayout() {
        this.rootLayout.setBottom(this.timeSliderGUIPlugin.getView().getNode());
    }

    private void initializePluginTabs() {
        for (IGUIPlugin plugin : this.visualizationPlugins) {
            Tab pluginTab = new Tab(plugin.getView().getTitle(), plugin.getView().getNode());
            this.pluginTabPane.getTabs().add((Object)pluginTab);
        }
    }

    public void setTitle(String title) {
        this.title = title;
        this.stage.setTitle(title);
    }
}

