/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.events.gui;

import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEventBus;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEventListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGUIEventBus
implements GUIEventBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGUIEventBus.class);
    private static DefaultGUIEventBus singletonInstance;
    private List<GUIEventListener> guiEventListeners = Collections.synchronizedList(new LinkedList());

    private DefaultGUIEventBus() {
    }

    @Override
    public void registerListener(GUIEventListener graphEventListener) {
        this.guiEventListeners.add(graphEventListener);
    }

    @Override
    public void unregisterListener(GUIEventListener graphEventListener) {
        this.guiEventListeners.remove(graphEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postEvent(GUIEvent guiEvent) {
        DefaultGUIEventBus defaultGUIEventBus = this;
        synchronized (defaultGUIEventBus) {
            for (GUIEventListener listener : this.guiEventListeners) {
                this.passEventToListener(guiEvent, listener);
            }
        }
    }

    private void passEventToListener(GUIEvent guiEvent, GUIEventListener listener) {
        try {
            listener.handleGUIEvent(guiEvent);
        }
        catch (Exception exception) {
            LOGGER.error("Error while passing GUIEvent {}\u00c2\u00a0to handler {}.", new Object[]{guiEvent, listener, exception});
        }
    }

    public static synchronized GUIEventBus getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DefaultGUIEventBus();
        }
        return singletonInstance;
    }
}

