/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.events.gui;

import ai.libs.jaicore.graphvisualizer.IntegerAxisFormatter;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.util.StringConverter;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class Histogram
extends BarChart<String, Number> {
    private final XYChart.Series<String, Number> series = new XYChart.Series();
    private final ObservableList<XYChart.Data<String, Number>> histogramData;
    private int max;
    private int n;

    public Histogram(int n) {
        super((Axis)new CategoryAxis(), (Axis)new NumberAxis());
        this.n = n;
        this.getData().add(this.series);
        ArrayList<XYChart.Data> values = new ArrayList<XYChart.Data>();
        for (int i = 0; i < n; ++i) {
            values.add(new XYChart.Data((Object)("" + i), (Object)0));
        }
        this.histogramData = FXCollections.observableList(values);
        this.series.setData(this.histogramData);
        ((NumberAxis)this.getYAxis()).setMinorTickVisible(false);
        this.setAnimated(false);
        this.setLegendVisible(false);
        ((NumberAxis)this.getYAxis()).setTickUnit(1.0);
        ((NumberAxis)this.getYAxis()).setTickLabelFormatter((StringConverter)new IntegerAxisFormatter());
        ((NumberAxis)this.getYAxis()).setMinorTickCount(0);
    }

    public void update(DescriptiveStatistics stats) {
        int[] histogram = new int[this.n];
        double[] values = stats.getValues();
        double min = stats.getMin();
        double stepSize = (stats.getMax() - min) / (double)this.n;
        block0: for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (!(values[i] <= min + (double)j * stepSize)) continue;
                int n = j;
                histogram[n] = histogram[n] + 1;
                continue block0;
            }
        }
        this.update(histogram);
    }

    public void update(List<? extends Number> values) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        values.forEach(v -> stats.addValue(((Double)v).doubleValue()));
        this.update(stats);
    }

    public void update(int[] values) {
        ArrayList<XYChart.Data> transformedValues = new ArrayList<XYChart.Data>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] > this.max) {
                this.max = values[i];
            }
            transformedValues.add(new XYChart.Data((Object)("" + i), (Object)values[i]));
        }
        this.histogramData.setAll(transformedValues);
    }

    public void clear() {
        this.max = 0;
        this.histogramData.clear();
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }
}

