/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.events.recorder;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.bus.AlgorithmEventListener;
import ai.libs.jaicore.graphvisualizer.events.graph.bus.AlgorithmEventSource;
import ai.libs.jaicore.graphvisualizer.events.graph.bus.HandleAlgorithmEventException;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEventListener;
import ai.libs.jaicore.graphvisualizer.events.recorder.AlgorithmEventHistory;
import ai.libs.jaicore.graphvisualizer.events.recorder.AlgorithmEventHistoryEntry;
import ai.libs.jaicore.graphvisualizer.plugin.controlbar.PauseEvent;
import ai.libs.jaicore.graphvisualizer.plugin.controlbar.PlayEvent;
import ai.libs.jaicore.graphvisualizer.plugin.controlbar.ResetEvent;
import ai.libs.jaicore.graphvisualizer.plugin.speedslider.ChangeSpeedEvent;
import ai.libs.jaicore.graphvisualizer.plugin.timeslider.GoToTimeStepEvent;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmEventHistoryEntryDeliverer
extends Thread
implements AlgorithmEventSource,
GUIEventListener {
    private Logger logger = LoggerFactory.getLogger(AlgorithmEventHistoryEntryDeliverer.class);
    private Set<AlgorithmEventListener> algorithmEventListeners;
    private AlgorithmEventHistory eventHistory;
    private int maximumSleepTimeInMilliseconds;
    private int timestep;
    private boolean paused;
    private double sleepTimeMultiplier;

    public AlgorithmEventHistoryEntryDeliverer(AlgorithmEventHistory eventHistory, int maximumSleepTimeInMilliseconds) {
        this.eventHistory = eventHistory;
        this.maximumSleepTimeInMilliseconds = maximumSleepTimeInMilliseconds;
        this.timestep = 0;
        this.paused = true;
        this.algorithmEventListeners = ConcurrentHashMap.newKeySet();
        this.sleepTimeMultiplier = 1.0;
        this.setDaemon(true);
        this.logger.info("{} started with thread {}", (Object)this.getClass().getSimpleName(), (Object)this.getName());
    }

    public AlgorithmEventHistoryEntryDeliverer(AlgorithmEventHistory eventHistory) {
        this(eventHistory, 30);
    }

    @Override
    public void registerListener(AlgorithmEventListener algorithmEventListener) {
        this.algorithmEventListeners.add(algorithmEventListener);
    }

    @Override
    public void unregisterListener(AlgorithmEventListener algorithmEventListener) {
        this.algorithmEventListeners.remove(algorithmEventListener);
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            if (!this.paused && (long)this.timestep < this.eventHistory.getLength()) {
                AlgorithmEventHistoryEntry historyEntry = this.eventHistory.getEntryAtTimeStep(this.timestep);
                AlgorithmEvent algorithmEvent = historyEntry.getAlgorithmEvent();
                this.logger.debug("Pulled event entry {} associated with event {} at position {}.", new Object[]{historyEntry, algorithmEvent, this.timestep});
                this.sendAlgorithmEventToListeners(algorithmEvent);
                ++this.timestep;
            } else if (this.paused) {
                this.logger.debug("Not processing events since visualization is paused.");
            } else if ((long)this.timestep >= this.eventHistory.getLength()) {
                this.logger.debug("Not processing events since no unpublished events are known.");
            }
            try {
                this.goToSleep();
            }
            catch (InterruptedException e) {
                this.logger.info("{} has been interrupted: {}.", (Object)this.getClass().getSimpleName(), (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void goToSleep() throws InterruptedException {
        int sleepTime = (int)(this.sleepTimeMultiplier * (double)this.maximumSleepTimeInMilliseconds);
        this.logger.trace("Sleeping {}ms.", (Object)sleepTime);
        AlgorithmEventHistoryEntryDeliverer.sleep(sleepTime);
    }

    private void sendAlgorithmEventToListeners(AlgorithmEvent algorithmEvent) {
        for (AlgorithmEventListener eventListener : this.algorithmEventListeners) {
            try {
                this.sendAlgorithmEventToListener(algorithmEvent, eventListener);
            }
            catch (Exception e) {
                this.logger.error("Error in dispatching event {} due to error.", (Object)algorithmEvent, (Object)e);
            }
        }
        this.logger.info("Pulled and sent event {} as entry at time step {}.", (Object)algorithmEvent, (Object)this.timestep);
    }

    private void sendAlgorithmEventToListener(AlgorithmEvent algorithmEvent, AlgorithmEventListener eventListener) throws HandleAlgorithmEventException {
        this.logger.debug("Sending event {} to listener {}.", (Object)algorithmEvent, (Object)eventListener);
        long startTime = System.currentTimeMillis();
        eventListener.handleAlgorithmEvent(algorithmEvent);
        long dispatchTime = System.currentTimeMillis() - startTime;
        if (dispatchTime > 10L) {
            this.logger.warn("Dispatch time for event {} to listener {} took {}ms!", new Object[]{algorithmEvent, eventListener, dispatchTime});
        }
    }

    @Override
    public void handleGUIEvent(GUIEvent guiEvent) {
        if (guiEvent instanceof PauseEvent) {
            this.pause();
        } else if (guiEvent instanceof PlayEvent) {
            this.unpause();
        } else if (guiEvent instanceof ResetEvent) {
            this.handleResetEvent();
        } else if (guiEvent instanceof GoToTimeStepEvent) {
            this.handleGoToTimeStepEvent(guiEvent);
        } else if (guiEvent instanceof ChangeSpeedEvent) {
            this.handleChangeSpeedEvent(guiEvent);
        }
    }

    private void pause() {
        this.paused = true;
    }

    private void unpause() {
        this.paused = false;
    }

    private void handleResetEvent() {
        this.resetTimeStep();
        this.pause();
    }

    private void resetTimeStep() {
        this.timestep = 0;
    }

    private void handleGoToTimeStepEvent(GUIEvent guiEvent) {
        this.resetTimeStep();
        GoToTimeStepEvent goToTimeStepEvent = (GoToTimeStepEvent)guiEvent;
        while (this.timestep < goToTimeStepEvent.getNewTimeStep() && (long)this.timestep < this.eventHistory.getLength()) {
            AlgorithmEvent algorithmEvent = this.eventHistory.getEntryAtTimeStep(this.timestep).getAlgorithmEvent();
            this.sendAlgorithmEventToListeners(algorithmEvent);
            ++this.timestep;
        }
    }

    private void handleChangeSpeedEvent(GUIEvent guiEvent) {
        ChangeSpeedEvent changeSpeedEvent = (ChangeSpeedEvent)guiEvent;
        this.sleepTimeMultiplier = 1.0 - (double)changeSpeedEvent.getNewSpeedPercentage() / 100.0;
    }
}

