/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.plugin;

import ai.libs.jaicore.graphvisualizer.events.graph.bus.AlgorithmEventListener;
import ai.libs.jaicore.graphvisualizer.events.graph.bus.AlgorithmEventSource;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEventListener;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEventSource;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginController;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPlugin;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASimpleMVCPlugin<M extends ASimpleMVCPluginModel<V, C>, V extends ASimpleMVCPluginView<M, C, ?>, C extends ASimpleMVCPluginController<M, V>>
implements IGUIPlugin {
    private final Logger logger = LoggerFactory.getLogger(ASimpleMVCPlugin.class);
    private final M model;
    private final V view;
    private final C controller;

    public ASimpleMVCPlugin() {
        ASimpleMVCPluginController myController;
        ASimpleMVCPluginView myView;
        ASimpleMVCPluginModel myModel;
        Type[] mvcPatternClasses = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(mvcPatternClasses[0].getTypeName().replaceAll("(<.*>)", ""));
            }
            Class<?> modelClass = Class.forName(this.getClassNameWithoutGenerics(mvcPatternClasses[0].getTypeName()));
            Class<?> viewClass = Class.forName(this.getClassNameWithoutGenerics(mvcPatternClasses[1].getTypeName()));
            Class<?> controllerClass = Class.forName(this.getClassNameWithoutGenerics(mvcPatternClasses[2].getTypeName()));
            myModel = (ASimpleMVCPluginModel)modelClass.newInstance();
            myView = (ASimpleMVCPluginView)viewClass.getDeclaredConstructor(modelClass).newInstance(myModel);
            myController = (ASimpleMVCPluginController)controllerClass.getDeclaredConstructor(modelClass, viewClass).newInstance(myModel, myView);
            myController.setDaemon(true);
            myController.start();
        }
        catch (Exception e) {
            this.logger.error("Could not initialize {} due to exception in building MVC.", (Object)this, (Object)e);
            this.model = null;
            this.view = null;
            this.controller = null;
            return;
        }
        this.model = myModel;
        this.view = myView;
        this.controller = myController;
        ((ASimpleMVCPluginModel)this.model).setController((ASimpleMVCPluginController)myController);
        ((ASimpleMVCPluginModel)this.model).setView((ASimpleMVCPluginView)myView);
        ((ASimpleMVCPluginView)this.view).setController((ASimpleMVCPluginController)myController);
    }

    public C getController() {
        return this.controller;
    }

    public M getModel() {
        return (M)((ASimpleMVCPluginModel)((ASimpleMVCPluginView)this.view).getModel());
    }

    public V getView() {
        return this.view;
    }

    @Override
    public void setAlgorithmEventSource(AlgorithmEventSource graphEventSource) {
        graphEventSource.registerListener((AlgorithmEventListener)this.controller);
    }

    @Override
    public void setGUIEventSource(GUIEventSource guiEventSource) {
        guiEventSource.registerListener((GUIEventListener)this.controller);
    }

    private String getClassNameWithoutGenerics(String className) {
        return className.replaceAll("(<.*>)", "");
    }
}

