/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graphvisualizer.plugin;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.bus.HandleAlgorithmEventException;
import ai.libs.jaicore.graphvisualizer.events.gui.GUIEvent;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPluginController;
import ai.libs.jaicore.graphvisualizer.plugin.controlbar.ResetEvent;
import ai.libs.jaicore.graphvisualizer.plugin.timeslider.GoToTimeStepEvent;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASimpleMVCPluginController<M extends ASimpleMVCPluginModel<?, ?>, V extends ASimpleMVCPluginView<?, ?, ?>>
extends Thread
implements IGUIPluginController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ASimpleMVCPluginController.class);
    private final Queue<AlgorithmEvent> eventQueue;
    private final V view;
    private final M model;

    public ASimpleMVCPluginController(M model, V view) {
        this.model = model;
        this.view = view;
        this.eventQueue = new ConcurrentLinkedQueue<AlgorithmEvent>();
    }

    public M getModel() {
        return this.model;
    }

    public V getView() {
        return this.view;
    }

    @Override
    public final void handleAlgorithmEvent(AlgorithmEvent algorithmEvent) throws HandleAlgorithmEventException {
        this.eventQueue.add(algorithmEvent);
    }

    @Override
    public void run() {
        while (true) {
            AlgorithmEvent event;
            if ((event = this.eventQueue.poll()) == null) {
                continue;
            }
            try {
                this.handleAlgorithmEventInternally(event);
                continue;
            }
            catch (HandleAlgorithmEventException e) {
                LOGGER.error("An error occurred while handling event {}.", (Object)event, (Object)e);
                continue;
            }
            break;
        }
    }

    protected abstract void handleAlgorithmEventInternally(AlgorithmEvent var1) throws HandleAlgorithmEventException;

    @Override
    public void handleGUIEvent(GUIEvent guiEvent) {
        if (guiEvent instanceof ResetEvent || guiEvent instanceof GoToTimeStepEvent) {
            ((ASimpleMVCPluginModel)this.getModel()).clear();
            ((ASimpleMVCPluginView)this.getView()).clear();
        }
    }
}

